/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;

public class OptimalAssignment {
    private Map<String, ResourceAssignment> _optimalAssignment = Collections.emptyMap();
    private Map<AssignableReplica, Map<AssignableNode, List<String>>> _failedAssignments = new HashMap<AssignableReplica, Map<AssignableNode, List<String>>>();

    public void updateAssignments(ClusterModel clusterModel) {
        HashMap<String, ResourceAssignment> assignmentMap = new HashMap<String, ResourceAssignment>();
        for (AssignableNode node : clusterModel.getAssignableNodes().values()) {
            for (AssignableReplica replica : node.getAssignedReplicas()) {
                String resourceName = replica.getResourceName();
                Partition partition = new Partition(replica.getPartitionName());
                ResourceAssignment resourceAssignment = assignmentMap.computeIfAbsent(resourceName, key -> new ResourceAssignment(resourceName));
                Map<String, String> partitionStateMap = resourceAssignment.getReplicaMap(partition);
                if (partitionStateMap.isEmpty()) {
                    partitionStateMap = new HashMap<String, String>();
                }
                partitionStateMap.put(node.getInstanceName(), replica.getReplicaState());
                resourceAssignment.addReplicaMap(partition, partitionStateMap);
            }
        }
        this._optimalAssignment = assignmentMap;
    }

    public Map<String, ResourceAssignment> getOptimalResourceAssignment() {
        if (this.hasAnyFailure()) {
            throw new HelixException("Cannot get the optimal resource assignment since a calculation failure is recorded. " + this.getFailures());
        }
        return this._optimalAssignment;
    }

    public void recordAssignmentFailure(AssignableReplica replica, Map<AssignableNode, List<String>> failedReasons) {
        this._failedAssignments.put(replica, failedReasons);
    }

    public boolean hasAnyFailure() {
        return !this._failedAssignments.isEmpty();
    }

    public String getFailures() {
        return this._failedAssignments.toString();
    }
}

