/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobQueuesResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(JobQueuesResource.class);

    public JobQueuesResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            presentation = this.getHostedEntitiesRepresentation(clusterName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Fail to get all job queues", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getHostedEntitiesRepresentation(String clusterName) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Map resourceConfigMap = accessor.getChildValuesMap(keyBuilder.resourceConfigs());
        ZNRecord hostedEntitiesRecord = new ZNRecord("JobQueues");
        Iterator it = resourceConfigMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            HelixProperty resource = (HelixProperty)e.getValue();
            Map simpleFields = resource.getRecord().getSimpleFields();
            boolean isTerminable = resource.getRecord().getBooleanField(WorkflowConfig.WorkflowConfigProperty.Terminable.name(), true);
            if (simpleFields.containsKey(WorkflowConfig.WorkflowConfigProperty.TargetState.name()) && simpleFields.containsKey(WorkflowConfig.WorkflowConfigProperty.Dag.name()) && !isTerminable) continue;
            it.remove();
        }
        ArrayList allResources = Lists.newArrayList(resourceConfigMap.keySet());
        hostedEntitiesRecord.setListField("JobQueues", (List)allResources);
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(hostedEntitiesRecord), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            Form form = new Form(entity);
            if (form.size() < 1) {
                throw new HelixException("Yaml job queue config is required!");
            }
            Parameter payload = (Parameter)form.get(0);
            String yamlPayload = payload.getName();
            if (yamlPayload == null) {
                throw new HelixException("Yaml job queue config is required!");
            }
            Workflow workflow = Workflow.parse((String)yamlPayload);
            JobQueue.Builder jobQueueCfgBuilder = new JobQueue.Builder(workflow.getName());
            jobQueueCfgBuilder.fromMap(workflow.getWorkflowConfig().getResourceConfigMap());
            TaskDriver driver = new TaskDriver((HelixZkClient)zkClient, clusterName);
            driver.createQueue(jobQueueCfgBuilder.build());
            this.getResponse().setEntity((Representation)this.getHostedEntitiesRepresentation(clusterName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Exception in posting job queue: " + entity, (Throwable)e);
        }
        return null;
    }
}

