/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.WorkflowDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRebalancer
extends TaskRebalancer {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowRebalancer.class);
    private WorkflowDispatcher _workflowDispatcher = new WorkflowDispatcher();

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(WorkflowControllerDataProvider clusterData, IdealState taskIs, Resource resource, CurrentStateOutput currStateOutput) {
        String workflow = resource.getResourceName();
        long startTime = System.currentTimeMillis();
        LOG.debug("Computer Best Partition for workflow: " + workflow);
        this._workflowDispatcher.init(this._manager);
        WorkflowContext workflowCtx = this._workflowDispatcher.getOrInitializeWorkflowContext(workflow, clusterData.getTaskDataCache());
        WorkflowConfig workflowCfg = clusterData.getWorkflowConfig(workflow);
        this._workflowDispatcher.setClusterStatusMonitor(this._clusterStatusMonitor);
        this._workflowDispatcher.updateCache(clusterData);
        this._workflowDispatcher.updateWorkflowStatus(workflow, workflowCfg, workflowCtx, currStateOutput, new BestPossibleStateOutput());
        this._workflowDispatcher.assignWorkflow(workflow, workflowCfg, workflowCtx, currStateOutput, new BestPossibleStateOutput());
        LOG.debug(String.format("WorkflowRebalancer computation takes %d ms for workflow %s", System.currentTimeMillis() - startTime, workflow));
        return this.buildEmptyAssignment(workflow, currStateOutput);
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, WorkflowControllerDataProvider clusterData) {
        return currentIdealState;
    }
}

