/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.protobuf;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.CacheEvictionStatsBuilder;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ServerTask;
import org.apache.hadoop.hbase.ServerTaskBuilder;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.BalancerDecision;
import org.apache.hadoop.hbase.client.BalancerRejection;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OnlineLogRecord;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLoadStats;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SlowLogParams;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.protobuf.ProtobufMessageConverter;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RecentLogs;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.apache.hbase.thirdparty.com.google.gson.JsonArray;
import org.apache.hbase.thirdparty.com.google.gson.JsonElement;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.GeneratedMessageV3;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.Parser;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ProtobufUtil {
    private static final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private static final Result EMPTY_RESULT = Result.create(EMPTY_CELL_ARRAY);
    static final Result EMPTY_RESULT_EXISTS_TRUE = Result.create(null, true);
    static final Result EMPTY_RESULT_EXISTS_FALSE = Result.create(null, false);
    private static final Result EMPTY_RESULT_STALE = Result.create(EMPTY_CELL_ARRAY, null, true);
    private static final Result EMPTY_RESULT_EXISTS_TRUE_STALE = Result.create((Cell[])null, (Boolean)true, true);
    private static final Result EMPTY_RESULT_EXISTS_FALSE_STALE = Result.create((Cell[])null, (Boolean)false, true);
    private static final ClientProtos.Result EMPTY_RESULT_PB;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
    private static volatile boolean classLoaderLoaded;

    private ProtobufUtil() {
    }

    public static boolean isClassLoaderLoaded() {
        return classLoaderLoaded;
    }

    public static byte[] prependPBMagic(byte[] bytes) {
        return Bytes.add(ProtobufMagic.PB_MAGIC, bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes) {
        return ProtobufMagic.isPBMagicPrefix(bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes, int offset, int len) {
        return ProtobufMagic.isPBMagicPrefix(bytes, offset, len);
    }

    public static void expectPBMagicPrefix(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            String bytesPrefix = bytes == null ? "null" : Bytes.toStringBinary(bytes, 0, ProtobufMagic.PB_MAGIC.length);
            throw new DeserializationException("Missing pb magic " + Bytes.toString(ProtobufMagic.PB_MAGIC) + " prefix, bytes: " + bytesPrefix);
        }
    }

    public static int lengthOfPBMagic() {
        return ProtobufMagic.lengthOfPBMagic();
    }

    public static ComparatorProtos.ByteArrayComparable toByteArrayComparable(byte[] value) {
        ComparatorProtos.ByteArrayComparable.Builder builder = ComparatorProtos.ByteArrayComparable.newBuilder();
        if (value != null) {
            builder.setValue(UnsafeByteOperations.unsafeWrap(value));
        }
        return builder.build();
    }

    public static IOException getRemoteException(ServiceException se) {
        return ProtobufUtil.makeIOExceptionOfException(se);
    }

    public static IOException handleRemoteException(Exception e) {
        return ProtobufUtil.makeIOExceptionOfException(e);
    }

    private static IOException makeIOExceptionOfException(Exception e) {
        Throwable t = e;
        if (e instanceof ServiceException) {
            t = e.getCause();
        }
        if (ExceptionUtil.isInterrupt(t)) {
            return ExceptionUtil.asInterrupt(t);
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        return t instanceof IOException ? (IOException)t : new HBaseIOException(t);
    }

    public static HBaseProtos.ServerName toServerName(ServerName serverName) {
        if (serverName == null) {
            return null;
        }
        HBaseProtos.ServerName.Builder builder = HBaseProtos.ServerName.newBuilder();
        builder.setHostName(serverName.getHostname());
        if (serverName.getPort() >= 0) {
            builder.setPort(serverName.getPort());
        }
        if (serverName.getStartcode() >= 0L) {
            builder.setStartCode(serverName.getStartcode());
        }
        return builder.build();
    }

    public static ServerName toServerName(HBaseProtos.ServerName proto) {
        if (proto == null) {
            return null;
        }
        String hostName = proto.getHostName();
        long startCode = -1L;
        int port = -1;
        if (proto.hasPort()) {
            port = proto.getPort();
        }
        if (proto.hasStartCode()) {
            startCode = proto.getStartCode();
        }
        return ServerName.valueOf(hostName, port, startCode);
    }

    public static List<ServerName> toServerNameList(List<HBaseProtos.ServerName> proto) {
        return proto.stream().map(ProtobufUtil::toServerName).collect(Collectors.toList());
    }

    public static List<NamespaceDescriptor> toNamespaceDescriptorList(MasterProtos.ListNamespaceDescriptorsResponse proto) {
        return proto.getNamespaceDescriptorList().stream().map(ProtobufUtil::toNamespaceDescriptor).collect(Collectors.toList());
    }

    public static List<TableDescriptor> toTableDescriptorList(MasterProtos.GetTableDescriptorsResponse proto) {
        if (proto == null) {
            return new ArrayList<TableDescriptor>();
        }
        return proto.getTableSchemaList().stream().map(ProtobufUtil::toTableDescriptor).collect(Collectors.toList());
    }

    public static List<TableDescriptor> toTableDescriptorList(MasterProtos.ListTableDescriptorsByNamespaceResponse proto) {
        if (proto == null) {
            return new ArrayList<TableDescriptor>();
        }
        return proto.getTableSchemaList().stream().map(ProtobufUtil::toTableDescriptor).collect(Collectors.toList());
    }

    public static byte[][] getSplitKeysArray(MasterProtos.CreateTableRequest proto) {
        byte[][] splitKeys = new byte[proto.getSplitKeysCount()][];
        for (int i = 0; i < proto.getSplitKeysCount(); ++i) {
            splitKeys[i] = proto.getSplitKeys(i).toByteArray();
        }
        return splitKeys;
    }

    public static Durability toDurability(ClientProtos.MutationProto.Durability proto) {
        switch (proto) {
            case USE_DEFAULT: {
                return Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return Durability.FSYNC_WAL;
            }
        }
        return Durability.USE_DEFAULT;
    }

    public static ClientProtos.MutationProto.Durability toDurability(Durability d) {
        switch (d) {
            case USE_DEFAULT: {
                return ClientProtos.MutationProto.Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return ClientProtos.MutationProto.Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return ClientProtos.MutationProto.Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return ClientProtos.MutationProto.Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return ClientProtos.MutationProto.Durability.FSYNC_WAL;
            }
        }
        return ClientProtos.MutationProto.Durability.USE_DEFAULT;
    }

    public static Get toGet(ClientProtos.Get proto) throws IOException {
        if (proto == null) {
            return null;
        }
        byte[] row = proto.getRow().toByteArray();
        Get get = new Get(row);
        if (proto.hasCacheBlocks()) {
            get.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            get.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            get.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            get.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.toTimeRange(cftr.getTimeRange());
                get.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange.getMin(), timeRange.getMax());
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.toTimeRange(proto.getTimeRange());
            get.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            get.setFilter(ProtobufUtil.toFilter(filter));
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        get.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                get.addFamily(family);
            }
        }
        if (proto.hasExistenceOnly() && proto.getExistenceOnly()) {
            get.setCheckExistenceOnly(true);
        }
        if (proto.hasConsistency()) {
            get.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            get.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        return get;
    }

    public static Consistency toConsistency(ClientProtos.Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return Consistency.STRONG;
            }
            case TIMELINE: {
                return Consistency.TIMELINE;
            }
        }
        return Consistency.STRONG;
    }

    public static ClientProtos.Consistency toConsistency(Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return ClientProtos.Consistency.STRONG;
            }
            case TIMELINE: {
                return ClientProtos.Consistency.TIMELINE;
            }
        }
        return ClientProtos.Consistency.STRONG;
    }

    public static Put toPut(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toPut(proto, null);
    }

    public static Put toPut(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.PUT) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Put put = proto.hasRow() ? new Put(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (put == null) {
                    put = new Put(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                put.add(cell);
            }
        } else {
            if (put == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    long ts = timestamp;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (qv.hasTags()) {
                        byte[] allTagsBytes = qv.getTags().toByteArray();
                        if (qv.hasDeleteType()) {
                            put.add(cellBuilder.clear().setRow(proto.getRow().toByteArray()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(ProtobufUtil.fromDeleteType(qv.getDeleteType()).getCode()).setTags(allTagsBytes).build());
                            continue;
                        }
                        put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(Cell.Type.Put).setValue(qv.hasValue() ? qv.getValue().toByteArray() : null).setTags(allTagsBytes).build());
                        continue;
                    }
                    if (qv.hasDeleteType()) {
                        put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(ProtobufUtil.fromDeleteType(qv.getDeleteType()).getCode()).build());
                        continue;
                    }
                    put.add(cellBuilder.clear().setRow(put.getRow()).setFamily(family).setQualifier(qv.hasQualifier() ? qv.getQualifier().toByteArray() : null).setTimestamp(ts).setType(Cell.Type.Put).setValue(qv.hasValue() ? qv.getValue().toByteArray() : null).build());
                }
            }
        }
        put.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            put.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return put;
    }

    public static Delete toDelete(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toDelete(proto, null);
    }

    public static Delete toDelete(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.DELETE) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Delete delete = proto.hasRow() ? new Delete(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString(proto));
                }
                Cell cell = cellScanner.current();
                if (delete == null) {
                    delete = new Delete(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                delete.add(cell);
            }
        } else {
            if (delete == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    ClientProtos.MutationProto.DeleteType deleteType = qv.getDeleteType();
                    byte[] qualifier = null;
                    if (qv.hasQualifier()) {
                        qualifier = qv.getQualifier().toByteArray();
                    }
                    long ts = ProtobufUtil.cellTimestampOrLatest(qv);
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION) {
                        delete.addColumn(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS) {
                        delete.addColumns(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION) {
                        delete.addFamilyVersion(family, ts);
                        continue;
                    }
                    delete.addFamily(family, ts);
                }
            }
        }
        delete.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            delete.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return delete;
    }

    private static <T extends Mutation> T toDelta(Function<Bytes, T> supplier, ConsumerWithException<T, Cell> consumer, ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Mutation mutation = row == null ? null : (Mutation)supplier.apply(new Bytes(row));
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (mutation == null) {
                    mutation = (Mutation)supplier.apply(new Bytes(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
                }
                consumer.accept(mutation, cell);
            }
        } else {
            if (mutation == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    consumer.accept(mutation, ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY).setRow(mutation.getRow()).setFamily(family).setQualifier(qualifier).setTimestamp(ProtobufUtil.cellTimestampOrLatest(qv)).setType(KeyValue.Type.Put.getCode()).setValue(value).setTags(tags).build());
                }
            }
        }
        mutation.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            mutation.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return (T)mutation;
    }

    private static long cellTimestampOrLatest(ClientProtos.MutationProto.ColumnValue.QualifierValue cell) {
        if (cell.hasTimestamp()) {
            return cell.getTimestamp();
        }
        return Long.MAX_VALUE;
    }

    public static Append toAppend(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        Append append = ProtobufUtil.toDelta(row -> new Append(row.get(), row.getOffset(), row.getLength()), Append::add, proto, cellScanner);
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.toTimeRange(proto.getTimeRange());
            append.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        return append;
    }

    public static Increment toIncrement(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT) : type.name();
        Increment increment = ProtobufUtil.toDelta(row -> new Increment(row.get(), row.getOffset(), row.getLength()), Increment::add, proto, cellScanner);
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.toTimeRange(proto.getTimeRange());
            increment.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        return increment;
    }

    public static Mutation toMutation(ClientProtos.MutationProto proto) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        if (type == ClientProtos.MutationProto.MutationType.INCREMENT) {
            return ProtobufUtil.toIncrement(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            return ProtobufUtil.toAppend(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.DELETE) {
            return ProtobufUtil.toDelete(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.PUT) {
            return ProtobufUtil.toPut(proto, null);
        }
        throw new IOException("Unknown mutation type " + type);
    }

    public static ClientProtos.Scan.ReadType toReadType(Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return ClientProtos.Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return ClientProtos.Scan.ReadType.STREAM;
            }
            case PREAD: {
                return ClientProtos.Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + (Object)((Object)readType));
    }

    public static Scan.ReadType toReadType(ClientProtos.Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return Scan.ReadType.DEFAULT;
            }
            case STREAM: {
                return Scan.ReadType.STREAM;
            }
            case PREAD: {
                return Scan.ReadType.PREAD;
            }
        }
        throw new IllegalArgumentException("Unknown ReadType: " + readType);
    }

    public static ClientProtos.Scan toScan(Scan scan) throws IOException {
        long mvccReadPoint;
        byte[] stopRow;
        byte[] startRow;
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setCacheBlocks(scan.getCacheBlocks());
        if (scan.getBatch() > 0) {
            scanBuilder.setBatchSize(scan.getBatch());
        }
        if (scan.getMaxResultSize() > 0L) {
            scanBuilder.setMaxResultSize(scan.getMaxResultSize());
        }
        if (scan.isSmall()) {
            scanBuilder.setSmall(scan.isSmall());
        }
        if (scan.getAllowPartialResults()) {
            scanBuilder.setAllowPartialResults(scan.getAllowPartialResults());
        }
        if ((loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue()) != null) {
            scanBuilder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand);
        }
        scanBuilder.setMaxVersions(scan.getMaxVersions());
        scan.getColumnFamilyTimeRange().forEach((cf, timeRange) -> scanBuilder.addCfTimeRange(HBaseProtos.ColumnFamilyTimeRange.newBuilder().setColumnFamily(UnsafeByteOperations.unsafeWrap(cf)).setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build()));
        scanBuilder.setTimeRange(ProtobufUtil.toTimeRange(scan.getTimeRange()));
        Map<String, byte[]> attributes = scan.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap(attribute.getValue()));
                scanBuilder.addAttribute(attributeBuilder.build());
            }
        }
        if ((startRow = scan.getStartRow()) != null && startRow.length > 0) {
            scanBuilder.setStartRow(UnsafeByteOperations.unsafeWrap(startRow));
        }
        if ((stopRow = scan.getStopRow()) != null && stopRow.length > 0) {
            scanBuilder.setStopRow(UnsafeByteOperations.unsafeWrap(stopRow));
        }
        if (scan.hasFilter()) {
            scanBuilder.setFilter(ProtobufUtil.toFilter(scan.getFilter()));
        }
        if (scan.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : scan.getFamilyMap().entrySet()) {
                columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap(family.getKey()));
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(UnsafeByteOperations.unsafeWrap(qualifier));
                    }
                }
                scanBuilder.addColumn(columnBuilder.build());
            }
        }
        if (scan.getMaxResultsPerColumnFamily() >= 0) {
            scanBuilder.setStoreLimit(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            scanBuilder.setStoreOffset(scan.getRowOffsetPerColumnFamily());
        }
        if (scan.isReversed()) {
            scanBuilder.setReversed(scan.isReversed());
        }
        if (scan.getConsistency() == Consistency.TIMELINE) {
            scanBuilder.setConsistency(ProtobufUtil.toConsistency(scan.getConsistency()));
        }
        if (scan.getCaching() > 0) {
            scanBuilder.setCaching(scan.getCaching());
        }
        if ((mvccReadPoint = PackagePrivateFieldAccessor.getMvccReadPoint(scan)) > 0L) {
            scanBuilder.setMvccReadPoint(mvccReadPoint);
        }
        if (!scan.includeStartRow()) {
            scanBuilder.setIncludeStartRow(false);
        }
        scanBuilder.setIncludeStopRow(scan.includeStopRow());
        if (scan.getReadType() != Scan.ReadType.DEFAULT) {
            scanBuilder.setReadType(ProtobufUtil.toReadType(scan.getReadType()));
        }
        if (scan.isNeedCursorResult()) {
            scanBuilder.setNeedCursorResult(true);
        }
        return scanBuilder.build();
    }

    public static Scan toScan(ClientProtos.Scan proto) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        boolean includeStartRow = true;
        boolean includeStopRow = false;
        if (proto.hasStartRow()) {
            startRow = proto.getStartRow().toByteArray();
        }
        if (proto.hasStopRow()) {
            stopRow = proto.getStopRow().toByteArray();
        }
        if (proto.hasIncludeStartRow()) {
            includeStartRow = proto.getIncludeStartRow();
        }
        if (proto.hasIncludeStopRow()) {
            includeStopRow = proto.getIncludeStopRow();
        } else if (ClientUtil.areScanStartRowAndStopRowEqual(startRow, stopRow)) {
            includeStopRow = true;
        }
        Scan scan = new Scan().withStartRow(startRow, includeStartRow).withStopRow(stopRow, includeStopRow);
        if (proto.hasCacheBlocks()) {
            scan.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            scan.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            scan.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            scan.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            scan.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.toTimeRange(cftr.getTimeRange());
                scan.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange.getMin(), timeRange.getMax());
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.toTimeRange(proto.getTimeRange());
            scan.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            scan.setFilter(ProtobufUtil.toFilter(filter));
        }
        if (proto.hasBatchSize()) {
            scan.setBatch(proto.getBatchSize());
        }
        if (proto.hasMaxResultSize()) {
            scan.setMaxResultSize(proto.getMaxResultSize());
        }
        if (proto.hasSmall()) {
            scan.setSmall(proto.getSmall());
        }
        if (proto.hasAllowPartialResults()) {
            scan.setAllowPartialResults(proto.getAllowPartialResults());
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            scan.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        scan.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                scan.addFamily(family);
            }
        }
        if (proto.hasReversed()) {
            scan.setReversed(proto.getReversed());
        }
        if (proto.hasConsistency()) {
            scan.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasCaching()) {
            scan.setCaching(proto.getCaching());
        }
        if (proto.hasMvccReadPoint()) {
            PackagePrivateFieldAccessor.setMvccReadPoint(scan, proto.getMvccReadPoint());
        }
        if (scan.isSmall()) {
            scan.setReadType(Scan.ReadType.PREAD);
        } else if (proto.hasReadType()) {
            scan.setReadType(ProtobufUtil.toReadType(proto.getReadType()));
        }
        if (proto.getNeedCursorResult()) {
            scan.setNeedCursorResult(true);
        }
        return scan;
    }

    public static ClientProtos.Cursor toCursor(Cursor cursor) {
        ClientProtos.Cursor.Builder builder = ClientProtos.Cursor.newBuilder();
        ClientProtos.Cursor.newBuilder().setRow(ByteString.copyFrom(cursor.getRow()));
        return builder.build();
    }

    public static ClientProtos.Cursor toCursor(Cell cell) {
        return ClientProtos.Cursor.newBuilder().setRow(ByteString.copyFrom(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength())).build();
    }

    public static Cursor toCursor(ClientProtos.Cursor cursor) {
        return ClientUtil.createCursor(cursor.getRow().toByteArray());
    }

    public static ClientProtos.Get toGet(Get get) throws IOException {
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Get.Builder builder = ClientProtos.Get.newBuilder();
        builder.setRow(UnsafeByteOperations.unsafeWrap(get.getRow()));
        builder.setCacheBlocks(get.getCacheBlocks());
        builder.setMaxVersions(get.getMaxVersions());
        if (get.getFilter() != null) {
            builder.setFilter(ProtobufUtil.toFilter(get.getFilter()));
        }
        get.getColumnFamilyTimeRange().forEach((cf, timeRange) -> builder.addCfTimeRange(HBaseProtos.ColumnFamilyTimeRange.newBuilder().setColumnFamily(UnsafeByteOperations.unsafeWrap(cf)).setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build()));
        builder.setTimeRange(ProtobufUtil.toTimeRange(get.getTimeRange()));
        Map<String, byte[]> attributes = get.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        if (get.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            Map<byte[], NavigableSet<byte[]>> families = get.getFamilyMap();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : families.entrySet()) {
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap(family.getKey()));
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(UnsafeByteOperations.unsafeWrap(qualifier));
                    }
                }
                builder.addColumn(columnBuilder.build());
            }
        }
        if (get.getMaxResultsPerColumnFamily() >= 0) {
            builder.setStoreLimit(get.getMaxResultsPerColumnFamily());
        }
        if (get.getRowOffsetPerColumnFamily() > 0) {
            builder.setStoreOffset(get.getRowOffsetPerColumnFamily());
        }
        if (get.isCheckExistenceOnly()) {
            builder.setExistenceOnly(true);
        }
        if (get.getConsistency() != null && get.getConsistency() != Consistency.STRONG) {
            builder.setConsistency(ProtobufUtil.toConsistency(get.getConsistency()));
        }
        if ((loadColumnFamiliesOnDemand = get.getLoadColumnFamiliesOnDemandValue()) != null) {
            builder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand);
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonce) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, ClientProtos.MutationProto.newBuilder(), nonce);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        builder = ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        if (type == ClientProtos.MutationProto.MutationType.INCREMENT) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Increment)mutation).getTimeRange()));
        }
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Append)mutation).getTimeRange()));
        }
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : mutation.getFamilyCellMap().entrySet()) {
            columnBuilder.clear();
            columnBuilder.setFamily(UnsafeByteOperations.unsafeWrap((byte[])family.getKey()));
            for (Cell cell : (List)family.getValue()) {
                valueBuilder.clear();
                valueBuilder.setQualifier(UnsafeByteOperations.unsafeWrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
                valueBuilder.setValue(UnsafeByteOperations.unsafeWrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                valueBuilder.setTimestamp(cell.getTimestamp());
                if (type == ClientProtos.MutationProto.MutationType.DELETE || type == ClientProtos.MutationProto.MutationType.PUT && CellUtil.isDelete(cell)) {
                    KeyValue.Type keyValueType = KeyValue.Type.codeToType(cell.getTypeByte());
                    valueBuilder.setDeleteType(ProtobufUtil.toDeleteType(keyValueType));
                }
                columnBuilder.addQualifierValue(valueBuilder.build());
            }
            builder.addColumnValue(columnBuilder.build());
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutationNoData(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
        return ProtobufUtil.toMutationNoData(type, mutation, builder);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        builder.setAssociatedCellCount(mutation.size());
        if (mutation instanceof Increment) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Increment)mutation).getTimeRange()));
        }
        if (mutation instanceof Append) {
            builder.setTimeRange(ProtobufUtil.toTimeRange(((Append)mutation).getTimeRange()));
        }
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        return builder.build();
    }

    private static ClientProtos.MutationProto.Builder getMutationBuilderAndSetCommonFields(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) {
        builder.setRow(UnsafeByteOperations.unsafeWrap(mutation.getRow()));
        builder.setMutateType(type);
        builder.setDurability(ProtobufUtil.toDurability(mutation.getDurability()));
        builder.setTimestamp(mutation.getTimestamp());
        Map<String, byte[]> attributes = mutation.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(UnsafeByteOperations.unsafeWrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder;
    }

    public static ClientProtos.Result toResult(Result result) {
        return ProtobufUtil.toResult(result, false);
    }

    public static ClientProtos.Result toResult(Result result, boolean encodeTags) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        Cell[] cells = result.rawCells();
        if (cells == null || cells.length == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        for (Cell c : cells) {
            builder.addCell(ProtobufUtil.toCell(c, encodeTags));
        }
        builder.setStale(result.isStale());
        builder.setPartial(result.mayHaveMoreCellsInRow());
        return builder.build();
    }

    public static ClientProtos.Result toResult(boolean existence, boolean stale) {
        if (stale) {
            return existence ? EMPTY_RESULT_PB_EXISTS_TRUE_STALE : EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
        }
        return existence ? EMPTY_RESULT_PB_EXISTS_TRUE : EMPTY_RESULT_PB_EXISTS_FALSE;
    }

    public static ClientProtos.Result toResultNoData(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        int size = result.size();
        if (size == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setAssociatedCellCount(size);
        builder.setStale(result.isStale());
        return builder.build();
    }

    public static Result toResult(ClientProtos.Result proto) {
        return ProtobufUtil.toResult(proto, false);
    }

    public static Result toResult(ClientProtos.Result proto, boolean decodeTags) {
        if (proto.hasExists()) {
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        List<CellProtos.Cell> values = proto.getCellList();
        if (values.isEmpty()) {
            return proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(values.size());
        ExtendedCellBuilder builder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
        for (CellProtos.Cell c : values) {
            cells.add(ProtobufUtil.toCell(builder, c, decodeTags));
        }
        return Result.create(cells, null, proto.getStale(), proto.getPartial());
    }

    public static Result toResult(ClientProtos.Result proto, CellScanner scanner) throws IOException {
        List<CellProtos.Cell> values = proto.getCellList();
        if (proto.hasExists()) {
            if (values != null && !values.isEmpty() || proto.hasAssociatedCellCount() && proto.getAssociatedCellCount() > 0) {
                throw new IllegalArgumentException("bad proto: exists with cells is no allowed " + proto);
            }
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        ArrayList<Cell> cells = null;
        if (proto.hasAssociatedCellCount()) {
            int count = proto.getAssociatedCellCount();
            cells = new ArrayList<Cell>(count + values.size());
            for (int i = 0; i < count; ++i) {
                if (!scanner.advance()) {
                    throw new IOException("Failed get " + i + " of " + count);
                }
                cells.add(scanner.current());
            }
        }
        if (!values.isEmpty()) {
            if (cells == null) {
                cells = new ArrayList(values.size());
            }
            ExtendedCellBuilder builder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);
            for (CellProtos.Cell c : values) {
                cells.add(ProtobufUtil.toCell(builder, c, false));
            }
        }
        return cells == null || cells.isEmpty() ? (proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT) : Result.create(cells, null, proto.getStale());
    }

    public static ComparatorProtos.Comparator toComparator(ByteArrayComparable comparator) {
        ComparatorProtos.Comparator.Builder builder = ComparatorProtos.Comparator.newBuilder();
        builder.setName(comparator.getClass().getName());
        builder.setSerializedComparator(UnsafeByteOperations.unsafeWrap(comparator.toByteArray()));
        return builder.build();
    }

    public static ByteArrayComparable toComparator(ComparatorProtos.Comparator proto) throws IOException {
        String type = proto.getName();
        String funcName = "parseFrom";
        byte[] value = proto.getSerializedComparator().toByteArray();
        try {
            Class<?> c = Class.forName(type, true, ClassLoaderHolder.CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (ByteArrayComparable)parseFrom.invoke(null, new Object[]{value});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Filter toFilter(FilterProtos.Filter proto) throws IOException {
        String type = proto.getName();
        byte[] value = proto.getSerializedFilter().toByteArray();
        String funcName = "parseFrom";
        try {
            Class<?> c = Class.forName(type, true, ClassLoaderHolder.CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (Filter)parseFrom.invoke(c, new Object[]{value});
        }
        catch (Exception e) {
            throw new DoNotRetryIOException(e);
        }
    }

    public static FilterProtos.Filter toFilter(Filter filter) throws IOException {
        FilterProtos.Filter.Builder builder = FilterProtos.Filter.newBuilder();
        builder.setName(filter.getClass().getName());
        builder.setSerializedFilter(UnsafeByteOperations.unsafeWrap(filter.toByteArray()));
        return builder.build();
    }

    public static ClientProtos.MutationProto.DeleteType toDeleteType(KeyValue.Type type) throws IOException {
        switch (type) {
            case Delete: {
                return ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION;
            }
            case DeleteColumn: {
                return ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS;
            }
            case DeleteFamily: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY;
            }
            case DeleteFamilyVersion: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION;
            }
        }
        throw new IOException("Unknown delete type: " + (Object)((Object)type));
    }

    public static KeyValue.Type fromDeleteType(ClientProtos.MutationProto.DeleteType type) throws IOException {
        switch (type) {
            case DELETE_ONE_VERSION: {
                return KeyValue.Type.Delete;
            }
            case DELETE_MULTIPLE_VERSIONS: {
                return KeyValue.Type.DeleteColumn;
            }
            case DELETE_FAMILY: {
                return KeyValue.Type.DeleteFamily;
            }
            case DELETE_FAMILY_VERSION: {
                return KeyValue.Type.DeleteFamilyVersion;
            }
        }
        throw new IOException("Unknown delete type: " + type);
    }

    public static Throwable toException(HBaseProtos.NameBytesPair parameter) throws IOException {
        if (parameter == null || !parameter.hasValue()) {
            return null;
        }
        String desc = parameter.getValue().toStringUtf8();
        String type = parameter.getName();
        try {
            Class<?> c = Class.forName(type, true, ClassLoaderHolder.CLASS_LOADER);
            Constructor<?> cn = null;
            try {
                cn = c.getDeclaredConstructor(String.class);
                return (Throwable)cn.newInstance(desc);
            }
            catch (NoSuchMethodException e) {
                cn = c.getDeclaredConstructor(String.class, String.class);
                return (Throwable)cn.newInstance(type, desc);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T extends Service> T newServiceStub(Class<T> service, RpcChannel channel) throws Exception {
        return (T)((Service)Methods.call(service, null, "newStub", new Class[]{RpcChannel.class}, new Object[]{channel}));
    }

    public static RegionInfo getRegionInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, byte[] regionName) throws IOException {
        try {
            AdminProtos.GetRegionInfoRequest request = RegionInfo.isEncodedRegionName(regionName) ? AdminProtos.GetRegionInfoRequest.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, regionName)).build() : RequestConverter.buildGetRegionInfoRequest(regionName);
            AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(controller, request);
            return ProtobufUtil.toRegionInfo(response.getRegionInfo());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<RegionLoad> getRegionLoadInfo(AdminProtos.GetRegionLoadResponse regionLoadResponse) {
        ArrayList<RegionLoad> regionLoadList = new ArrayList<RegionLoad>(regionLoadResponse.getRegionLoadsCount());
        for (ClusterStatusProtos.RegionLoad regionLoad : regionLoadResponse.getRegionLoadsList()) {
            regionLoadList.add(new RegionLoad(regionLoad));
        }
        return regionLoadList;
    }

    public static void closeRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, byte[] regionName) throws IOException {
        AdminProtos.CloseRegionRequest closeRegionRequest = ProtobufUtil.buildCloseRegionRequest(server, regionName);
        try {
            admin.closeRegion(controller, closeRegionRequest);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void warmupRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, RegionInfo regionInfo) throws IOException {
        try {
            AdminProtos.WarmupRegionRequest warmupRegionRequest = RequestConverter.buildWarmupRegionRequest(regionInfo);
            admin.warmupRegion(controller, warmupRegionRequest);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
    }

    public static void openRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, RegionInfo region) throws IOException {
        AdminProtos.OpenRegionRequest request = RequestConverter.buildOpenRegionRequest(server, region, null);
        try {
            admin.openRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<RegionInfo> getOnlineRegions(AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        return ProtobufUtil.getOnlineRegions(null, admin);
    }

    public static List<RegionInfo> getOnlineRegions(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetOnlineRegionRequest request = RequestConverter.buildGetOnlineRegionRequest();
        AdminProtos.GetOnlineRegionResponse response = null;
        try {
            response = admin.getOnlineRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        return ProtobufUtil.getRegionInfos(response);
    }

    public static List<RegionInfo> getRegionInfos(AdminProtos.GetOnlineRegionResponse proto) {
        if (proto == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>(proto.getRegionInfoList().size());
        for (HBaseProtos.RegionInfo regionInfo : proto.getRegionInfoList()) {
            regionInfos.add(ProtobufUtil.toRegionInfo(regionInfo));
        }
        return regionInfos;
    }

    public static AdminProtos.ServerInfo getServerInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetServerInfoRequest request = RequestConverter.buildGetServerInfoRequest();
        try {
            AdminProtos.GetServerInfoResponse response = admin.getServerInfo(controller, request);
            return response.getServerInfo();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<String> getStoreFiles(AdminProtos.AdminService.BlockingInterface admin, byte[] regionName, byte[] family) throws IOException {
        return ProtobufUtil.getStoreFiles(null, admin, regionName, family);
    }

    public static List<String> getStoreFiles(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, byte[] regionName, byte[] family) throws IOException {
        AdminProtos.GetStoreFileRequest request = ProtobufUtil.buildGetStoreFileRequest(regionName, family);
        try {
            AdminProtos.GetStoreFileResponse response = admin.getStoreFile(controller, request);
            return response.getStoreFileList();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static long getTotalRequestsCount(ClusterStatusProtos.RegionLoad rl) {
        if (rl == null) {
            return 0L;
        }
        return rl.getReadRequestsCount() + rl.getWriteRequestsCount();
    }

    public static byte[] toDelimitedByteArray(Message m) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        baos.write(ProtobufMagic.PB_MAGIC);
        m.writeDelimitedTo(baos);
        return baos.toByteArray();
    }

    public static String getRegionEncodedName(HBaseProtos.RegionSpecifier regionSpecifier) throws DoNotRetryIOException {
        ByteString value = regionSpecifier.getValue();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = regionSpecifier.getType();
        switch (type) {
            case REGION_NAME: {
                return RegionInfo.encodeRegionName(value.toByteArray());
            }
            case ENCODED_REGION_NAME: {
                return value.toStringUtf8();
            }
        }
        throw new DoNotRetryIOException("Unsupported region specifier type: " + type);
    }

    public static ScanMetrics toScanMetrics(byte[] bytes) {
        MapReduceProtos.ScanMetrics pScanMetrics = null;
        try {
            pScanMetrics = MapReduceProtos.ScanMetrics.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
        ScanMetrics scanMetrics = new ScanMetrics();
        if (pScanMetrics != null) {
            for (HBaseProtos.NameInt64Pair pair : pScanMetrics.getMetricsList()) {
                if (!pair.hasName() || !pair.hasValue()) continue;
                scanMetrics.setCounter(pair.getName(), pair.getValue());
            }
        }
        return scanMetrics;
    }

    public static MapReduceProtos.ScanMetrics toScanMetrics(ScanMetrics scanMetrics, boolean reset) {
        MapReduceProtos.ScanMetrics.Builder builder = MapReduceProtos.ScanMetrics.newBuilder();
        Map<String, Long> metrics = scanMetrics.getMetricsMap(reset);
        for (Map.Entry<String, Long> e : metrics.entrySet()) {
            HBaseProtos.NameInt64Pair nameInt64Pair = HBaseProtos.NameInt64Pair.newBuilder().setName(e.getKey()).setValue(e.getValue()).build();
            builder.addMetrics(nameInt64Pair);
        }
        return builder.build();
    }

    public static void toIOException(ServiceException se) throws IOException {
        if (se == null) {
            throw new NullPointerException("Null service exception passed!");
        }
        Throwable cause = se.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(se);
    }

    public static CellProtos.Cell toCell(Cell kv, boolean encodeTags) {
        CellProtos.Cell.Builder kvbuilder = CellProtos.Cell.newBuilder();
        if (kv instanceof ByteBufferExtendedCell) {
            kvbuilder.setRow(ProtobufUtil.wrap(((ByteBufferExtendedCell)kv).getRowByteBuffer(), ((ByteBufferExtendedCell)kv).getRowPosition(), kv.getRowLength()));
            kvbuilder.setFamily(ProtobufUtil.wrap(((ByteBufferExtendedCell)kv).getFamilyByteBuffer(), ((ByteBufferExtendedCell)kv).getFamilyPosition(), kv.getFamilyLength()));
            kvbuilder.setQualifier(ProtobufUtil.wrap(((ByteBufferExtendedCell)kv).getQualifierByteBuffer(), ((ByteBufferExtendedCell)kv).getQualifierPosition(), kv.getQualifierLength()));
            kvbuilder.setCellType(CellProtos.CellType.valueOf(kv.getTypeByte()));
            kvbuilder.setTimestamp(kv.getTimestamp());
            kvbuilder.setValue(ProtobufUtil.wrap(((ByteBufferExtendedCell)kv).getValueByteBuffer(), ((ByteBufferExtendedCell)kv).getValuePosition(), kv.getValueLength()));
            if (encodeTags) {
                kvbuilder.setTags(ProtobufUtil.wrap(((ByteBufferExtendedCell)kv).getTagsByteBuffer(), ((ByteBufferExtendedCell)kv).getTagsPosition(), kv.getTagsLength()));
            }
        } else {
            kvbuilder.setRow(UnsafeByteOperations.unsafeWrap(kv.getRowArray(), kv.getRowOffset(), (int)kv.getRowLength()));
            kvbuilder.setFamily(UnsafeByteOperations.unsafeWrap(kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength()));
            kvbuilder.setQualifier(UnsafeByteOperations.unsafeWrap(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength()));
            kvbuilder.setCellType(CellProtos.CellType.valueOf(kv.getTypeByte()));
            kvbuilder.setTimestamp(kv.getTimestamp());
            kvbuilder.setValue(UnsafeByteOperations.unsafeWrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()));
            if (encodeTags) {
                kvbuilder.setTags(UnsafeByteOperations.unsafeWrap(kv.getTagsArray(), kv.getTagsOffset(), kv.getTagsLength()));
            }
        }
        return kvbuilder.build();
    }

    private static ByteString wrap(ByteBuffer b, int offset, int length) {
        ByteBuffer dup = b.duplicate();
        dup.position(offset);
        dup.limit(offset + length);
        return UnsafeByteOperations.unsafeWrap(dup);
    }

    public static Cell toCell(ExtendedCellBuilder cellBuilder, CellProtos.Cell cell, boolean decodeTags) {
        ExtendedCellBuilder builder = cellBuilder.clear().setRow(cell.getRow().toByteArray()).setFamily(cell.getFamily().toByteArray()).setQualifier(cell.getQualifier().toByteArray()).setTimestamp(cell.getTimestamp()).setType((byte)cell.getCellType().getNumber()).setValue(cell.getValue().toByteArray());
        if (decodeTags && cell.hasTags()) {
            builder.setTags(cell.getTags().toByteArray());
        }
        return builder.build();
    }

    public static HBaseProtos.NamespaceDescriptor toProtoNamespaceDescriptor(NamespaceDescriptor ns) {
        HBaseProtos.NamespaceDescriptor.Builder b = HBaseProtos.NamespaceDescriptor.newBuilder().setName(ByteString.copyFromUtf8(ns.getName()));
        for (Map.Entry<String, String> entry : ns.getConfiguration().entrySet()) {
            b.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()));
        }
        return b.build();
    }

    public static NamespaceDescriptor toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor desc) {
        NamespaceDescriptor.Builder b = NamespaceDescriptor.create(desc.getName().toStringUtf8());
        for (HBaseProtos.NameStringPair prop : desc.getConfigurationList()) {
            b.addConfiguration(prop.getName(), prop.getValue());
        }
        return b.build();
    }

    public static WALProtos.CompactionDescriptor toCompactionDescriptor(RegionInfo info, byte[] family, List<Path> inputPaths, List<Path> outputPaths, Path storeDir) {
        return ProtobufUtil.toCompactionDescriptor(info, null, family, inputPaths, outputPaths, storeDir);
    }

    public static WALProtos.CompactionDescriptor toCompactionDescriptor(RegionInfo info, byte[] regionName, byte[] family, List<Path> inputPaths, List<Path> outputPaths, Path storeDir) {
        WALProtos.CompactionDescriptor.Builder builder = WALProtos.CompactionDescriptor.newBuilder().setTableName(UnsafeByteOperations.unsafeWrap(info.getTable().toBytes())).setEncodedRegionName(UnsafeByteOperations.unsafeWrap(regionName == null ? info.getEncodedNameAsBytes() : regionName)).setFamilyName(UnsafeByteOperations.unsafeWrap(family)).setStoreHomeDir(storeDir.getName());
        for (Path inputPath : inputPaths) {
            builder.addCompactionInput(inputPath.getName());
        }
        for (Path outputPath : outputPaths) {
            builder.addCompactionOutput(outputPath.getName());
        }
        builder.setRegionName(UnsafeByteOperations.unsafeWrap(info.getRegionName()));
        return builder.build();
    }

    public static WALProtos.FlushDescriptor toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction action, RegionInfo hri, long flushSeqId, Map<byte[], List<Path>> committedFiles) {
        WALProtos.FlushDescriptor.Builder desc = WALProtos.FlushDescriptor.newBuilder().setAction(action).setEncodedRegionName(UnsafeByteOperations.unsafeWrap(hri.getEncodedNameAsBytes())).setRegionName(UnsafeByteOperations.unsafeWrap(hri.getRegionName())).setFlushSequenceNumber(flushSeqId).setTableName(UnsafeByteOperations.unsafeWrap(hri.getTable().getName()));
        for (Map.Entry<byte[], List<Path>> entry : committedFiles.entrySet()) {
            WALProtos.FlushDescriptor.StoreFlushDescriptor.Builder builder = WALProtos.FlushDescriptor.StoreFlushDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap(entry.getKey())).setStoreHomeDir(Bytes.toString(entry.getKey()));
            if (entry.getValue() != null) {
                for (Path path : entry.getValue()) {
                    builder.addFlushOutput(path.getName());
                }
            }
            desc.addStoreFlushes(builder);
        }
        return desc.build();
    }

    public static WALProtos.RegionEventDescriptor toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType eventType, RegionInfo hri, long seqId, ServerName server, Map<byte[], List<Path>> storeFiles) {
        byte[] tableNameAsBytes = hri.getTable().getName();
        byte[] encodedNameAsBytes = hri.getEncodedNameAsBytes();
        byte[] regionNameAsBytes = hri.getRegionName();
        return ProtobufUtil.toRegionEventDescriptor(eventType, tableNameAsBytes, encodedNameAsBytes, regionNameAsBytes, seqId, server, storeFiles);
    }

    public static WALProtos.RegionEventDescriptor toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType eventType, byte[] tableNameAsBytes, byte[] encodedNameAsBytes, byte[] regionNameAsBytes, long seqId, ServerName server, Map<byte[], List<Path>> storeFiles) {
        WALProtos.RegionEventDescriptor.Builder desc = WALProtos.RegionEventDescriptor.newBuilder().setEventType(eventType).setTableName(UnsafeByteOperations.unsafeWrap(tableNameAsBytes)).setEncodedRegionName(UnsafeByteOperations.unsafeWrap(encodedNameAsBytes)).setRegionName(UnsafeByteOperations.unsafeWrap(regionNameAsBytes)).setLogSequenceNumber(seqId).setServer(ProtobufUtil.toServerName(server));
        for (Map.Entry<byte[], List<Path>> entry : storeFiles.entrySet()) {
            WALProtos.StoreDescriptor.Builder builder = WALProtos.StoreDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap(entry.getKey())).setStoreHomeDir(Bytes.toString(entry.getKey()));
            for (Path path : entry.getValue()) {
                builder.addStoreFile(path.getName());
            }
            desc.addStores(builder);
        }
        return desc.build();
    }

    public static String getShortTextFormat(Message m) {
        if (m == null) {
            return "null";
        }
        if (m instanceof ClientProtos.ScanRequest) {
            return TextFormat.shortDebugString(m);
        }
        if (m instanceof RegionServerStatusProtos.RegionServerReportRequest) {
            RegionServerStatusProtos.RegionServerReportRequest r = (RegionServerStatusProtos.RegionServerReportRequest)m;
            return "server " + TextFormat.shortDebugString(r.getServer()) + " load { numberOfRequests: " + r.getLoad().getNumberOfRequests() + " }";
        }
        if (m instanceof RegionServerStatusProtos.RegionServerStartupRequest) {
            return TextFormat.shortDebugString(m);
        }
        if (m instanceof ClientProtos.MutationProto) {
            return ProtobufUtil.toShortString((ClientProtos.MutationProto)m);
        }
        if (m instanceof ClientProtos.GetRequest) {
            ClientProtos.GetRequest r = (ClientProtos.GetRequest)m;
            return "region= " + ProtobufUtil.getStringForByteString(r.getRegion().getValue()) + ", row=" + ProtobufUtil.getStringForByteString(r.getGet().getRow());
        }
        if (m instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest r = (ClientProtos.MultiRequest)m;
            int actionsCount = r.getRegionActionList().stream().mapToInt(ClientProtos.RegionAction::getActionCount).sum();
            ClientProtos.RegionAction actions = r.getRegionActionList().get(0);
            String row = actions.getActionCount() <= 0 ? "" : ProtobufUtil.getStringForByteString(actions.getAction(0).hasGet() ? actions.getAction(0).getGet().getRow() : actions.getAction(0).getMutation().getRow());
            return "region= " + ProtobufUtil.getStringForByteString(actions.getRegion().getValue()) + ", for " + actionsCount + " action(s) and 1st row key=" + row;
        }
        if (m instanceof ClientProtos.MutateRequest) {
            ClientProtos.MutateRequest r = (ClientProtos.MutateRequest)m;
            return "region= " + ProtobufUtil.getStringForByteString(r.getRegion().getValue()) + ", row=" + ProtobufUtil.getStringForByteString(r.getMutation().getRow());
        }
        if (m instanceof ClientProtos.CoprocessorServiceRequest) {
            ClientProtos.CoprocessorServiceRequest r = (ClientProtos.CoprocessorServiceRequest)m;
            return "coprocessorService= " + r.getCall().getServiceName() + ":" + r.getCall().getMethodName();
        }
        return "TODO: " + m.getClass().toString();
    }

    private static String getStringForByteString(ByteString bs) {
        return Bytes.toStringBinary(bs.toByteArray());
    }

    public static SlowLogParams getSlowLogParams(Message message) {
        if (message == null) {
            return null;
        }
        if (message instanceof ClientProtos.ScanRequest) {
            ClientProtos.ScanRequest scanRequest = (ClientProtos.ScanRequest)message;
            String regionName = ProtobufUtil.getStringForByteString(scanRequest.getRegion().getValue());
            String params = TextFormat.shortDebugString(message);
            return new SlowLogParams(regionName, params);
        }
        if (message instanceof ClientProtos.MutationProto) {
            ClientProtos.MutationProto mutationProto = (ClientProtos.MutationProto)message;
            String params = "type= " + mutationProto.getMutateType().toString();
            return new SlowLogParams(params);
        }
        if (message instanceof ClientProtos.GetRequest) {
            ClientProtos.GetRequest getRequest = (ClientProtos.GetRequest)message;
            String regionName = ProtobufUtil.getStringForByteString(getRequest.getRegion().getValue());
            String params = "region= " + regionName + ", row= " + ProtobufUtil.getStringForByteString(getRequest.getGet().getRow());
            return new SlowLogParams(regionName, params);
        }
        if (message instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest multiRequest = (ClientProtos.MultiRequest)message;
            int actionsCount = multiRequest.getRegionActionList().stream().mapToInt(ClientProtos.RegionAction::getActionCount).sum();
            ClientProtos.RegionAction actions = multiRequest.getRegionActionList().get(0);
            String regionName = ProtobufUtil.getStringForByteString(actions.getRegion().getValue());
            String params = "region= " + regionName + ", for " + actionsCount + " action(s)";
            return new SlowLogParams(regionName, params);
        }
        if (message instanceof ClientProtos.MutateRequest) {
            ClientProtos.MutateRequest mutateRequest = (ClientProtos.MutateRequest)message;
            String regionName = ProtobufUtil.getStringForByteString(mutateRequest.getRegion().getValue());
            String params = "region= " + regionName;
            return new SlowLogParams(regionName, params);
        }
        if (message instanceof ClientProtos.CoprocessorServiceRequest) {
            ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest = (ClientProtos.CoprocessorServiceRequest)message;
            String params = "coprocessorService= " + coprocessorServiceRequest.getCall().getServiceName() + ":" + coprocessorServiceRequest.getCall().getMethodName();
            return new SlowLogParams(params);
        }
        String params = message.getClass().toString();
        return new SlowLogParams(params);
    }

    static String toShortString(ClientProtos.MutationProto proto) {
        return "row=" + Bytes.toString(proto.getRow().toByteArray()) + ", type=" + proto.getMutateType().toString();
    }

    public static TableName toTableName(HBaseProtos.TableName tableNamePB) {
        return TableName.valueOf(tableNamePB.getNamespace().asReadOnlyByteBuffer(), tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static HBaseProtos.TableName toProtoTableName(TableName tableName) {
        return HBaseProtos.TableName.newBuilder().setNamespace(UnsafeByteOperations.unsafeWrap(tableName.getNamespace())).setQualifier(UnsafeByteOperations.unsafeWrap(tableName.getQualifier())).build();
    }

    public static List<HBaseProtos.TableName> toProtoTableNameList(List<TableName> tableNameList) {
        if (tableNameList == null) {
            return new ArrayList<HBaseProtos.TableName>();
        }
        return tableNameList.stream().map(ProtobufUtil::toProtoTableName).collect(Collectors.toList());
    }

    public static List<TableName> toTableNameList(List<HBaseProtos.TableName> tableNamesList) {
        if (tableNamesList == null) {
            return new ArrayList<TableName>();
        }
        return tableNamesList.stream().map(ProtobufUtil::toTableName).collect(Collectors.toList());
    }

    public static TableName[] getTableNameArray(List<HBaseProtos.TableName> tableNamesList) {
        if (tableNamesList == null) {
            return new TableName[0];
        }
        TableName[] tableNames = new TableName[tableNamesList.size()];
        for (int i = 0; i < tableNamesList.size(); ++i) {
            tableNames[i] = ProtobufUtil.toTableName(tableNamesList.get(i));
        }
        return tableNames;
    }

    public static CellVisibility toCellVisibility(ClientProtos.CellVisibility proto) {
        if (proto == null) {
            return null;
        }
        return new CellVisibility(proto.getExpression());
    }

    public static CellVisibility toCellVisibility(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        ClientProtos.CellVisibility proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return ProtobufUtil.toCellVisibility(proto);
    }

    public static ClientProtos.CellVisibility toCellVisibility(CellVisibility cellVisibility) {
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        builder.setExpression(cellVisibility.getExpression());
        return builder.build();
    }

    public static Authorizations toAuthorizations(ClientProtos.Authorizations proto) {
        if (proto == null) {
            return null;
        }
        return new Authorizations(proto.getLabelList());
    }

    public static Authorizations toAuthorizations(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.Authorizations.Builder builder = ClientProtos.Authorizations.newBuilder();
        ClientProtos.Authorizations proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return ProtobufUtil.toAuthorizations(proto);
    }

    public static ClientProtos.Authorizations toAuthorizations(Authorizations authorizations) {
        ClientProtos.Authorizations.Builder builder = ClientProtos.Authorizations.newBuilder();
        for (String label : authorizations.getLabels()) {
            builder.addLabel(label);
        }
        return builder.build();
    }

    public static TimeUnit toTimeUnit(HBaseProtos.TimeUnit proto) {
        switch (proto) {
            case NANOSECONDS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + proto);
    }

    public static HBaseProtos.TimeUnit toProtoTimeUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return HBaseProtos.TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return HBaseProtos.TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return HBaseProtos.TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return HBaseProtos.TimeUnit.SECONDS;
            }
            case MINUTES: {
                return HBaseProtos.TimeUnit.MINUTES;
            }
            case HOURS: {
                return HBaseProtos.TimeUnit.HOURS;
            }
            case DAYS: {
                return HBaseProtos.TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + (Object)((Object)timeUnit));
    }

    public static ThrottleType toThrottleType(QuotaProtos.ThrottleType proto) {
        switch (proto) {
            case REQUEST_NUMBER: {
                return ThrottleType.REQUEST_NUMBER;
            }
            case REQUEST_SIZE: {
                return ThrottleType.REQUEST_SIZE;
            }
            case REQUEST_CAPACITY_UNIT: {
                return ThrottleType.REQUEST_CAPACITY_UNIT;
            }
            case WRITE_NUMBER: {
                return ThrottleType.WRITE_NUMBER;
            }
            case WRITE_SIZE: {
                return ThrottleType.WRITE_SIZE;
            }
            case READ_NUMBER: {
                return ThrottleType.READ_NUMBER;
            }
            case READ_SIZE: {
                return ThrottleType.READ_SIZE;
            }
            case READ_CAPACITY_UNIT: {
                return ThrottleType.READ_CAPACITY_UNIT;
            }
            case WRITE_CAPACITY_UNIT: {
                return ThrottleType.WRITE_CAPACITY_UNIT;
            }
        }
        throw new RuntimeException("Invalid ThrottleType " + proto);
    }

    public static QuotaProtos.ThrottleType toProtoThrottleType(ThrottleType type) {
        switch (type) {
            case REQUEST_NUMBER: {
                return QuotaProtos.ThrottleType.REQUEST_NUMBER;
            }
            case REQUEST_SIZE: {
                return QuotaProtos.ThrottleType.REQUEST_SIZE;
            }
            case WRITE_NUMBER: {
                return QuotaProtos.ThrottleType.WRITE_NUMBER;
            }
            case WRITE_SIZE: {
                return QuotaProtos.ThrottleType.WRITE_SIZE;
            }
            case READ_NUMBER: {
                return QuotaProtos.ThrottleType.READ_NUMBER;
            }
            case READ_SIZE: {
                return QuotaProtos.ThrottleType.READ_SIZE;
            }
            case REQUEST_CAPACITY_UNIT: {
                return QuotaProtos.ThrottleType.REQUEST_CAPACITY_UNIT;
            }
            case READ_CAPACITY_UNIT: {
                return QuotaProtos.ThrottleType.READ_CAPACITY_UNIT;
            }
            case WRITE_CAPACITY_UNIT: {
                return QuotaProtos.ThrottleType.WRITE_CAPACITY_UNIT;
            }
        }
        throw new RuntimeException("Invalid ThrottleType " + (Object)((Object)type));
    }

    public static QuotaScope toQuotaScope(QuotaProtos.QuotaScope proto) {
        switch (proto) {
            case CLUSTER: {
                return QuotaScope.CLUSTER;
            }
            case MACHINE: {
                return QuotaScope.MACHINE;
            }
        }
        throw new RuntimeException("Invalid QuotaScope " + proto);
    }

    public static QuotaProtos.QuotaScope toProtoQuotaScope(QuotaScope scope) {
        switch (scope) {
            case CLUSTER: {
                return QuotaProtos.QuotaScope.CLUSTER;
            }
            case MACHINE: {
                return QuotaProtos.QuotaScope.MACHINE;
            }
        }
        throw new RuntimeException("Invalid QuotaScope " + (Object)((Object)scope));
    }

    public static QuotaType toQuotaScope(QuotaProtos.QuotaType proto) {
        switch (proto) {
            case THROTTLE: {
                return QuotaType.THROTTLE;
            }
            case SPACE: {
                return QuotaType.SPACE;
            }
        }
        throw new RuntimeException("Invalid QuotaType " + proto);
    }

    public static QuotaProtos.QuotaType toProtoQuotaScope(QuotaType type) {
        switch (type) {
            case THROTTLE: {
                return QuotaProtos.QuotaType.THROTTLE;
            }
            case SPACE: {
                return QuotaProtos.QuotaType.SPACE;
            }
        }
        throw new RuntimeException("Invalid QuotaType " + (Object)((Object)type));
    }

    public static SpaceViolationPolicy toViolationPolicy(QuotaProtos.SpaceViolationPolicy proto) {
        switch (proto) {
            case DISABLE: {
                return SpaceViolationPolicy.DISABLE;
            }
            case NO_WRITES_COMPACTIONS: {
                return SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
            }
            case NO_WRITES: {
                return SpaceViolationPolicy.NO_WRITES;
            }
            case NO_INSERTS: {
                return SpaceViolationPolicy.NO_INSERTS;
            }
        }
        throw new RuntimeException("Invalid SpaceViolationPolicy " + proto);
    }

    public static QuotaProtos.SpaceViolationPolicy toProtoViolationPolicy(SpaceViolationPolicy policy) {
        switch (policy) {
            case DISABLE: {
                return QuotaProtos.SpaceViolationPolicy.DISABLE;
            }
            case NO_WRITES_COMPACTIONS: {
                return QuotaProtos.SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
            }
            case NO_WRITES: {
                return QuotaProtos.SpaceViolationPolicy.NO_WRITES;
            }
            case NO_INSERTS: {
                return QuotaProtos.SpaceViolationPolicy.NO_INSERTS;
            }
        }
        throw new RuntimeException("Invalid SpaceViolationPolicy " + (Object)((Object)policy));
    }

    public static QuotaProtos.TimedQuota toTimedQuota(long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaProtos.TimedQuota.newBuilder().setSoftLimit(limit).setTimeUnit(ProtobufUtil.toProtoTimeUnit(timeUnit)).setScope(ProtobufUtil.toProtoQuotaScope(scope)).build();
    }

    public static QuotaProtos.SpaceQuota toProtoSpaceQuota(long limit, SpaceViolationPolicy violationPolicy) {
        return QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(limit).setViolationPolicy(ProtobufUtil.toProtoViolationPolicy(violationPolicy)).build();
    }

    public static WALProtos.BulkLoadDescriptor toBulkLoadDescriptor(TableName tableName, ByteString encodedRegionName, Map<byte[], List<Path>> storeFiles, Map<String, Long> storeFilesSize, long bulkloadSeqId) {
        return ProtobufUtil.toBulkLoadDescriptor(tableName, encodedRegionName, storeFiles, storeFilesSize, bulkloadSeqId, null, true);
    }

    public static WALProtos.BulkLoadDescriptor toBulkLoadDescriptor(TableName tableName, ByteString encodedRegionName, Map<byte[], List<Path>> storeFiles, Map<String, Long> storeFilesSize, long bulkloadSeqId, List<String> clusterIds, boolean replicate) {
        WALProtos.BulkLoadDescriptor.Builder desc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).setEncodedRegionName(encodedRegionName).setBulkloadSeqNum(bulkloadSeqId).setReplicate(replicate);
        if (clusterIds != null) {
            desc.addAllClusterIds(clusterIds);
        }
        for (Map.Entry<byte[], List<Path>> entry : storeFiles.entrySet()) {
            WALProtos.StoreDescriptor.Builder builder = WALProtos.StoreDescriptor.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap(entry.getKey())).setStoreHomeDir(Bytes.toString(entry.getKey()));
            for (Path path : entry.getValue()) {
                String name = path.getName();
                builder.addStoreFile(name);
                Long size = storeFilesSize.get(name) == null ? Long.valueOf(0L) : storeFilesSize.get(name);
                builder.setStoreFileSizeBytes(size);
            }
            desc.addStores(builder);
        }
        return desc.build();
    }

    public static void mergeDelimitedFrom(Message.Builder builder, InputStream in) throws IOException {
        int firstByte = in.read();
        if (firstByte != -1) {
            int size = CodedInputStream.readRawVarint32(firstByte, in);
            InputStream limitedInput = ByteStreams.limit(in, size);
            CodedInputStream codedInput = CodedInputStream.newInstance(limitedInput);
            codedInput.setSizeLimit(size);
            builder.mergeFrom(codedInput);
            codedInput.checkLastTagWas(0);
        }
    }

    public static void mergeFrom(Message.Builder builder, InputStream in, int size) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(in);
        codedInput.setSizeLimit(size);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, InputStream in) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(in);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, ByteString bs) throws IOException {
        CodedInputStream codedInput = bs.newCodedInput();
        codedInput.setSizeLimit(bs.size());
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(b);
        codedInput.setSizeLimit(b.length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b, int offset, int length) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(b, offset, length);
        codedInput.setSizeLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, CodedInputStream codedInput, int length) throws IOException {
        codedInput.resetSizeCounter();
        int prevLimit = codedInput.setSizeLimit(length);
        int limit = codedInput.pushLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.popLimit(limit);
        codedInput.checkLastTagWas(0);
        codedInput.setSizeLimit(prevLimit);
    }

    public static ReplicationLoadSink toReplicationLoadSink(ClusterStatusProtos.ReplicationLoadSink rls) {
        ReplicationLoadSink.ReplicationLoadSinkBuilder builder = ReplicationLoadSink.newBuilder();
        builder.setAgeOfLastAppliedOp(rls.getAgeOfLastAppliedOp()).setTimestampsOfLastAppliedOp(rls.getTimeStampsOfLastAppliedOp()).setTimestampStarted(rls.hasTimestampStarted() ? rls.getTimestampStarted() : -1L).setTotalOpsProcessed(rls.hasTotalOpsProcessed() ? rls.getTotalOpsProcessed() : -1L);
        return builder.build();
    }

    public static ReplicationLoadSource toReplicationLoadSource(ClusterStatusProtos.ReplicationLoadSource rls) {
        ReplicationLoadSource.ReplicationLoadSourceBuilder builder = ReplicationLoadSource.newBuilder();
        builder.setPeerID(rls.getPeerID()).setAgeOfLastShippedOp(rls.getAgeOfLastShippedOp()).setSizeOfLogQueue(rls.getSizeOfLogQueue()).setTimestampOfLastShippedOp(rls.getTimeStampOfLastShippedOp()).setTimeStampOfNextToReplicate(rls.getTimeStampOfNextToReplicate()).setReplicationLag(rls.getReplicationLag()).setQueueId(rls.getQueueId()).setRecovered(rls.getRecovered()).setRunning(rls.getRunning()).setEditsSinceRestart(rls.getEditsSinceRestart()).setEditsRead(rls.getEditsRead()).setoPsShipped(rls.getOPsShipped());
        return builder.build();
    }

    public static HBaseProtos.VersionInfo getVersionInfo() {
        HBaseProtos.VersionInfo.Builder builder = HBaseProtos.VersionInfo.newBuilder();
        String version = VersionInfo.getVersion();
        builder.setVersion(version);
        String[] components = version.split("\\.");
        if (components != null && components.length > 2) {
            builder.setVersionMajor(Integer.parseInt(components[0]));
            builder.setVersionMinor(Integer.parseInt(components[1]));
        }
        builder.setUrl(VersionInfo.getUrl());
        builder.setRevision(VersionInfo.getRevision());
        builder.setUser(VersionInfo.getUser());
        builder.setDate(VersionInfo.getDate());
        builder.setSrcChecksum(VersionInfo.getSrcChecksum());
        return builder.build();
    }

    public static List<SecurityCapability> toSecurityCapabilityList(List<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities) {
        ArrayList<SecurityCapability> scList = new ArrayList<SecurityCapability>(capabilities.size());
        for (MasterProtos.SecurityCapabilitiesResponse.Capability c : capabilities) {
            try {
                scList.add(SecurityCapability.valueOf(c.getNumber()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return scList;
    }

    public static TimeRange toTimeRange(HBaseProtos.TimeRange timeRange) {
        return timeRange == null ? TimeRange.allTime() : new TimeRange(timeRange.hasFrom() ? timeRange.getFrom() : 0L, timeRange.hasTo() ? timeRange.getTo() : Long.MAX_VALUE);
    }

    public static HBaseProtos.ColumnFamilySchema toColumnFamilySchema(ColumnFamilyDescriptor hcd) {
        GeneratedMessageV3.Builder aBuilder;
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        builder.setName(UnsafeByteOperations.unsafeWrap(hcd.getName()));
        for (Map.Entry<Bytes, Bytes> entry : hcd.getValues().entrySet()) {
            aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            ((HBaseProtos.BytesBytesPair.Builder)aBuilder).setFirst(UnsafeByteOperations.unsafeWrap(entry.getKey().get()));
            ((HBaseProtos.BytesBytesPair.Builder)aBuilder).setSecond(UnsafeByteOperations.unsafeWrap(entry.getValue().get()));
            builder.addAttributes(((HBaseProtos.BytesBytesPair.Builder)aBuilder).build());
        }
        for (Map.Entry<Object, Object> entry : hcd.getConfiguration().entrySet()) {
            aBuilder = HBaseProtos.NameStringPair.newBuilder();
            ((HBaseProtos.NameStringPair.Builder)aBuilder).setName((String)entry.getKey());
            ((HBaseProtos.NameStringPair.Builder)aBuilder).setValue((String)entry.getValue());
            builder.addConfiguration(((HBaseProtos.NameStringPair.Builder)aBuilder).build());
        }
        return builder.build();
    }

    public static ColumnFamilyDescriptor toColumnFamilyDescriptor(HBaseProtos.ColumnFamilySchema cfs) {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder(cfs.getName().toByteArray());
        cfs.getAttributesList().forEach(a -> builder.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray()));
        cfs.getConfigurationList().forEach(a -> builder.setConfiguration(a.getName(), a.getValue()));
        return builder.build();
    }

    public static HBaseProtos.TableSchema toTableSchema(TableDescriptor htd) {
        HBaseProtos.TableSchema.Builder builder = HBaseProtos.TableSchema.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(htd.getTableName()));
        for (Map.Entry<Bytes, Bytes> e : htd.getValues().entrySet()) {
            HBaseProtos.BytesBytesPair.Builder aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            aBuilder.setFirst(UnsafeByteOperations.unsafeWrap(e.getKey().get()));
            aBuilder.setSecond(UnsafeByteOperations.unsafeWrap(e.getValue().get()));
            builder.addAttributes(aBuilder.build());
        }
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            builder.addColumnFamilies(ProtobufUtil.toColumnFamilySchema(hcd));
        }
        return builder.build();
    }

    public static TableDescriptor toTableDescriptor(HBaseProtos.TableSchema ts) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder(ProtobufUtil.toTableName(ts.getTableName()));
        ts.getColumnFamiliesList().stream().map(ProtobufUtil::toColumnFamilyDescriptor).forEach(builder::setColumnFamily);
        ts.getAttributesList().forEach(a -> builder.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray()));
        ts.getConfigurationList().forEach(a -> builder.setValue(a.getName(), a.getValue()));
        return builder.build();
    }

    public static CompactionState createCompactionState(AdminProtos.GetRegionInfoResponse.CompactionState state) {
        return CompactionState.valueOf(state.toString());
    }

    public static AdminProtos.GetRegionInfoResponse.CompactionState createCompactionState(CompactionState state) {
        return AdminProtos.GetRegionInfoResponse.CompactionState.valueOf(state.toString());
    }

    public static CompactionState createCompactionStateForRegionLoad(ClusterStatusProtos.RegionLoad.CompactionState state) {
        return CompactionState.valueOf(state.toString());
    }

    public static ClusterStatusProtos.RegionLoad.CompactionState createCompactionStateForRegionLoad(CompactionState state) {
        return ClusterStatusProtos.RegionLoad.CompactionState.valueOf(state.toString());
    }

    public static Optional<Long> toOptionalTimestamp(MasterProtos.MajorCompactionTimestampResponse resp) {
        long timestamp = resp.getCompactionTimestamp();
        return timestamp == 0L ? Optional.empty() : Optional.of(timestamp);
    }

    public static SnapshotProtos.SnapshotDescription.Type createProtosSnapShotDescType(SnapshotType type) {
        return SnapshotProtos.SnapshotDescription.Type.valueOf(type.name());
    }

    public static SnapshotProtos.SnapshotDescription.Type createProtosSnapShotDescType(String snapshotDesc) {
        return SnapshotProtos.SnapshotDescription.Type.valueOf(snapshotDesc.toUpperCase(Locale.ROOT));
    }

    public static SnapshotType createSnapshotType(SnapshotProtos.SnapshotDescription.Type type) {
        return SnapshotType.valueOf(type.toString());
    }

    public static SnapshotProtos.SnapshotDescription createHBaseProtosSnapshotDesc(SnapshotDescription snapshotDesc) {
        SnapshotProtos.SnapshotDescription.Builder builder = SnapshotProtos.SnapshotDescription.newBuilder();
        if (snapshotDesc.getTableName() != null) {
            builder.setTable(snapshotDesc.getTableNameAsString());
        }
        if (snapshotDesc.getName() != null) {
            builder.setName(snapshotDesc.getName());
        }
        if (snapshotDesc.getOwner() != null) {
            builder.setOwner(snapshotDesc.getOwner());
        }
        if (snapshotDesc.getCreationTime() != -1L) {
            builder.setCreationTime(snapshotDesc.getCreationTime());
        }
        if (snapshotDesc.getTtl() != -1L && snapshotDesc.getTtl() < TimeUnit.MILLISECONDS.toSeconds(Long.MAX_VALUE)) {
            builder.setTtl(snapshotDesc.getTtl());
        }
        if (snapshotDesc.getVersion() != -1) {
            builder.setVersion(snapshotDesc.getVersion());
        }
        if (snapshotDesc.getMaxFileSize() != -1L) {
            builder.setMaxFileSize(snapshotDesc.getMaxFileSize());
        }
        builder.setType(ProtobufUtil.createProtosSnapShotDescType(snapshotDesc.getType()));
        return builder.build();
    }

    public static SnapshotDescription createSnapshotDesc(SnapshotProtos.SnapshotDescription snapshotDesc) {
        HashMap<String, Object> snapshotProps = new HashMap<String, Object>();
        snapshotProps.put("TTL", snapshotDesc.getTtl());
        snapshotProps.put("MAX_FILESIZE", snapshotDesc.getMaxFileSize());
        return new SnapshotDescription(snapshotDesc.getName(), snapshotDesc.hasTable() ? TableName.valueOf(snapshotDesc.getTable()) : null, ProtobufUtil.createSnapshotType(snapshotDesc.getType()), snapshotDesc.getOwner(), snapshotDesc.getCreationTime(), snapshotDesc.getVersion(), snapshotProps);
    }

    public static RegionLoadStats createRegionLoadStats(ClientProtos.RegionLoadStats stats) {
        return new RegionLoadStats(stats.getMemStoreLoad(), stats.getHeapOccupancy(), stats.getCompactionPressure());
    }

    public static String toText(Message msg) {
        return TextFormat.shortDebugString(msg);
    }

    public static byte[] toBytes(ByteString bs) {
        return bs.toByteArray();
    }

    public static <T> T call(Callable<T> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    public static AdminProtos.GetStoreFileRequest buildGetStoreFileRequest(byte[] regionName, byte[] family) {
        AdminProtos.GetStoreFileRequest.Builder builder = AdminProtos.GetStoreFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.addFamily(UnsafeByteOperations.unsafeWrap(family));
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName) {
        return ProtobufUtil.buildCloseRegionRequest(server, regionName, null);
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName, ServerName destinationServer) {
        return ProtobufUtil.buildCloseRegionRequest(server, regionName, destinationServer, -1L);
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName, ServerName destinationServer, long closeProcId) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (destinationServer != null) {
            builder.setDestinationServer(ProtobufUtil.toServerName(destinationServer));
        }
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        builder.setCloseProcId(closeProcId);
        return builder.build();
    }

    public static HBaseProtos.ProcedureDescription buildProcedureDescription(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder().setSignature(signature).setInstance(instance);
        if (props != null && !props.isEmpty()) {
            props.entrySet().forEach(entry -> builder.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName((String)entry.getKey()).setValue((String)entry.getValue()).build()));
        }
        return builder.build();
    }

    public static RegionState parseMetaRegionStateFrom(byte[] data, int replicaId) throws DeserializationException {
        ServerName serverName;
        RegionState.State state = RegionState.State.OPEN;
        if (data != null && data.length > 0 && ProtobufUtil.isPBMagicPrefix(data)) {
            try {
                int prefixLen = ProtobufUtil.lengthOfPBMagic();
                ZooKeeperProtos.MetaRegionServer rl = ZooKeeperProtos.MetaRegionServer.parser().parseFrom(data, prefixLen, data.length - prefixLen);
                if (rl.hasState()) {
                    state = RegionState.State.convert(rl.getState());
                }
                HBaseProtos.ServerName sn = rl.getServer();
                serverName = ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException("Unable to parse meta region location");
            }
        } else {
            serverName = ProtobufUtil.parseServerNameFrom(data);
        }
        if (serverName == null) {
            state = RegionState.State.OFFLINE;
        }
        return new RegionState(RegionReplicaUtil.getRegionInfoForReplica(RegionInfoBuilder.FIRST_META_REGIONINFO, replicaId), state, serverName);
    }

    public static ServerName parseServerNameFrom(byte[] data) throws DeserializationException {
        if (data == null || data.length <= 0) {
            return null;
        }
        if (ProtobufMagic.isPBMagicPrefix(data)) {
            int prefixLen = ProtobufMagic.lengthOfPBMagic();
            try {
                ZooKeeperProtos.Master rss = ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                HBaseProtos.ServerName sn = rss.getMaster();
                return ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        String str = Bytes.toString(data);
        int index = str.indexOf(",");
        if (index != -1) {
            return ServerName.parseVersionedServerName(data);
        }
        String hostname = Addressing.parseHostname(str);
        int port = Addressing.parsePort(str);
        return ServerName.valueOf(hostname, port, -1L);
    }

    public static String toProcedureJson(List<ProcedureProtos.Procedure> procProtos) {
        JsonArray procJsons = new JsonArray(procProtos.size());
        for (ProcedureProtos.Procedure procProto : procProtos) {
            try {
                JsonElement procJson = ProtobufMessageConverter.toJsonElement(procProto);
                procJsons.add(procJson);
            }
            catch (InvalidProtocolBufferException e) {
                procJsons.add(e.toString());
            }
        }
        return procJsons.toString();
    }

    public static String toLockJson(List<LockServiceProtos.LockedResource> lockedResourceProtos) {
        JsonArray lockedResourceJsons = new JsonArray(lockedResourceProtos.size());
        for (LockServiceProtos.LockedResource lockedResourceProto : lockedResourceProtos) {
            try {
                JsonElement lockedResourceJson = ProtobufMessageConverter.toJsonElement(lockedResourceProto);
                lockedResourceJsons.add(lockedResourceJson);
            }
            catch (InvalidProtocolBufferException e) {
                lockedResourceJsons.add(e.toString());
            }
        }
        return lockedResourceJsons.toString();
    }

    public static HBaseProtos.RegionInfo toRegionInfo(RegionInfo info) {
        if (info == null) {
            return null;
        }
        HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(info.getTable()));
        builder.setRegionId(info.getRegionId());
        if (info.getStartKey() != null) {
            builder.setStartKey(UnsafeByteOperations.unsafeWrap(info.getStartKey()));
        }
        if (info.getEndKey() != null) {
            builder.setEndKey(UnsafeByteOperations.unsafeWrap(info.getEndKey()));
        }
        builder.setOffline(info.isOffline());
        builder.setSplit(info.isSplit());
        builder.setReplicaId(info.getReplicaId());
        return builder.build();
    }

    public static RegionInfo toRegionInfo(HBaseProtos.RegionInfo proto) {
        int replicaId;
        if (proto == null) {
            return null;
        }
        TableName tableName = ProtobufUtil.toTableName(proto.getTableName());
        long regionId = proto.getRegionId();
        int defaultReplicaId = 0;
        int n = replicaId = proto.hasReplicaId() ? proto.getReplicaId() : defaultReplicaId;
        if (tableName.equals(TableName.META_TABLE_NAME) && replicaId == defaultReplicaId) {
            return RegionInfoBuilder.FIRST_META_REGIONINFO;
        }
        byte[] startKey = null;
        byte[] endKey = null;
        if (proto.hasStartKey()) {
            startKey = proto.getStartKey().toByteArray();
        }
        if (proto.hasEndKey()) {
            endKey = proto.getEndKey().toByteArray();
        }
        boolean split = false;
        if (proto.hasSplit()) {
            split = proto.getSplit();
        }
        RegionInfoBuilder rib = RegionInfoBuilder.newBuilder(tableName).setStartKey(startKey).setEndKey(endKey).setRegionId(regionId).setReplicaId(replicaId).setSplit(split);
        if (proto.hasOffline()) {
            rib.setOffline(proto.getOffline());
        }
        return rib.build();
    }

    public static HBaseProtos.RegionLocation toRegionLocation(HRegionLocation loc) {
        HBaseProtos.RegionLocation.Builder builder = HBaseProtos.RegionLocation.newBuilder();
        builder.setRegionInfo(ProtobufUtil.toRegionInfo(loc.getRegion()));
        if (loc.getServerName() != null) {
            builder.setServerName(ProtobufUtil.toServerName(loc.getServerName()));
        }
        builder.setSeqNum(loc.getSeqNum());
        return builder.build();
    }

    public static HRegionLocation toRegionLocation(HBaseProtos.RegionLocation proto) {
        RegionInfo regionInfo = ProtobufUtil.toRegionInfo(proto.getRegionInfo());
        ServerName serverName = proto.hasServerName() ? ProtobufUtil.toServerName(proto.getServerName()) : null;
        return new HRegionLocation(regionInfo, serverName, proto.getSeqNum());
    }

    public static List<SnapshotDescription> toSnapshotDescriptionList(MasterProtos.GetCompletedSnapshotsResponse response, Pattern pattern) {
        return response.getSnapshotsList().stream().map(ProtobufUtil::createSnapshotDesc).filter(snap -> pattern != null ? pattern.matcher(snap.getName()).matches() : true).collect(Collectors.toList());
    }

    public static CacheEvictionStats toCacheEvictionStats(HBaseProtos.CacheEvictionStats stats) throws IOException {
        CacheEvictionStatsBuilder builder = CacheEvictionStats.builder();
        builder.withEvictedBlocks(stats.getEvictedBlocks()).withMaxCacheSize(stats.getMaxCacheSize());
        if (stats.getExceptionCount() > 0) {
            for (HBaseProtos.RegionExceptionMessage exception : stats.getExceptionList()) {
                HBaseProtos.RegionSpecifier rs = exception.getRegion();
                byte[] regionName = rs.getValue().toByteArray();
                builder.addException(regionName, ProtobufUtil.toException(exception.getException()));
            }
        }
        return builder.build();
    }

    public static HBaseProtos.CacheEvictionStats toCacheEvictionStats(CacheEvictionStats cacheEvictionStats) {
        HBaseProtos.CacheEvictionStats.Builder builder = HBaseProtos.CacheEvictionStats.newBuilder();
        for (Map.Entry<byte[], Throwable> entry : cacheEvictionStats.getExceptions().entrySet()) {
            builder.addException(HBaseProtos.RegionExceptionMessage.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, entry.getKey())).setException(ResponseConverter.buildException(entry.getValue())).build());
        }
        return builder.setEvictedBlocks(cacheEvictionStats.getEvictedBlocks()).setMaxCacheSize(cacheEvictionStats.getMaxCacheSize()).build();
    }

    public static ClusterStatusProtos.ReplicationLoadSource toReplicationLoadSource(ReplicationLoadSource rls) {
        return ClusterStatusProtos.ReplicationLoadSource.newBuilder().setPeerID(rls.getPeerID()).setAgeOfLastShippedOp(rls.getAgeOfLastShippedOp()).setSizeOfLogQueue((int)rls.getSizeOfLogQueue()).setTimeStampOfLastShippedOp(rls.getTimestampOfLastShippedOp()).setReplicationLag(rls.getReplicationLag()).setQueueId(rls.getQueueId()).setRecovered(rls.isRecovered()).setRunning(rls.isRunning()).setEditsSinceRestart(rls.hasEditsSinceRestart()).setTimeStampOfNextToReplicate(rls.getTimeStampOfNextToReplicate()).setOPsShipped(rls.getOPsShipped()).setEditsRead(rls.getEditsRead()).build();
    }

    public static ClusterStatusProtos.ReplicationLoadSink toReplicationLoadSink(ReplicationLoadSink rls) {
        return ClusterStatusProtos.ReplicationLoadSink.newBuilder().setAgeOfLastAppliedOp(rls.getAgeOfLastAppliedOp()).setTimeStampsOfLastAppliedOp(rls.getTimestampsOfLastAppliedOp()).setTimestampStarted(rls.getTimestampStarted()).setTotalOpsProcessed(rls.getTotalOpsProcessed()).build();
    }

    public static HBaseProtos.TimeRange toTimeRange(TimeRange timeRange) {
        if (timeRange == null) {
            timeRange = TimeRange.allTime();
        }
        return HBaseProtos.TimeRange.newBuilder().setFrom(timeRange.getMin()).setTo(timeRange.getMax()).build();
    }

    public static byte[] toCompactionEventTrackerBytes(Set<String> storeFiles) {
        HFileProtos.CompactionEventTracker.Builder builder = HFileProtos.CompactionEventTracker.newBuilder();
        storeFiles.forEach(sf -> builder.addCompactedStoreFile(ByteString.copyFromUtf8(sf)));
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    public static Set<String> toCompactedStoreFiles(byte[] bytes) throws IOException {
        if (bytes != null && ProtobufUtil.isPBMagicPrefix(bytes)) {
            int pbLen = ProtobufUtil.lengthOfPBMagic();
            HFileProtos.CompactionEventTracker.Builder builder = HFileProtos.CompactionEventTracker.newBuilder();
            ProtobufUtil.mergeFrom(builder, bytes, pbLen, bytes.length - pbLen);
            HFileProtos.CompactionEventTracker compactionEventTracker = builder.build();
            List<ByteString> compactedStoreFiles = compactionEventTracker.getCompactedStoreFileList();
            if (compactedStoreFiles != null && compactedStoreFiles.size() != 0) {
                return compactedStoreFiles.stream().map(ByteString::toStringUtf8).collect(Collectors.toSet());
            }
        }
        return Collections.emptySet();
    }

    public static ClusterStatusProtos.RegionStatesCount toTableRegionStatesCount(RegionStatesCount regionStatesCount) {
        int openRegions = 0;
        int splitRegions = 0;
        int closedRegions = 0;
        int regionsInTransition = 0;
        int totalRegions = 0;
        if (regionStatesCount != null) {
            openRegions = regionStatesCount.getOpenRegions();
            splitRegions = regionStatesCount.getSplitRegions();
            closedRegions = regionStatesCount.getClosedRegions();
            regionsInTransition = regionStatesCount.getRegionsInTransition();
            totalRegions = regionStatesCount.getTotalRegions();
        }
        return ClusterStatusProtos.RegionStatesCount.newBuilder().setOpenRegions(openRegions).setSplitRegions(splitRegions).setClosedRegions(closedRegions).setRegionsInTransition(regionsInTransition).setTotalRegions(totalRegions).build();
    }

    public static RegionStatesCount toTableRegionStatesCount(ClusterStatusProtos.RegionStatesCount regionStatesCount) {
        int openRegions = 0;
        int splitRegions = 0;
        int closedRegions = 0;
        int regionsInTransition = 0;
        int totalRegions = 0;
        if (regionStatesCount != null) {
            closedRegions = regionStatesCount.getClosedRegions();
            regionsInTransition = regionStatesCount.getRegionsInTransition();
            openRegions = regionStatesCount.getOpenRegions();
            splitRegions = regionStatesCount.getSplitRegions();
            totalRegions = regionStatesCount.getTotalRegions();
        }
        return new RegionStatesCount.RegionStatesCountBuilder().setOpenRegions(openRegions).setSplitRegions(splitRegions).setClosedRegions(closedRegions).setRegionsInTransition(regionsInTransition).setTotalRegions(totalRegions).build();
    }

    private static LogEntry getSlowLogRecord(TooSlowLog.SlowLogPayload slowLogPayload) {
        OnlineLogRecord onlineLogRecord = new OnlineLogRecord.OnlineLogRecordBuilder().setCallDetails(slowLogPayload.getCallDetails()).setClientAddress(slowLogPayload.getClientAddress()).setMethodName(slowLogPayload.getMethodName()).setMultiGetsCount(slowLogPayload.getMultiGets()).setMultiMutationsCount(slowLogPayload.getMultiMutations()).setMultiServiceCalls(slowLogPayload.getMultiServiceCalls()).setParam(slowLogPayload.getParam()).setProcessingTime(slowLogPayload.getProcessingTime()).setQueueTime(slowLogPayload.getQueueTime()).setRegionName(slowLogPayload.getRegionName()).setResponseSize(slowLogPayload.getResponseSize()).setServerClass(slowLogPayload.getServerClass()).setStartTime(slowLogPayload.getStartTime()).setUserName(slowLogPayload.getUserName()).build();
        return onlineLogRecord;
    }

    public static List<LogEntry> toSlowLogPayloads(HBaseProtos.LogEntry logEntry) {
        try {
            String logClassName = logEntry.getLogClassName();
            Class<Message> logClass = Class.forName(logClassName).asSubclass(Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("SlowLogResponses")) {
                AdminProtos.SlowLogResponses slowLogResponses = (AdminProtos.SlowLogResponses)method.invoke(null, logEntry.getLogMessage());
                return slowLogResponses.getSlowLogPayloadsList().stream().map(ProtobufUtil::getSlowLogRecord).collect(Collectors.toList());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error while retrieving response from server");
        }
        throw new RuntimeException("Invalid response from server");
    }

    public static boolean toClearSlowLogPayload(AdminProtos.ClearSlowLogResponses clearSlowLogResponses) {
        return clearSlowLogResponses.getIsCleaned();
    }

    public static CheckAndMutate toCheckAndMutate(ClientProtos.Condition condition, ClientProtos.MutationProto mutation, CellScanner cellScanner) throws IOException {
        Filter filter;
        byte[] row = condition.getRow().toByteArray();
        CheckAndMutate.Builder builder = CheckAndMutate.newBuilder(row);
        Filter filter2 = filter = condition.hasFilter() ? ProtobufUtil.toFilter(condition.getFilter()) : null;
        if (filter != null) {
            builder.ifMatches(filter);
        } else {
            builder.ifMatches(condition.getFamily().toByteArray(), condition.getQualifier().toByteArray(), CompareOperator.valueOf(condition.getCompareType().name()), ProtobufUtil.toComparator(condition.getComparator()).getValue());
        }
        TimeRange timeRange = condition.hasTimeRange() ? ProtobufUtil.toTimeRange(condition.getTimeRange()) : TimeRange.allTime();
        builder.timeRange(timeRange);
        try {
            ClientProtos.MutationProto.MutationType type = mutation.getMutateType();
            switch (type) {
                case PUT: {
                    return builder.build(ProtobufUtil.toPut(mutation, cellScanner));
                }
                case DELETE: {
                    return builder.build(ProtobufUtil.toDelete(mutation, cellScanner));
                }
                case INCREMENT: {
                    return builder.build(ProtobufUtil.toIncrement(mutation, cellScanner));
                }
                case APPEND: {
                    return builder.build(ProtobufUtil.toAppend(mutation, cellScanner));
                }
            }
            throw new DoNotRetryIOException("Unsupported mutate type: " + type.name());
        }
        catch (IllegalArgumentException e) {
            throw new DoNotRetryIOException(e.getMessage());
        }
    }

    public static CheckAndMutate toCheckAndMutate(ClientProtos.Condition condition, List<Mutation> mutations) throws IOException {
        Filter filter;
        assert (mutations.size() > 0);
        byte[] row = condition.getRow().toByteArray();
        CheckAndMutate.Builder builder = CheckAndMutate.newBuilder(row);
        Filter filter2 = filter = condition.hasFilter() ? ProtobufUtil.toFilter(condition.getFilter()) : null;
        if (filter != null) {
            builder.ifMatches(filter);
        } else {
            builder.ifMatches(condition.getFamily().toByteArray(), condition.getQualifier().toByteArray(), CompareOperator.valueOf(condition.getCompareType().name()), ProtobufUtil.toComparator(condition.getComparator()).getValue());
        }
        TimeRange timeRange = condition.hasTimeRange() ? ProtobufUtil.toTimeRange(condition.getTimeRange()) : TimeRange.allTime();
        builder.timeRange(timeRange);
        try {
            if (mutations.size() == 1) {
                Mutation m = mutations.get(0);
                if (m instanceof Put) {
                    return builder.build((Put)m);
                }
                if (m instanceof Delete) {
                    return builder.build((Delete)m);
                }
                if (m instanceof Increment) {
                    return builder.build((Increment)m);
                }
                if (m instanceof Append) {
                    return builder.build((Append)m);
                }
                throw new DoNotRetryIOException("Unsupported mutate type: " + m.getClass().getSimpleName().toUpperCase());
            }
            return builder.build(new RowMutations(mutations.get(0).getRow()).add(mutations));
        }
        catch (IllegalArgumentException e) {
            throw new DoNotRetryIOException(e.getMessage());
        }
    }

    public static ClientProtos.Condition toCondition(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Filter filter, TimeRange timeRange) throws IOException {
        ClientProtos.Condition.Builder builder = ClientProtos.Condition.newBuilder().setRow(UnsafeByteOperations.unsafeWrap(row));
        if (filter != null) {
            builder.setFilter(ProtobufUtil.toFilter(filter));
        } else {
            builder.setFamily(UnsafeByteOperations.unsafeWrap(family)).setQualifier(UnsafeByteOperations.unsafeWrap(qualifier == null ? HConstants.EMPTY_BYTE_ARRAY : qualifier)).setComparator(ProtobufUtil.toComparator(new BinaryComparator(value))).setCompareType(HBaseProtos.CompareType.valueOf(op.name()));
        }
        return builder.setTimeRange(ProtobufUtil.toTimeRange(timeRange)).build();
    }

    public static ClientProtos.Condition toCondition(byte[] row, Filter filter, TimeRange timeRange) throws IOException {
        return ProtobufUtil.toCondition(row, null, null, null, null, filter, timeRange);
    }

    public static ClientProtos.Condition toCondition(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, TimeRange timeRange) throws IOException {
        return ProtobufUtil.toCondition(row, family, qualifier, op, value, null, timeRange);
    }

    public static List<LogEntry> toBalancerDecisionResponse(HBaseProtos.LogEntry logEntry) {
        try {
            String logClassName = logEntry.getLogClassName();
            Class<Message> logClass = Class.forName(logClassName).asSubclass(Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("BalancerDecisionsResponse")) {
                MasterProtos.BalancerDecisionsResponse response = (MasterProtos.BalancerDecisionsResponse)method.invoke(null, logEntry.getLogMessage());
                return ProtobufUtil.getBalancerDecisionEntries(response);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error while retrieving response from server");
        }
        throw new RuntimeException("Invalid response from server");
    }

    public static List<LogEntry> toBalancerRejectionResponse(HBaseProtos.LogEntry logEntry) {
        try {
            String logClassName = logEntry.getLogClassName();
            Class<Message> logClass = Class.forName(logClassName).asSubclass(Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("BalancerRejectionsResponse")) {
                MasterProtos.BalancerRejectionsResponse response = (MasterProtos.BalancerRejectionsResponse)method.invoke(null, logEntry.getLogMessage());
                return ProtobufUtil.getBalancerRejectionEntries(response);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error while retrieving response from server");
        }
        throw new RuntimeException("Invalid response from server");
    }

    public static List<LogEntry> getBalancerDecisionEntries(MasterProtos.BalancerDecisionsResponse response) {
        List<RecentLogs.BalancerDecision> balancerDecisions = response.getBalancerDecisionList();
        if (CollectionUtils.isEmpty(balancerDecisions)) {
            return Collections.emptyList();
        }
        return balancerDecisions.stream().map(balancerDecision -> new BalancerDecision.Builder().setInitTotalCost(balancerDecision.getInitTotalCost()).setInitialFunctionCosts(balancerDecision.getInitialFunctionCosts()).setComputedTotalCost(balancerDecision.getComputedTotalCost()).setFinalFunctionCosts(balancerDecision.getFinalFunctionCosts()).setComputedSteps(balancerDecision.getComputedSteps()).setRegionPlans(balancerDecision.getRegionPlansList()).build()).collect(Collectors.toList());
    }

    public static List<LogEntry> getBalancerRejectionEntries(MasterProtos.BalancerRejectionsResponse response) {
        List<RecentLogs.BalancerRejection> balancerRejections = response.getBalancerRejectionList();
        if (CollectionUtils.isEmpty(balancerRejections)) {
            return Collections.emptyList();
        }
        return balancerRejections.stream().map(balancerRejection -> new BalancerRejection.Builder().setReason(balancerRejection.getReason()).setCostFuncInfoList(balancerRejection.getCostFuncInfoList()).build()).collect(Collectors.toList());
    }

    public static HBaseProtos.LogRequest toBalancerDecisionRequest(int limit) {
        MasterProtos.BalancerDecisionsRequest balancerDecisionsRequest = MasterProtos.BalancerDecisionsRequest.newBuilder().setLimit(limit).build();
        return HBaseProtos.LogRequest.newBuilder().setLogClassName(balancerDecisionsRequest.getClass().getName()).setLogMessage(balancerDecisionsRequest.toByteString()).build();
    }

    public static HBaseProtos.LogRequest toBalancerRejectionRequest(int limit) {
        MasterProtos.BalancerRejectionsRequest balancerRejectionsRequest = MasterProtos.BalancerRejectionsRequest.newBuilder().setLimit(limit).build();
        return HBaseProtos.LogRequest.newBuilder().setLogClassName(balancerRejectionsRequest.getClass().getName()).setLogMessage(balancerRejectionsRequest.toByteString()).build();
    }

    public static MasterProtos.BalanceRequest toBalanceRequest(BalanceRequest request) {
        return MasterProtos.BalanceRequest.newBuilder().setDryRun(request.isDryRun()).setIgnoreRit(request.isIgnoreRegionsInTransition()).build();
    }

    public static BalanceRequest toBalanceRequest(MasterProtos.BalanceRequest request) {
        return BalanceRequest.newBuilder().setDryRun(request.hasDryRun() && request.getDryRun()).setIgnoreRegionsInTransition(request.hasIgnoreRit() && request.getIgnoreRit()).build();
    }

    public static MasterProtos.BalanceResponse toBalanceResponse(BalanceResponse response) {
        return MasterProtos.BalanceResponse.newBuilder().setBalancerRan(response.isBalancerRan()).setMovesCalculated(response.getMovesCalculated()).setMovesExecuted(response.getMovesExecuted()).build();
    }

    public static BalanceResponse toBalanceResponse(MasterProtos.BalanceResponse response) {
        return BalanceResponse.newBuilder().setBalancerRan(response.hasBalancerRan() && response.getBalancerRan()).setMovesCalculated(response.hasMovesCalculated() ? response.getMovesExecuted() : 0).setMovesExecuted(response.hasMovesExecuted() ? response.getMovesExecuted() : 0).build();
    }

    public static ServerTask getServerTask(ClusterStatusProtos.ServerTask task) {
        return ServerTaskBuilder.newBuilder().setDescription(task.getDescription()).setStatus(task.getStatus()).setState(ServerTask.State.valueOf(task.getState().name())).setStartTime(task.getStartTime()).setCompletionTime(task.getCompletionTime()).build();
    }

    public static ClusterStatusProtos.ServerTask toServerTask(ServerTask task) {
        return ClusterStatusProtos.ServerTask.newBuilder().setDescription(task.getDescription()).setStatus(task.getStatus()).setState(ClusterStatusProtos.ServerTask.State.valueOf(task.getState().name())).setStartTime(task.getStartTime()).setCompletionTime(task.getCompletionTime()).build();
    }

    public static boolean isEOF(InvalidProtocolBufferException e) {
        return e.getMessage().contains("input has been truncated");
    }

    public static <T extends Message> T parseDelimitedFrom(InputStream in, Parser<T> parser) throws IOException {
        int firstByte = in.read();
        if (firstByte < 0) {
            throw new EOFException("EOF while reading message size");
        }
        int size = CodedInputStream.readRawVarint32(firstByte, in);
        int available = in.available();
        if (available > 0) {
            if (available < size) {
                throw new EOFException("Available bytes not enough for parsing PB message, expect at least " + size + " bytes, but only " + available + " bytes available");
            }
            try {
                return (T)((Message)parser.parseFrom(ByteStreams.limit(in, size)));
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
        }
        byte[] bytes = new byte[size];
        ByteStreams.readFully(in, bytes);
        return (T)((Message)parser.parseFrom(bytes));
    }

    static {
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setExists(true);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_TRUE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_TRUE_STALE = builder.build();
        builder.clear();
        builder.setExists(false);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_FALSE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_FALSE_STALE = builder.build();
        builder.clear();
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_STALE = builder.build();
        classLoaderLoaded = false;
    }

    @FunctionalInterface
    private static interface ConsumerWithException<T, U> {
        public void accept(T var1, U var2) throws IOException;
    }

    private static final class ClassLoaderHolder {
        private static final ClassLoader CLASS_LOADER;

        private ClassLoaderHolder() {
        }

        static {
            ClassLoader parent = ProtobufUtil.class.getClassLoader();
            Configuration conf = HBaseConfiguration.create();
            CLASS_LOADER = AccessController.doPrivileged(() -> new DynamicClassLoader(conf, parent));
            classLoaderLoaded = true;
        }
    }
}

