/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Rank$;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the rank of a value in a group of values. The result is one plus the number\n      of rows preceding or equal to the current row in the ordering of the partition. The values\n      will produce gaps in the sequence.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t3\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\f\u0018\u0001\u0012B\u0001B\r\u0001\u0003\u0016\u0004%\ta\r\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005i!)A\t\u0001C\u0001\u000b\")A\t\u0001C\u0001\u0011\")\u0011\n\u0001C!\u0015\")Q\n\u0001C)\u001d\"9A\u000bAA\u0001\n\u0003)\u0006bB,\u0001#\u0003%\t\u0001\u0017\u0005\bG\u0002\t\t\u0011\"\u0011e\u0011\u001di\u0007!!A\u0005\u00029DqA\u001d\u0001\u0002\u0002\u0013\u00051\u000fC\u0004z\u0001\u0005\u0005I\u0011\t>\t\u0013\u0005\r\u0001!!A\u0005\u0002\u0005\u0015\u0001\"CA\b\u0001\u0005\u0005I\u0011IA\t\u000f%\tYdFA\u0001\u0012\u0003\tiD\u0002\u0005\u0017/\u0005\u0005\t\u0012AA \u0011\u0019!\u0005\u0003\"\u0001\u0002N!I\u0011q\n\t\u0002\u0002\u0013\u0015\u0013\u0011\u000b\u0005\n\u0003'\u0002\u0012\u0011!CA\u0003+B\u0011\"!\u0017\u0011\u0003\u0003%\t)a\u0017\t\u0013\u0005\u001d\u0004#!A\u0005\n\u0005%$\u0001\u0002*b].T!\u0001G\r\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00035m\t\u0001bY1uC2L8\u000f\u001e\u0006\u00039u\t1a]9m\u0015\tqr$A\u0003ta\u0006\u00148N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0015Js\u0006\u0005\u0002'O5\tq#\u0003\u0002)/\tA!+\u00198l\u0019&\\W\r\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3FA\u0004Qe>$Wo\u0019;\u0011\u0005)\u0002\u0014BA\u0019,\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!\u0019\u0007.\u001b7ee\u0016tW#\u0001\u001b\u0011\u0007Uj\u0004I\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011hI\u0001\u0007yI|w\u000e\u001e \n\u00031J!\u0001P\u0016\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\u0004'\u0016\f(B\u0001\u001f,!\t1\u0013)\u0003\u0002C/\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002G\u000fB\u0011a\u0005\u0001\u0005\u0006e\r\u0001\r\u0001\u000e\u000b\u0002\r\u0006Iq/\u001b;i\u001fJ$WM\u001d\u000b\u0003\r.CQ\u0001T\u0003A\u0002Q\nQa\u001c:eKJ\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005\u0019{\u0005\"\u0002)\u0007\u0001\u0004\t\u0016a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u00042!\u000e*A\u0013\t\u0019vH\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR\u0011aI\u0016\u0005\be\u001d\u0001\n\u00111\u00015\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u0017\u0016\u0003ii[\u0013a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0001\\\u0013AC1o]>$\u0018\r^5p]&\u0011!-\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001f!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0003mC:<'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u001e\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A8\u0011\u0005)\u0002\u0018BA9,\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\t!x\u000f\u0005\u0002+k&\u0011ao\u000b\u0002\u0004\u0003:L\bb\u0002=\f\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003m\u00042\u0001`@u\u001b\u0005i(B\u0001@,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0003i(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0002\u0002\u000eA\u0019!&!\u0003\n\u0007\u0005-1FA\u0004C_>dW-\u00198\t\u000fal\u0011\u0011!a\u0001i\u00061Q-];bYN$B!a\u0002\u0002\u0014!9\u0001PDA\u0001\u0002\u0004!\bf\u0006\u0001\u0002\u0018\u0005u\u0011qDA\u0012\u0003K\tI#a\u000b\u00020\u0005E\u0012QGA\u001c!\r1\u0013\u0011D\u0005\u0004\u000379\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003C\t\u00111\u001d\u0006!A\u0001\u0002sLR+O\u0007~C\u0013\u0006I\u0017!\u0007>l\u0007/\u001e;fg\u0002\"\b.\u001a\u0011sC:\\\u0007e\u001c4!C\u00022\u0018\r\\;fA%t\u0007%\u0019\u0011he>,\b\u000fI8gAY\fG.^3t]\u0001\"\u0006.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002zg.\u001a\u0011qYV\u001c\b\u0005\u001e5fA9,XNY3s\u0015\u0001\u0002\u0003\u0005\t\u0011!_\u001a\u0004#o\\<tAA\u0014XmY3eS:<\u0007e\u001c:!KF,\u0018\r\u001c\u0011u_\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!e><\b%\u001b8!i\",\u0007e\u001c:eKJLgn\u001a\u0011pM\u0002\"\b.\u001a\u0011qCJ$\u0018\u000e^5p]:\u0002C\u000b[3!m\u0006dW/Z:\u000bA\u0001\u0002\u0003\u0005\t\u0011xS2d\u0007\u0005\u001d:pIV\u001cW\rI4baN\u0004\u0013N\u001c\u0011uQ\u0016\u00043/Z9vK:\u001cWM\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003O\t\u0011q\u0019\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\rD\u0017\u000e\u001c3sK:\u0004S\u0006\t;iSN\u0004\u0013n\u001d\u0011u_\u0002\u0012\u0017m]3!i\",\u0007E]1oW\u0002zgn\u000f\u0011bA\rD\u0017M\\4fA%t\u0007\u0005\u001e5fAY\fG.^3!_\u001a\u0004sN\\3!i\",\u0007e\u00195jY\u0012\u0014XM\u001c\u0011xS2d'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!iJLwmZ3sA\u0005\u00043\r[1oO\u0016\u0004\u0013N\u001c\u0011sC:\\g\u0006\t+iSN\u0004\u0013n\u001d\u0011b]\u0002Jg\u000e^3s]\u0006d\u0007\u0005]1sC6,G/\u001a:!C:$\u0007e^5mY\u0002\u0012W\rI1tg&<g.\u001a3!Ef\u0004C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013I\\1msN,'O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002.\u0005\t9J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011bY\u0001\u0012G\u0006I0G+:\u001bu\f\u000b2*A=3VI\u0015\u0011)!\u0006\u0013F+\u0013+J\u001f:\u0003#)\u0017\u0011bA=\u0013F)\u0012*!\u0005f\u0003#-\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003EM\u0015-A!:\u0013)M\u0014-AEJC\u0006\t\u0015(\u0003J:C\u0006I\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\t;bE\"\nG\u0006\t2*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'C\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a\ng)\u0001\u0003\u0005\t\u0011!A\u0001\n%'C\u001a\nc)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u00024\u0005)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011\u0011H\u0001\ro&tGm\\<`MVt7m]\u0001\u0005%\u0006t7\u000e\u0005\u0002'!M!\u0001#!\u00110!\u0019\t\u0019%!\u00135\r6\u0011\u0011Q\t\u0006\u0004\u0003\u000fZ\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\n)EA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!Z\u0001\u0006CB\u0004H.\u001f\u000b\u0004\r\u0006]\u0003\"\u0002\u001a\u0014\u0001\u0004!\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003;\n\u0019\u0007\u0005\u0003+\u0003?\"\u0014bAA1W\t1q\n\u001d;j_:D\u0001\"!\u001a\u0015\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u001b\u0011\u0007\u0019\fi'C\u0002\u0002p\u001d\u0014aa\u00142kK\u000e$\b")
public class Rank
extends RankLike {
    private final Seq<Expression> children;

    public static Option<Seq<Expression>> unapply(Rank rank) {
        return Rank$.MODULE$.unapply(rank);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Rank, A> function1) {
        return Rank$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Rank> compose(Function1<A, Seq<Expression>> function1) {
        return Rank$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public Rank withOrder(Seq<Expression> order) {
        return new Rank(order);
    }

    @Override
    public Rank withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public Rank copy(Seq<Expression> children2) {
        return new Rank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Rank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rank)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rank rank = (Rank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = rank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!rank.canEqual(this)) return false;
        return true;
    }

    public Rank(Seq<Expression> children2) {
        this.children = children2;
    }

    public Rank() {
        this((Seq<Expression>)Nil$.MODULE$);
    }
}

