/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ClientSnapshotDescriptionUtils {
    private ClientSnapshotDescriptionUtils() {
    }

    public static void assertSnapshotRequestIsValid(SnapshotProtos.SnapshotDescription snapshot) throws IllegalArgumentException {
        TableName tableName;
        TableName.isLegalTableQualifierName(Bytes.toBytes(snapshot.getName()), true);
        if (snapshot.hasTable() && (tableName = TableName.valueOf(snapshot.getTable())).isSystemTable()) {
            throw new IllegalArgumentException("System table snapshots are not allowed");
        }
    }

    public static String toString(SnapshotProtos.SnapshotDescription snapshot) {
        if (snapshot == null) {
            return null;
        }
        return "{ ss=" + snapshot.getName() + " table=" + (snapshot.hasTable() ? TableName.valueOf(snapshot.getTable()) : "") + " type=" + snapshot.getType() + " ttl=" + snapshot.getTtl() + " }";
    }
}

