/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.NoopProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureExecutor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureExecutor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureExecutor.class);
    private TestProcEnv procEnv;
    private NoopProcedureStore procStore;
    private ProcedureExecutor<TestProcEnv> procExecutor;
    private HBaseCommonTestingUtil htu;

    @Before
    public void setUp() throws Exception {
        this.htu = new HBaseCommonTestingUtil();
        this.procEnv = new TestProcEnv();
        this.procStore = new NoopProcedureStore();
        this.procStore.start(1);
    }

    @After
    public void tearDown() throws Exception {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.procExecutor.join();
    }

    private void createNewExecutor(Configuration conf, int numThreads) throws Exception {
        this.procExecutor = new ProcedureExecutor(conf, (Object)this.procEnv, (ProcedureStore)this.procStore);
        ProcedureTestingUtility.initAndStartWorkers(this.procExecutor, numThreads, true);
    }

    @Test
    public void testWorkerStuck() throws Exception {
        Configuration conf = new Configuration(this.htu.getConfiguration());
        conf.setFloat("hbase.procedure.worker.add.stuck.percentage", 0.5f);
        conf.setInt("hbase.procedure.worker.monitor.interval.msec", 500);
        conf.setInt("hbase.procedure.worker.stuck.threshold.msec", 750);
        int NUM_THREADS = 2;
        this.createNewExecutor(conf, 2);
        Semaphore latch1 = new Semaphore(2);
        latch1.acquire(2);
        BusyWaitProcedure busyProc1 = new BusyWaitProcedure(latch1);
        Semaphore latch2 = new Semaphore(2);
        latch2.acquire(2);
        BusyWaitProcedure busyProc2 = new BusyWaitProcedure(latch2);
        long busyProcId1 = this.procExecutor.submitProcedure((Procedure)busyProc1);
        long busyProcId2 = this.procExecutor.submitProcedure((Procedure)busyProc2);
        long otherProcId = this.procExecutor.submitProcedure(new ProcedureTestingUtility.NoopProcedure());
        int threads1 = this.waitThreadCount(3);
        LOG.info("new threads got created: " + (threads1 - 2));
        Assert.assertEquals((long)3L, (long)threads1);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, otherProcId);
        Assert.assertEquals((Object)true, (Object)this.procExecutor.isFinished(otherProcId));
        ProcedureTestingUtility.assertProcNotFailed(this.procExecutor, otherProcId);
        Assert.assertEquals((Object)true, (Object)this.procExecutor.isRunning());
        Assert.assertEquals((Object)false, (Object)this.procExecutor.isFinished(busyProcId1));
        Assert.assertEquals((Object)false, (Object)this.procExecutor.isFinished(busyProcId2));
        latch1.release();
        latch2.release();
        LOG.info("set keep alive and wait threads being removed");
        this.procExecutor.setKeepAliveTime(500L, TimeUnit.MILLISECONDS);
        int threads2 = this.waitThreadCount(2);
        LOG.info("threads got removed: " + (threads1 - threads2));
        Assert.assertEquals((long)2L, (long)threads2);
        latch1.release();
        latch2.release();
        ProcedureTestingUtility.waitProcedure(this.procExecutor, busyProcId1);
        ProcedureTestingUtility.waitProcedure(this.procExecutor, busyProcId2);
        ProcedureTestingUtility.assertProcNotFailed(this.procExecutor, busyProcId1);
        ProcedureTestingUtility.assertProcNotFailed(this.procExecutor, busyProcId2);
    }

    @Test
    public void testSubmitBatch() throws Exception {
        int i;
        Procedure[] procs = new Procedure[5];
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new ProcedureTestingUtility.NoopProcedure();
        }
        this.createNewExecutor(this.htu.getConfiguration(), 3);
        this.procExecutor.submitProcedures(procs);
        for (i = 0; i < procs.length; ++i) {
            long procId = procs[i].getProcId();
            ProcedureTestingUtility.waitProcedure(this.procExecutor, procId);
            ProcedureTestingUtility.assertProcNotFailed(this.procExecutor, procId);
        }
    }

    private int waitThreadCount(int expectedThreads) {
        while (this.procExecutor.isRunning() && this.procExecutor.getWorkerThreadCount() != expectedThreads) {
            LOG.debug("waiting for thread count=" + expectedThreads + " current=" + this.procExecutor.getWorkerThreadCount());
            Threads.sleepWithoutInterrupt((long)250L);
        }
        return this.procExecutor.getWorkerThreadCount();
    }

    private static class TestProcEnv {
        private TestProcEnv() {
        }
    }

    public static class BusyWaitProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestProcEnv> {
        private final Semaphore latch;

        public BusyWaitProcedure(Semaphore latch) {
            this.latch = latch;
        }

        @Override
        protected Procedure[] execute(TestProcEnv env) {
            try {
                LOG.info("worker started " + (Object)((Object)this));
                if (!this.latch.tryAcquire(1, 30L, TimeUnit.SECONDS)) {
                    throw new Exception("waited too long");
                }
                LOG.info("worker step 2 " + (Object)((Object)this));
                if (!this.latch.tryAcquire(1, 30L, TimeUnit.SECONDS)) {
                    throw new Exception("waited too long");
                }
            }
            catch (Exception e) {
                LOG.error("got unexpected exception", (Throwable)e);
                this.setFailure("BusyWaitProcedure", e);
            }
            return null;
        }
    }
}

