/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.mapreduce.RegionSizeCalculator;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestTableInputFormatBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableInputFormatBase.class);

    @Test
    public void testReuseRegionSizeCalculator() throws IOException {
        JobContext context = (JobContext)Mockito.mock(JobContext.class);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.client.connection.impl", ConnectionForMergeTesting.class.getName());
        conf.set("hbase.mapreduce.inputtable", "testTable");
        conf.setBoolean("hbase.mapreduce.tif.input.autobalance", true);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)conf);
        TableInputFormat format = (TableInputFormat)Mockito.spy((Object)((Object)new TableInputFormatForMergeTesting()));
        format.setConf(conf);
        format.initialize(context);
        format.getSplits(context);
        format.getSplits(context);
        format.initialize(context);
        format.getSplits(context);
        format.getSplits(context);
        ((TableInputFormat)Mockito.verify((Object)format, (VerificationMode)Mockito.times((int)2))).createRegionSizeCalculator((RegionLocator)Mockito.any(), (Admin)Mockito.any());
    }

    @Test
    public void testTableInputFormatBaseReverseDNSForIPv6() throws UnknownHostException {
        String address = "ipv6.google.com";
        String localhost = null;
        InetAddress addr = null;
        TableInputFormat inputFormat = new TableInputFormat();
        try {
            localhost = InetAddress.getByName(address).getCanonicalHostName();
            addr = Inet6Address.getByName(address);
        }
        catch (UnknownHostException e) {
            return;
        }
        System.out.println("Should retrun the hostname for this host " + localhost + " addr : " + addr);
        String actualHostName = inputFormat.reverseDNS(addr);
        Assert.assertEquals((String)("Should retrun the hostname for this host. Expected : " + localhost + " Actual : " + actualHostName), (Object)localhost, (Object)actualHostName);
    }

    @Test
    public void testNonSuccessiveSplitsAreNotMerged() throws IOException {
        JobContext context = (JobContext)Mockito.mock(JobContext.class);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.client.connection.impl", ConnectionForMergeTesting.class.getName());
        conf.set("hbase.mapreduce.inputtable", "testTable");
        conf.setBoolean("hbase.mapreduce.tif.input.autobalance", true);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)conf);
        TableInputFormatForMergeTesting tifExclude = new TableInputFormatForMergeTesting();
        tifExclude.setConf(conf);
        Assert.assertEquals((long)(ConnectionForMergeTesting.START_KEYS.length - 1 - 1), (long)tifExclude.getSplits(context).size());
    }

    private static class ConnectionForMergeTesting
    implements Connection {
        public static final byte[][] SPLITS;
        public static final byte[][] START_KEYS;
        public static final byte[][] END_KEYS;
        public static final Map<byte[], Long> SIZE_MAP;

        ConnectionForMergeTesting(Configuration conf, ExecutorService pool, User user, Map<String, byte[]> connectionAttributes) throws IOException {
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public Configuration getConfiguration() {
            throw new UnsupportedOperationException();
        }

        public Table getTable(TableName tableName) throws IOException {
            Table table = (Table)Mockito.mock(Table.class);
            Mockito.when((Object)table.getName()).thenReturn((Object)tableName);
            return table;
        }

        public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
            throw new UnsupportedOperationException();
        }

        public RegionLocator getRegionLocator(TableName tableName) throws IOException {
            final TreeMap<byte[], HRegionLocation> locationMap = new TreeMap<byte[], HRegionLocation>(Bytes.BYTES_COMPARATOR);
            for (byte[] startKey : START_KEYS) {
                HRegionLocation hrl = new HRegionLocation(RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).build(), ServerName.valueOf((String)"localhost", (int)0, (long)0L));
                locationMap.put(startKey, hrl);
            }
            RegionLocator locator = (RegionLocator)Mockito.mock(RegionLocator.class);
            Mockito.when((Object)locator.getRegionLocation((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyBoolean())).thenAnswer((Answer)new Answer<HRegionLocation>(){

                public HRegionLocation answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Object[] args = invocationOnMock.getArguments();
                    byte[] key = (byte[])args[0];
                    return (HRegionLocation)locationMap.get(key);
                }
            });
            Mockito.when((Object)locator.getStartEndKeys()).thenReturn((Object)new Pair((Object)START_KEYS, (Object)END_KEYS));
            return locator;
        }

        public RegionSizeCalculator getRegionSizeCalculator() {
            RegionSizeCalculator sizeCalculator = (RegionSizeCalculator)Mockito.mock(RegionSizeCalculator.class);
            Mockito.when((Object)sizeCalculator.getRegionSize((byte[])ArgumentMatchers.any(byte[].class))).thenAnswer((Answer)new Answer<Long>(){

                public Long answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Object[] args = invocationOnMock.getArguments();
                    byte[] regionId = (byte[])args[0];
                    byte[] startKey = RegionInfo.getStartKey((byte[])regionId);
                    return SIZE_MAP.get(startKey);
                }
            });
            return sizeCalculator;
        }

        public Admin getAdmin() throws IOException {
            Admin admin = (Admin)Mockito.mock(Admin.class);
            return admin;
        }

        public void close() throws IOException {
        }

        public boolean isClosed() {
            return false;
        }

        public TableBuilder getTableBuilder(TableName tableName, ExecutorService pool) {
            throw new UnsupportedOperationException();
        }

        public void clearRegionLocationCache() {
        }

        public AsyncConnection toAsyncConnection() {
            throw new UnsupportedOperationException();
        }

        public String getClusterId() {
            return null;
        }

        static {
            int i;
            SPLITS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i"), Bytes.toBytes((String)"j"), Bytes.toBytes((String)"k"), Bytes.toBytes((String)"l"), Bytes.toBytes((String)"m"), Bytes.toBytes((String)"n"), Bytes.toBytes((String)"o"), Bytes.toBytes((String)"p"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"r"), Bytes.toBytes((String)"s"), Bytes.toBytes((String)"t"), Bytes.toBytes((String)"u"), Bytes.toBytes((String)"v"), Bytes.toBytes((String)"w"), Bytes.toBytes((String)"x"), Bytes.toBytes((String)"y"), Bytes.toBytes((String)"z")};
            START_KEYS = new byte[SPLITS.length + 1][];
            ConnectionForMergeTesting.START_KEYS[0] = HConstants.EMPTY_BYTE_ARRAY;
            for (i = 0; i < SPLITS.length; ++i) {
                ConnectionForMergeTesting.START_KEYS[i + 1] = SPLITS[i];
            }
            END_KEYS = new byte[SPLITS.length + 1][];
            for (i = 0; i < SPLITS.length; ++i) {
                ConnectionForMergeTesting.END_KEYS[i] = SPLITS[i];
            }
            ConnectionForMergeTesting.END_KEYS[ConnectionForMergeTesting.SPLITS.length] = HConstants.EMPTY_BYTE_ARRAY;
            SIZE_MAP = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (byte[] startKey : START_KEYS) {
                SIZE_MAP.put(startKey, 0x40000000L);
            }
            SIZE_MAP.put(Bytes.toBytes((String)"a"), 0xC800000L);
            SIZE_MAP.put(Bytes.toBytes((String)"b"), 0xC800000L);
            SIZE_MAP.put(Bytes.toBytes((String)"c"), 0xC800000L);
            SIZE_MAP.put(Bytes.toBytes((String)"o"), 0xC800000L);
            SIZE_MAP.put(Bytes.toBytes((String)"p"), 0xC800000L);
        }
    }

    private static class TableInputFormatForMergeTesting
    extends TableInputFormat {
        private byte[] prefixStartKey = Bytes.toBytes((String)"b");
        private byte[] prefixEndKey = Bytes.toBytes((String)"c");
        private RegionSizeCalculator sizeCalculator;

        private TableInputFormatForMergeTesting() {
        }

        protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
            return Bytes.compareTo((byte[])startKey, (byte[])this.prefixEndKey) >= 0 || Bytes.compareTo((byte[])this.prefixStartKey, (byte[])endKey) >= 0 && !Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        }

        protected void initializeTable(Connection connection, TableName tableName) throws IOException {
            super.initializeTable(connection, tableName);
            ConnectionForMergeTesting cft = (ConnectionForMergeTesting)connection;
            this.sizeCalculator = cft.getRegionSizeCalculator();
        }

        protected RegionSizeCalculator createRegionSizeCalculator(RegionLocator locator, Admin admin) throws IOException {
            return this.sizeCalculator;
        }
    }
}

