/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ZKTests.class, MediumTests.class})
public class TestZKUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKUtil.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestZKUtil.class);
    private static HBaseZKTestingUtil UTIL = new HBaseZKTestingUtil();
    private static ZKWatcher ZKW;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniZKCluster().getClientPort();
        ZKW = new ZKWatcher(new Configuration(UTIL.getConfiguration()), TestZKUtil.class.getName(), (Abortable)new WarnOnlyAbortable());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        Closeables.close((Closeable)ZKW, (boolean)true);
        UTIL.shutdownMiniZKCluster();
        UTIL.cleanupTestDir();
    }

    @Test
    public void testCreateWithParents() throws KeeperException, InterruptedException {
        byte[] expectedData = new byte[]{1, 2, 3};
        ZKUtil.createWithParents((ZKWatcher)ZKW, (String)"/l1/l2/l3/l4/testCreateWithParents", (byte[])expectedData);
        byte[] data = ZKUtil.getData((ZKWatcher)ZKW, (String)"/l1/l2/l3/l4/testCreateWithParents");
        Assert.assertTrue((boolean)Bytes.equals((byte[])expectedData, (byte[])data));
        ZKUtil.deleteNodeRecursively((ZKWatcher)ZKW, (String)"/l1");
        ZKUtil.createWithParents((ZKWatcher)ZKW, (String)"/testCreateWithParents", (byte[])expectedData);
        data = ZKUtil.getData((ZKWatcher)ZKW, (String)"/testCreateWithParents");
        Assert.assertTrue((boolean)Bytes.equals((byte[])expectedData, (byte[])data));
        ZKUtil.deleteNodeRecursively((ZKWatcher)ZKW, (String)"/testCreateWithParents");
    }

    @Test
    public void testZNodeDeletes() throws Exception {
        ZKUtil.createWithParents((ZKWatcher)ZKW, (String)"/l1/l2/l3/l4");
        try {
            ZKUtil.deleteNode((ZKWatcher)ZKW, (String)"/l1/l2");
            Assert.fail((String)"We should not be able to delete if znode has childs");
        }
        catch (KeeperException ex) {
            Assert.assertNotNull((Object)ZKUtil.getDataNoWatch((ZKWatcher)ZKW, (String)"/l1/l2/l3/l4", null));
        }
        ZKUtil.deleteNodeRecursively((ZKWatcher)ZKW, (String)"/l1/l2");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZKWatcher)ZKW, (String)"/l1/l2/l3/l4", null));
        ZKUtil.deleteNodeRecursively((ZKWatcher)ZKW, (String)"/l1/l2");
        ZKUtil.deleteNode((ZKWatcher)ZKW, (String)"/l1");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZKWatcher)ZKW, (String)"/l1/l2", null));
    }

    private int getZNodeDataVersion(String znode) throws KeeperException {
        Stat stat = new Stat();
        ZKUtil.getDataNoWatch((ZKWatcher)ZKW, (String)znode, (Stat)stat);
        return stat.getVersion();
    }

    @Test
    public void testSetDataWithVersion() throws Exception {
        ZKUtil.createWithParents((ZKWatcher)ZKW, (String)"/s1/s2/s3");
        int v0 = this.getZNodeDataVersion("/s1/s2/s3");
        Assert.assertEquals((long)0L, (long)v0);
        ZKUtil.setData((ZKWatcher)ZKW, (String)"/s1/s2/s3", (byte[])Bytes.toBytes((long)12L));
        int v1 = this.getZNodeDataVersion("/s1/s2/s3");
        Assert.assertEquals((long)1L, (long)v1);
        ZKUtil.multiOrSequential((ZKWatcher)ZKW, (List)ImmutableList.of((Object)ZKUtil.ZKUtilOp.setData((String)"/s1/s2/s3", (byte[])Bytes.toBytes((long)13L), (int)v1)), (boolean)false);
        int v2 = this.getZNodeDataVersion("/s1/s2/s3");
        Assert.assertEquals((long)2L, (long)v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSilentIsReallySilent() throws InterruptedException, KeeperException, IOException {
        List oldACL;
        Configuration c = UTIL.getConfiguration();
        String aclZnode = "/aclRoot";
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        int sessionTimeout = 5000;
        ZooKeeper zk = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance);
        zk.addAuthInfo("digest", Bytes.toBytes((String)"hbase:rox"));
        block18: while (true) {
            try {
                Stat s = new Stat();
                oldACL = zk.getACL("/", s);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception", (Throwable)e);
                        Threads.sleep((long)100L);
                        continue block18;
                    }
                }
                throw e;
            }
            break;
        }
        block19: while (true) {
            try {
                zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        Threads.sleep((long)100L);
                        continue block19;
                    }
                }
                throw e;
            }
            break;
        }
        block20: while (true) {
            try {
                zk.create(aclZnode, null, (List)ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            }
            catch (KeeperException e) {
                switch (e.code()) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case OPERATIONTIMEOUT: {
                        LOG.warn("Possibly transient ZooKeeper exception: " + (Object)((Object)e));
                        Threads.sleep((long)100L);
                        continue block20;
                    }
                }
                throw e;
            }
            break;
        }
        zk.close();
        ZKUtil.createAndFailSilent((ZKWatcher)ZKW, (String)aclZnode);
        zk3.addAuthInfo("digest", Bytes.toBytes((String)"hbase:rox"));
        try (ZooKeeper zk3 = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance);){
            zk3.setACL("/", oldACL, -1);
        }
    }

    @Test
    public void testGetChildDataAndWatchForNewChildrenShouldNotThrowNPE() throws Exception {
        ZKUtil.getChildDataAndWatchForNewChildren((ZKWatcher)ZKW, (String)"/wrongNode");
    }

    private static class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn("ZKWatcher received abort, ignoring.  Reason: " + why);
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.toString(), e);
            }
        }

        public boolean isAborted() {
            return false;
        }
    }
}

