/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.errorprone.annotations.RestrictedApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ZKReplicationStorageBase;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKReplicationQueueStorageForMigration
extends ZKReplicationStorageBase {
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY = "zookeeper.znode.replication.hfile.refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT = "hfile-refs";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_REGIONS_KEY = "zookeeper.znode.replication.regions";
    public static final String ZOOKEEPER_ZNODE_REPLICATION_REGIONS_DEFAULT = "regions";
    private final String queuesZNode;
    private final String hfileRefsZNode;
    private final String regionsZNode;
    private static final MigrationIterator EMPTY_ITER = new MigrationIterator(){

        public Object next() {
            return null;
        }
    };

    public ZKReplicationQueueStorageForMigration(ZKWatcher zookeeper, Configuration conf) {
        super(zookeeper, conf);
        String queuesZNodeName = conf.get("zookeeper.znode.replication.rs", "rs");
        String hfileRefsZNodeName = conf.get(ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_KEY, ZOOKEEPER_ZNODE_REPLICATION_HFILE_REFS_DEFAULT);
        this.queuesZNode = ZNodePaths.joinZNode((String)this.replicationZNode, (String[])new String[]{queuesZNodeName});
        this.hfileRefsZNode = ZNodePaths.joinZNode((String)this.replicationZNode, (String[])new String[]{hfileRefsZNodeName});
        this.regionsZNode = ZNodePaths.joinZNode((String)this.replicationZNode, (String[])new String[]{conf.get(ZOOKEEPER_ZNODE_REPLICATION_REGIONS_KEY, ZOOKEEPER_ZNODE_REPLICATION_REGIONS_DEFAULT)});
    }

    private String getRsNode(ServerName serverName) {
        return ZNodePaths.joinZNode((String)this.queuesZNode, (String[])new String[]{serverName.getServerName()});
    }

    private String getQueueNode(ServerName serverName, String queueId) {
        return ZNodePaths.joinZNode((String)this.getRsNode(serverName), (String[])new String[]{queueId});
    }

    private String getFileNode(String queueNode, String fileName) {
        return ZNodePaths.joinZNode((String)queueNode, (String[])new String[]{fileName});
    }

    private String getFileNode(ServerName serverName, String queueId, String fileName) {
        return this.getFileNode(this.getQueueNode(serverName, queueId), fileName);
    }

    public MigrationIterator<Pair<ServerName, List<ZkReplicationQueueData>>> listAllQueues() throws KeeperException {
        List replicators = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zookeeper, (String)this.queuesZNode);
        if (replicators == null || replicators.isEmpty()) {
            ZKUtil.deleteNodeRecursively((ZKWatcher)this.zookeeper, (String)this.queuesZNode);
            return EMPTY_ITER;
        }
        final Iterator iter = replicators.iterator();
        return new MigrationIterator<Pair<ServerName, List<ZkReplicationQueueData>>>(){
            private ServerName previousServerName;

            @Override
            public Pair<ServerName, List<ZkReplicationQueueData>> next() throws Exception {
                ServerName serverName;
                if (this.previousServerName != null) {
                    ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.getRsNode(this.previousServerName));
                }
                if (!iter.hasNext()) {
                    ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.queuesZNode);
                    return null;
                }
                String replicator = (String)iter.next();
                this.previousServerName = serverName = ServerName.parseServerName((String)replicator);
                List queueIdList = ZKUtil.listChildrenNoWatch((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.getRsNode(serverName));
                if (queueIdList == null || queueIdList.isEmpty()) {
                    return Pair.newPair((Object)serverName, Collections.emptyList());
                }
                ArrayList<ZkReplicationQueueData> queueDataList = new ArrayList<ZkReplicationQueueData>(queueIdList.size());
                for (String queueIdStr : queueIdList) {
                    ZkReplicationQueueData queueData;
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueIdStr);
                    ReplicationQueueId queueId = queueInfo.getDeadRegionServers().isEmpty() ? new ReplicationQueueId(serverName, queueInfo.getPeerId()) : new ReplicationQueueId(serverName, queueInfo.getPeerId(), queueInfo.getDeadRegionServers().get(0));
                    List wals = ZKUtil.listChildrenNoWatch((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.getQueueNode(serverName, queueIdStr));
                    if (wals == null || wals.isEmpty()) {
                        queueData = new ZkReplicationQueueData(queueId, Collections.emptyMap());
                    } else {
                        HashMap<String, Long> walOffsets = new HashMap<String, Long>();
                        for (String wal : wals) {
                            byte[] data = ZKUtil.getData((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.getFileNode(serverName, queueIdStr, wal));
                            if (data == null || data.length == 0) {
                                walOffsets.put(wal, 0L);
                                continue;
                            }
                            walOffsets.put(wal, ZKUtil.parseWALPositionFrom((byte[])data));
                        }
                        queueData = new ZkReplicationQueueData(queueId, walOffsets);
                    }
                    queueDataList.add(queueData);
                }
                return Pair.newPair((Object)serverName, queueDataList);
            }
        };
    }

    public MigrationIterator<List<ZkLastPushedSeqId>> listAllLastPushedSeqIds() throws KeeperException {
        List level1Prefixs = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zookeeper, (String)this.regionsZNode);
        if (level1Prefixs == null || level1Prefixs.isEmpty()) {
            ZKUtil.deleteNodeRecursively((ZKWatcher)this.zookeeper, (String)this.regionsZNode);
            return EMPTY_ITER;
        }
        final Iterator level1Iter = level1Prefixs.iterator();
        return new MigrationIterator<List<ZkLastPushedSeqId>>(){
            private String level1Prefix;
            private Iterator<String> level2Iter;
            private String level2Prefix;

            @Override
            public List<ZkLastPushedSeqId> next() throws Exception {
                while (this.level2Iter == null || !this.level2Iter.hasNext()) {
                    if (!level1Iter.hasNext()) {
                        ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.regionsZNode);
                        return null;
                    }
                    if (this.level1Prefix != null) {
                        ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZNodePaths.joinZNode((String)ZKReplicationQueueStorageForMigration.this.regionsZNode, (String[])new String[]{this.level1Prefix}));
                    }
                    this.level1Prefix = (String)level1Iter.next();
                    List level2Prefixes = ZKUtil.listChildrenNoWatch((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZNodePaths.joinZNode((String)ZKReplicationQueueStorageForMigration.this.regionsZNode, (String[])new String[]{this.level1Prefix}));
                    if (level2Prefixes == null) continue;
                    this.level2Iter = level2Prefixes.iterator();
                    this.level2Prefix = null;
                }
                if (this.level2Prefix != null) {
                    ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZNodePaths.joinZNode((String)ZKReplicationQueueStorageForMigration.this.regionsZNode, (String[])new String[]{this.level1Prefix, this.level2Prefix}));
                }
                this.level2Prefix = this.level2Iter.next();
                List encodedRegionNameAndPeerIds = ZKUtil.listChildrenNoWatch((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZNodePaths.joinZNode((String)ZKReplicationQueueStorageForMigration.this.regionsZNode, (String[])new String[]{this.level1Prefix, this.level2Prefix}));
                if (encodedRegionNameAndPeerIds == null || encodedRegionNameAndPeerIds.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<ZkLastPushedSeqId> lastPushedSeqIds = new ArrayList<ZkLastPushedSeqId>();
                for (String encodedRegionNameAndPeerId : encodedRegionNameAndPeerIds) {
                    byte[] data = ZKUtil.getData((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZNodePaths.joinZNode((String)ZKReplicationQueueStorageForMigration.this.regionsZNode, (String[])new String[]{this.level1Prefix, this.level2Prefix, encodedRegionNameAndPeerId}));
                    long lastPushedSeqId = ZKUtil.parseWALPositionFrom((byte[])data);
                    Iterator iter = Splitter.on((char)'-').split((CharSequence)encodedRegionNameAndPeerId).iterator();
                    String encodedRegionName = this.level1Prefix + this.level2Prefix + (String)iter.next();
                    String peerId = (String)iter.next();
                    lastPushedSeqIds.add(new ZkLastPushedSeqId(encodedRegionName, peerId, lastPushedSeqId));
                }
                return Collections.unmodifiableList(lastPushedSeqIds);
            }
        };
    }

    private String getHFileRefsPeerNode(String peerId) {
        return ZNodePaths.joinZNode((String)this.hfileRefsZNode, (String[])new String[]{peerId});
    }

    public MigrationIterator<Pair<String, List<String>>> listAllHFileRefs() throws KeeperException {
        List peerIds = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zookeeper, (String)this.hfileRefsZNode);
        if (peerIds == null || peerIds.isEmpty()) {
            ZKUtil.deleteNodeRecursively((ZKWatcher)this.zookeeper, (String)this.hfileRefsZNode);
            return EMPTY_ITER;
        }
        final Iterator iter = peerIds.iterator();
        return new MigrationIterator<Pair<String, List<String>>>(){
            private String previousPeerId;

            @Override
            public Pair<String, List<String>> next() throws KeeperException {
                if (this.previousPeerId != null) {
                    ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.getHFileRefsPeerNode(this.previousPeerId));
                }
                if (!iter.hasNext()) {
                    ZKUtil.deleteNodeRecursively((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.hfileRefsZNode);
                    return null;
                }
                String peerId = (String)iter.next();
                List refs = ZKUtil.listChildrenNoWatch((ZKWatcher)ZKReplicationQueueStorageForMigration.this.zookeeper, (String)ZKReplicationQueueStorageForMigration.this.getHFileRefsPeerNode(peerId));
                this.previousPeerId = peerId;
                return Pair.newPair((Object)peerId, refs != null ? refs : Collections.emptyList());
            }
        };
    }

    public boolean hasData() throws KeeperException {
        return ZKUtil.checkExists((ZKWatcher)this.zookeeper, (String)this.queuesZNode) != -1 || ZKUtil.checkExists((ZKWatcher)this.zookeeper, (String)this.regionsZNode) != -1 || ZKUtil.checkExists((ZKWatcher)this.zookeeper, (String)this.hfileRefsZNode) != -1;
    }

    public void deleteAllData() throws KeeperException {
        ZKUtil.deleteNodeRecursively((ZKWatcher)this.zookeeper, (String)this.queuesZNode);
        ZKUtil.deleteNodeRecursively((ZKWatcher)this.zookeeper, (String)this.regionsZNode);
        ZKUtil.deleteNodeRecursively((ZKWatcher)this.zookeeper, (String)this.hfileRefsZNode);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    String getQueuesZNode() {
        return this.queuesZNode;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    String getHfileRefsZNode() {
        return this.hfileRefsZNode;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    String getRegionsZNode() {
        return this.regionsZNode;
    }

    public static final class ZkLastPushedSeqId {
        private final String encodedRegionName;
        private final String peerId;
        private final long lastPushedSeqId;

        ZkLastPushedSeqId(String encodedRegionName, String peerId, long lastPushedSeqId) {
            this.encodedRegionName = encodedRegionName;
            this.peerId = peerId;
            this.lastPushedSeqId = lastPushedSeqId;
        }

        public String getEncodedRegionName() {
            return this.encodedRegionName;
        }

        public String getPeerId() {
            return this.peerId;
        }

        public long getLastPushedSeqId() {
            return this.lastPushedSeqId;
        }
    }

    public static final class ZkReplicationQueueData {
        private final ReplicationQueueId queueId;
        private final Map<String, Long> walOffsets;

        public ZkReplicationQueueData(ReplicationQueueId queueId, Map<String, Long> walOffsets) {
            this.queueId = queueId;
            this.walOffsets = walOffsets;
        }

        public ReplicationQueueId getQueueId() {
            return this.queueId;
        }

        public Map<String, Long> getWalOffsets() {
            return this.walOffsets;
        }
    }

    public static interface MigrationIterator<T> {
        public T next() throws Exception;
    }
}

