/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.ClientMetaTableAccessor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncTableRegionLocatorImpl
implements AsyncTableRegionLocator {
    private final TableName tableName;
    private final AsyncConnectionImpl conn;

    public AsyncTableRegionLocatorImpl(TableName tableName, AsyncConnectionImpl conn) {
        this.tableName = tableName;
        this.conn = conn;
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row, int replicaId, boolean reload) {
        return this.conn.getLocator().getRegionLocation(this.tableName, row, replicaId, RegionLocateType.CURRENT, reload, -1L);
    }

    @Override
    public CompletableFuture<List<HRegionLocation>> getAllRegionLocations() {
        return TraceUtil.tracedFuture(() -> {
            if (TableName.isMetaTableName((TableName)this.tableName)) {
                return this.conn.registry.getMetaRegionLocations().thenApply(locs -> Arrays.asList(locs.getRegionLocations()));
            }
            CompletableFuture<List<HRegionLocation>> future = ClientMetaTableAccessor.getTableHRegionLocations(this.conn.getTable(TableName.META_TABLE_NAME), this.tableName);
            FutureUtils.addListener(future, (locs, error) -> locs.forEach(loc -> {
                if (loc.getServerName() != null) {
                    this.conn.getLocator().getNonMetaRegionLocator().addLocationToCache((HRegionLocation)loc);
                }
            }));
            return future;
        }, (String)(this.getClass().getSimpleName() + ".getAllRegionLocations"));
    }

    @Override
    public CompletableFuture<List<HRegionLocation>> getRegionLocations(byte[] row, boolean reload) {
        return this.conn.getLocator().getRegionLocations(this.tableName, row, RegionLocateType.CURRENT, reload, -1L).thenApply(locs -> Arrays.asList(locs.getRegionLocations()));
    }

    @Override
    public void clearRegionLocationCache() {
        this.conn.getLocator().clearCache(this.tableName);
    }
}

