/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SampleUploader
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(SampleUploader.class);
    private static final String NAME = "SampleUploader";

    public static Job configureJob(Configuration conf, String[] args) throws IOException {
        Path inputPath = new Path(args[0]);
        String tableName = args[1];
        Job job = new Job(conf, "SampleUploader_" + tableName);
        job.setJarByClass(Uploader.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputPath});
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapperClass(Uploader.class);
        TableMapReduceUtil.initTableReducerJob((String)tableName, null, (Job)job);
        job.setNumReduceTasks(0);
        return job;
    }

    public int run(String[] otherArgs) throws Exception {
        if (otherArgs.length != 2) {
            System.err.println("Wrong number of arguments: " + otherArgs.length);
            System.err.println("Usage: SampleUploader <input> <tablename>");
            return -1;
        }
        Job job = SampleUploader.configureJob(this.getConf(), otherArgs);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int status = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new SampleUploader(), (String[])args);
        System.exit(status);
    }

    static class Uploader
    extends Mapper<LongWritable, Text, ImmutableBytesWritable, Put> {
        private long checkpoint = 100L;
        private long count = 0L;

        Uploader() {
        }

        public void map(LongWritable key, Text line, Mapper.Context context) throws IOException {
            List values = Splitter.on((char)',').splitToList((CharSequence)line.toString());
            if (values.size() != 4) {
                return;
            }
            Iterator i = values.iterator();
            byte[] row = Bytes.toBytes((String)((String)i.next()));
            byte[] family = Bytes.toBytes((String)((String)i.next()));
            byte[] qualifier = Bytes.toBytes((String)((String)i.next()));
            byte[] value = Bytes.toBytes((String)((String)i.next()));
            Put put = new Put(row);
            put.addColumn(family, qualifier, value);
            try {
                context.write((Object)new ImmutableBytesWritable(row), (Object)put);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted emitting put", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (++this.count % this.checkpoint == 0L) {
                context.setStatus("Emitting Put " + this.count);
            }
        }
    }
}

