/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWrongMetaWALFileName {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWrongMetaWALFileName.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.wal.provider", WALFactory.Providers.multiwal.name());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        TableName tableName = TableName.valueOf((String)"whatever");
        UTIL.createTable(tableName, Bytes.toBytes((String)"family"));
        UTIL.waitTableAvailable(tableName);
        HRegionServer rs = UTIL.getMiniHBaseCluster().getRegionServer(0);
        Path walDir = new Path(rs.getWALRootDir(), AbstractFSWALProvider.getWALDirectoryName((String)rs.getServerName().toString()));
        Assert.assertTrue((rs.getWALFileSystem().listStatus(walDir, AbstractFSWALProvider::isMetaFile).length > 0 ? 1 : 0) != 0);
    }
}

