/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HbckRegionInfo;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHBaseFsckComparator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseFsckComparator.class);
    TableName table = TableName.valueOf((String)"table1");
    TableName table2 = TableName.valueOf((String)"table2");
    byte[] keyStart = Bytes.toBytes((String)"");
    byte[] keyA = Bytes.toBytes((String)"A");
    byte[] keyB = Bytes.toBytes((String)"B");
    byte[] keyC = Bytes.toBytes((String)"C");
    byte[] keyEnd = Bytes.toBytes((String)"");

    static HbckRegionInfo genHbckInfo(TableName table, byte[] start, byte[] end, int time) {
        return new HbckRegionInfo(new HbckRegionInfo.MetaEntry(RegionInfoBuilder.newBuilder((TableName)table).setStartKey(start).setEndKey(end).build(), null, (long)time));
    }

    @Test
    public void testEquals() {
        HbckRegionInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        HbckRegionInfo hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        Assert.assertEquals((long)0L, (long)HbckRegionInfo.COMPARATOR.compare(hi1, hi2));
        Assert.assertEquals((long)0L, (long)HbckRegionInfo.COMPARATOR.compare(hi2, hi1));
    }

    @Test
    public void testEqualsInstance() {
        HbckRegionInfo hi1;
        HbckRegionInfo hi2 = hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        Assert.assertEquals((long)0L, (long)HbckRegionInfo.COMPARATOR.compare(hi1, hi2));
        Assert.assertEquals((long)0L, (long)HbckRegionInfo.COMPARATOR.compare(hi2, hi1));
    }

    @Test
    public void testDiffTable() {
        HbckRegionInfo hi2;
        HbckRegionInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table2, this.keyA, this.keyC, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDiffStartKey() {
        HbckRegionInfo hi2;
        HbckRegionInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyStart, this.keyC, 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDiffEndKey() {
        HbckRegionInfo hi2;
        HbckRegionInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAbsEndKey() {
        HbckRegionInfo hi2;
        HbckRegionInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyEnd, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HbckRegionInfo.COMPARATOR.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }
}

