/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestSnapshotDescriptionUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotDescriptionUtils.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static FileSystem fs;
    private static Path root;
    private static final Logger LOG;

    @BeforeClass
    public static void setupFS() throws Exception {
        fs = UTIL.getTestFileSystem();
        root = new Path(UTIL.getDataTestDir(), "hbase");
    }

    @After
    public void cleanupFS() throws Exception {
        if (fs.exists(root)) {
            if (!fs.delete(root, true)) {
                throw new IOException("Failed to delete root test dir: " + root);
            }
            if (!fs.mkdirs(root)) {
                throw new IOException("Failed to create root test dir: " + root);
            }
        }
        EnvironmentEdgeManagerTestHelper.reset();
    }

    @Test
    public void testValidateMissingTableName() throws IOException {
        Configuration conf = new Configuration(false);
        try {
            SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)SnapshotProtos.SnapshotDescription.newBuilder().setName("fail").build(), (Configuration)conf);
            Assert.fail((String)"Snapshot was considered valid without a table name");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Correctly failed when snapshot doesn't have a tablename");
        }
    }

    @Test
    public void testCompleteSnapshotWithNoSnapshotDirectoryFailure() throws Exception {
        Path snapshotDir = new Path(root, ".hbase-snapshot");
        Path tmpDir = new Path(snapshotDir, ".tmp");
        Path workingDir = new Path(tmpDir, "not_a_snapshot");
        Configuration conf = new Configuration();
        FileSystem workingFs = workingDir.getFileSystem(conf);
        Assert.assertFalse((String)("Already have working snapshot dir: " + workingDir + " but shouldn't. Test file leak?"), (boolean)fs.exists(workingDir));
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName("snapshot").build();
        Path finishedDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((SnapshotProtos.SnapshotDescription)snapshot, (Path)snapshotDir);
        try {
            SnapshotDescriptionUtils.completeSnapshot((Path)finishedDir, (Path)workingDir, (FileSystem)fs, (FileSystem)workingFs, (Configuration)conf);
            Assert.fail((String)"Shouldn't successfully complete move of a non-existent directory.");
        }
        catch (IOException e) {
            LOG.info("Correctly failed to move non-existant directory: " + e.getMessage());
        }
    }

    @Test
    public void testIsSubDirectoryWorks() {
        Path rootDir = new Path("hdfs://root/.hbase-snapshot/");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)rootDir, (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshotdir"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshot"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://.hbase-snapshot"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://.hbase-snapshot/.tmp"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root"), (Path)rootDir));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshot/.tmp"), (Path)rootDir));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("hdfs://root/.hbase-snapshot/.tmp/snapshot"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("s3://root/.hbase-snapshot/"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("s3://root"), (Path)rootDir));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isSubDirectoryOf((Path)new Path("s3://root/.hbase-snapshot/.tmp/snapshot"), (Path)rootDir));
    }

    @Test
    public void testIsWithinWorkingDir() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbase.rootdir", "hdfs://localhost/root/");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/root/"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/root/.hbase-snapshotdir"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/root/.hbase-snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/.hbase-snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/.hbase-snapshot/.tmp"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/root"), (Configuration)conf));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/root/.hbase-snapshot/.tmp"), (Configuration)conf));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("hdfs://localhost/root/.hbase-snapshot/.tmp/snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("s3://localhost/root/.hbase-snapshot/"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("s3://localhost/root"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("s3://localhost/root/.hbase-snapshot/.tmp/snapshot"), (Configuration)conf));
        conf = HBaseConfiguration.create();
        String hbsaeDir = conf.get("hbase.rootdir");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:" + hbsaeDir + "/"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:" + hbsaeDir + "/.hbase-snapshotdir"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:" + hbsaeDir + "/.hbase-snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:/.hbase-snapshot"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:/.hbase-snapshot/.tmp"), (Configuration)conf));
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:" + hbsaeDir), (Configuration)conf));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:" + hbsaeDir + "/.hbase-snapshot/.tmp"), (Configuration)conf));
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.isWithinDefaultWorkingDir((Path)new Path("file:" + hbsaeDir + "/.hbase-snapshot/.tmp/snapshot"), (Configuration)conf));
    }

    @Test
    public void testShouldSkipRenameSnapshotDirectories() {
        URI workingDirURI = URI.create("/User/test1");
        URI rootDirURI = URI.create("hdfs:///User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("/User/test1");
        rootDirURI = URI.create("file:///User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://otherhost:8020/User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("file:///User/test1");
        rootDirURI = URI.create("hdfs://localhost:8020/User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs:///User/test1");
        rootDirURI = URI.create("hdfs:///User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://localhost:8020/User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://user:password@localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://user:password@localhost:8020/User/test2");
        Assert.assertFalse((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
        workingDirURI = URI.create("hdfs://user:password@localhost:8020/User/test1");
        rootDirURI = URI.create("hdfs://user2:password2@localhost:8020/User/test2");
        Assert.assertTrue((boolean)SnapshotDescriptionUtils.shouldSkipRenameSnapshotDirectories((URI)workingDirURI, (URI)rootDirURI));
    }

    static {
        LOG = LoggerFactory.getLogger(TestSnapshotDescriptionUtils.class);
    }
}

