/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRestoreSnapshotHelper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRestoreSnapshotHelper.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRestoreSnapshotHelper.class);
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected static final String TEST_HFILE = "abc";
    protected Configuration conf;
    protected Path archiveDir;
    protected FileSystem fs;
    protected Path rootDir;

    protected void setupConf(Configuration conf) {
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.rootDir = TEST_UTIL.getDataTestDir("testRestore");
        this.archiveDir = new Path(this.rootDir, "archive");
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
        this.setupConf(this.conf);
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)this.rootDir);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(TEST_UTIL.getDataTestDir(), true);
    }

    protected SnapshotTestingUtils.SnapshotMock createSnapshotMock() throws IOException {
        return new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), this.fs, this.rootDir);
    }

    @Test
    public void testRestore() throws IOException {
        this.restoreAndVerify("snapshot", "testRestore");
    }

    @Test
    public void testRestoreWithNamespace() throws IOException {
        this.restoreAndVerify("snapshot", "namespace1:testRestoreWithNamespace");
    }

    @Test
    public void testNoHFileLinkInRootDir() throws IOException {
        this.rootDir = TEST_UTIL.getDefaultRootDirPath();
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)this.rootDir);
        this.fs = this.rootDir.getFileSystem(this.conf);
        TableName tableName = TableName.valueOf((String)"testNoHFileLinkInRootDir");
        String snapshotName = tableName.getNameAsString() + "-snapshot";
        this.createTableAndSnapshot(tableName, snapshotName);
        Path restoreDir = new Path("/hbase/.tmp-restore");
        RestoreSnapshotHelper.copySnapshotForScanner((Configuration)this.conf, (FileSystem)this.fs, (Path)this.rootDir, (Path)restoreDir, (String)snapshotName);
        this.checkNoHFileLinkInTableDir(tableName);
    }

    @Test
    public void testSkipReplayAndUpdateSeqId() throws Exception {
        this.rootDir = TEST_UTIL.getDefaultRootDirPath();
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)this.rootDir);
        TableName tableName = TableName.valueOf((String)"testSkipReplayAndUpdateSeqId");
        String snapshotName = "testSkipReplayAndUpdateSeqId";
        this.createTableAndSnapshot(tableName, snapshotName);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        TEST_UTIL.loadTable(table, Bytes.toBytes((String)"A"));
        Configuration conf = TEST_UTIL.getConfiguration();
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        Path restoreDir = new Path("/hbase/.tmp-restore/testScannerWithRestoreScanner2");
        RestoreSnapshotHelper.RestoreMetaChanges meta = RestoreSnapshotHelper.copySnapshotForScanner((Configuration)conf, (FileSystem)this.fs, (Path)rootDir, (Path)restoreDir, (String)snapshotName);
        TableDescriptor htd = meta.getTableDescriptor();
        List restoredRegions = meta.getRegionsToAdd();
        for (RegionInfo restoredRegion : restoredRegions) {
            HRegion region = HRegion.newHRegion((Path)CommonFSUtils.getTableDir((Path)restoreDir, (TableName)tableName), null, (FileSystem)this.fs, (Configuration)conf, (RegionInfo)restoredRegion, (TableDescriptor)htd, null);
            region.setRestoredRegion(true);
            region.initialize();
            Path recoveredEdit = CommonFSUtils.getWALRegionDir((Configuration)conf, (TableName)tableName, (String)region.getRegionInfo().getEncodedName());
            long maxSeqId = WALSplitUtil.getMaxRegionSequenceId((FileSystem)this.fs, (Path)recoveredEdit);
            HRegion region2 = HRegion.newHRegion((Path)CommonFSUtils.getTableDir((Path)restoreDir, (TableName)tableName), null, (FileSystem)this.fs, (Configuration)conf, (RegionInfo)restoredRegion, (TableDescriptor)htd, null);
            region2.initialize();
            long maxSeqId2 = WALSplitUtil.getMaxRegionSequenceId((FileSystem)this.fs, (Path)recoveredEdit);
            Assert.assertTrue((maxSeqId2 > maxSeqId ? 1 : 0) != 0);
        }
    }

    protected void createTableAndSnapshot(TableName tableName, String snapshotName) throws IOException {
        byte[] column = Bytes.toBytes((String)"A");
        Table table = TEST_UTIL.createTable(tableName, column, 2);
        TEST_UTIL.loadTable(table, column);
        TEST_UTIL.getAdmin().snapshot(snapshotName, tableName);
    }

    private void checkNoHFileLinkInTableDir(TableName tableName) throws IOException {
        Path[] tableDirs;
        for (Path tableDir : tableDirs = new Path[]{CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)tableName), CommonFSUtils.getTableDir((Path)new Path(this.rootDir, "archive"), (TableName)tableName), CommonFSUtils.getTableDir((Path)MobUtils.getMobHome((Path)this.rootDir), (TableName)tableName)}) {
            Assert.assertFalse((boolean)this.hasHFileLink(tableDir));
        }
    }

    private boolean hasHFileLink(Path tableDir) throws IOException {
        if (this.fs.exists(tableDir)) {
            RemoteIterator iterator = this.fs.listFiles(tableDir, true);
            while (iterator.hasNext()) {
                LocatedFileStatus fileStatus = (LocatedFileStatus)iterator.next();
                if (!fileStatus.isFile() || !HFileLink.isHFileLink((Path)fileStatus.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    private void restoreAndVerify(String snapshotName, String tableName) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = this.createSnapshotMock();
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("snapshot", tableName);
        builder.addRegionV1();
        builder.addRegionV2();
        builder.addRegionV2();
        builder.addRegionV1();
        Path snapshotDir = builder.commit();
        TableDescriptor htd = builder.getTableDescriptor();
        SnapshotProtos.SnapshotDescription desc = builder.getSnapshotDescription();
        TableDescriptor htdClone = snapshotMock.createHtd("testtb-clone");
        this.testRestore(snapshotDir, desc, htdClone);
        this.verifyRestore(this.rootDir, htd, htdClone);
        SnapshotProtos.SnapshotDescription cloneDesc = SnapshotProtos.SnapshotDescription.newBuilder().setName("cloneSnapshot").setTable("testtb-clone").build();
        Path cloneDir = CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)htdClone.getTableName());
        TableDescriptor htdClone2 = snapshotMock.createHtd("testtb-clone2");
        this.testRestore(cloneDir, cloneDesc, htdClone2);
        this.verifyRestore(this.rootDir, htd, htdClone2);
    }

    private void verifyRestore(Path rootDir, TableDescriptor sourceHtd, TableDescriptor htdClone) throws IOException {
        ArrayList<String> files = SnapshotTestingUtils.listHFileNames(this.fs, CommonFSUtils.getTableDir((Path)rootDir, (TableName)htdClone.getTableName()));
        Assert.assertEquals((long)12L, (long)files.size());
        for (int i = 0; i < files.size(); i += 2) {
            String linkFile = (String)files.get(i);
            String refFile = (String)files.get(i + 1);
            Assert.assertTrue((String)(linkFile + " should be a HFileLink"), (boolean)HFileLink.isHFileLink((String)linkFile));
            Assert.assertTrue((String)(refFile + " should be a Referene"), (boolean)StoreFileInfo.isReference((String)refFile));
            Assert.assertEquals((Object)sourceHtd.getTableName(), (Object)HFileLink.getReferencedTableName((String)linkFile));
            Path refPath = this.getReferredToFile(refFile);
            LOG.debug("get reference name for file " + refFile + " = " + refPath);
            Assert.assertTrue((String)(refPath.getName() + " should be a HFileLink"), (boolean)HFileLink.isHFileLink((String)refPath.getName()));
            Assert.assertEquals((Object)linkFile, (Object)refPath.getName());
        }
    }

    private void testRestore(Path snapshotDir, SnapshotProtos.SnapshotDescription sd, TableDescriptor htdClone) throws IOException {
        LOG.debug("pre-restore table=" + htdClone.getTableName() + " snapshot=" + snapshotDir);
        CommonFSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.rootDir, (Logger)LOG);
        new FSTableDescriptors(this.conf).createTableDescriptor(htdClone);
        RestoreSnapshotHelper helper = this.getRestoreHelper(this.rootDir, snapshotDir, sd, htdClone);
        helper.restoreHdfsRegions();
        LOG.debug("post-restore table=" + htdClone.getTableName() + " snapshot=" + snapshotDir);
        CommonFSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.rootDir, (Logger)LOG);
    }

    private RestoreSnapshotHelper getRestoreHelper(Path rootDir, Path snapshotDir, SnapshotProtos.SnapshotDescription sd, TableDescriptor htdClone) throws IOException {
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        MonitoredTask status = (MonitoredTask)Mockito.mock(MonitoredTask.class);
        SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)sd);
        return new RestoreSnapshotHelper(this.conf, this.fs, manifest, htdClone, rootDir, monitor, status);
    }

    private Path getReferredToFile(String referenceName) {
        Path fakeBasePath = new Path(new Path("table", "region"), "cf");
        return StoreFileInfo.getReferredToFile((Path)new Path(fakeBasePath, referenceName));
    }
}

