/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestRSGroupsWithACL
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsWithACL.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsWithACL.class);
    private static TableName TEST_TABLE = TableName.valueOf((String)"testtable1");
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Configuration conf;
    private static Connection systemUserConnection;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static byte[] TEST_FAMILY;
    private static HMaster master;
    private static AccessChecker accessChecker;
    private static UserProvider userProvider;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestRSGroupsWithACL.enableSecurity(conf);
        TestRSGroupsWithACL.verifyConfiguration(conf);
        RSGroupUtil.enableRSGroup((Configuration)conf);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(PermissionStorage.ACL_TABLE_NAME);
        TEST_UTIL.waitUntilAllRegionsAssigned(RSGroupInfoManagerImpl.RSGROUP_TABLE_NAME);
        TEST_UTIL.waitUntilNoRegionsInTransition();
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting((Configuration)conf, (String)"user_group_create", (String[])new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting((Configuration)conf, (String)"user_group_read", (String[])new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting((Configuration)conf, (String)"user_group_write", (String[])new String[]{GROUP_WRITE});
        TestRSGroupsWithACL.grantGlobal(TEST_UTIL, USER_OWNER.getShortName(), Permission.Action.CREATE);
        systemUserConnection = TEST_UTIL.getConnection();
        TestRSGroupsWithACL.setUpTableAndUserPermissions();
        master = TEST_UTIL.getHBaseCluster().getMaster();
        accessChecker = master.getAccessChecker();
        userProvider = UserProvider.instantiate((Configuration)TEST_UTIL.getConfiguration());
    }

    private void checkPermission(String request) throws IOException {
        accessChecker.requirePermission(this.getActiveUser(), request, null, Permission.Action.ADMIN);
    }

    private User getActiveUser() throws IOException {
        Optional optionalUser = RpcServer.getRequestUser();
        if (optionalUser.isPresent()) {
            return (User)optionalUser.get();
        }
        return userProvider.getCurrent();
    }

    private static void setUpTableAndUserPermissions() throws Exception {
        TableDescriptorBuilder tableBuilder = TableDescriptorBuilder.newBuilder((TableName)TEST_TABLE);
        ColumnFamilyDescriptorBuilder cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])TEST_FAMILY);
        cfd.setMaxVersions(100);
        tableBuilder.setColumnFamily(cfd.build());
        TestRSGroupsWithACL.createTable(TEST_UTIL, USER_OWNER, tableBuilder.build(), (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TestRSGroupsWithACL.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestRSGroupsWithACL.grantOnTable(TEST_UTIL, USER_RW.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestRSGroupsWithACL.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), TEST_TABLE, null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestRSGroupsWithACL.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestRSGroupsWithACL.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN);
        TestRSGroupsWithACL.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_CREATE), Permission.Action.CREATE);
        TestRSGroupsWithACL.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_READ), Permission.Action.READ);
        TestRSGroupsWithACL.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_WRITE), Permission.Action.WRITE);
        Assert.assertEquals((long)4L, (long)PermissionStorage.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        try {
            Assert.assertEquals((long)4L, (long)AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)TEST_TABLE.toString()).size());
        }
        catch (AssertionError e) {
            Assert.fail((String)((Throwable)((Object)e)).getMessage());
        }
        catch (Throwable e) {
            LOG.error("error during call of AccessControlClient.getUserPermissions. ", e);
        }
    }

    private static void cleanUp() throws Exception {
        try {
            TestRSGroupsWithACL.deleteTable(TEST_UTIL, TEST_TABLE);
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + TEST_TABLE);
        }
        Assert.assertEquals((long)0L, (long)PermissionStorage.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        Assert.assertEquals((long)0L, (long)PermissionStorage.getNamespacePermissions((Configuration)conf, (String)TEST_TABLE.getNamespaceAsString()).size());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestRSGroupsWithACL.cleanUp();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetRSGroupInfo() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("getRSGroupInfo");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testGetRSGroupInfoOfTable() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("getRSGroupInfoOfTable");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testMoveServers() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("moveServers");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testMoveTables() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("moveTables");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testAddRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("addRSGroup");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testRemoveRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("removeRSGroup");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testBalanceRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("balanceRSGroup");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testListRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("listRSGroup");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testGetRSGroupInfoOfServer() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("getRSGroupInfoOfServer");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testMoveServersAndTables() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("moveServersAndTables");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testRemoveServers() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("removeServers");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testRenameRSGroup() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("renameRSGroup");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    @Test
    public void testUpdateRSGroupConfig() throws Exception {
        SecureTestUtil.AccessTestAction action = () -> {
            this.checkPermission("updateRSGroupConfig");
            return null;
        };
        this.validateAdminPermissions(action);
    }

    private void validateAdminPermissions(SecureTestUtil.AccessTestAction action) throws Exception {
        TestRSGroupsWithACL.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestRSGroupsWithACL.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    static {
        TEST_FAMILY = Bytes.toBytes((String)"f1");
    }
}

