/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.TestEnableRSGroupsCompatibility;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnableRSGroupsTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestEnableRSGroupsCompatibility.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.coprocessor.enabled", true);
        TEST_UTIL.startMiniCluster(5);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info("to stop miniCluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    protected abstract void enableRSGroup(Configuration var1);

    @Test
    public void testEnableRSGroup() throws IOException, InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().stopMaster(0);
        TEST_UTIL.getMiniHBaseCluster().waitOnMaster(0);
        LOG.info("stopped master...");
        this.enableRSGroup(TEST_UTIL.getMiniHBaseCluster().getConfiguration());
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster(60000L);
        LOG.info("started master...");
        Assert.assertTrue((TEST_UTIL.getMiniHBaseCluster().getMaster() != null ? 1 : 0) != 0);
        RSGroupBasedLoadBalancer loadBalancer = TEST_UTIL.getMiniHBaseCluster().getMaster().getLoadBalancer();
        long start = EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() - start <= 60000L && !loadBalancer.isOnline()) {
            LOG.info("waiting for rsgroup load balancer onLine...");
            Thread.sleep(200L);
        }
        Assert.assertTrue((boolean)loadBalancer.isOnline());
    }
}

