/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceShipper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationShipperQuit
extends SyncReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationShipperQuit.class);

    @Test
    public void testShipperQuitWhenDA() throws Exception {
        UTIL1.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)UTIL1.getAdmin().getReplicationPeerConfig(PEER_ID)).setSerial(true).build());
        UTIL2.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)UTIL2.getAdmin().getReplicationPeerConfig(PEER_ID)).setSerial(true).build());
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        this.writeAndVerifyReplication(UTIL1, UTIL2, 0, 100);
        HRegionServer rs = UTIL1.getRSForFirstRegionInTable(TABLE_NAME);
        AbstractFSWAL wal = (AbstractFSWAL)rs.getWAL(RegionInfoBuilder.newBuilder((TableName)TABLE_NAME).build());
        String walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName((String)wal.getCurrentFileName().getName());
        ReplicationSourceShipper shipper = (ReplicationSourceShipper)((ReplicationSource)((Replication)rs.getReplicationSourceService()).getReplicationManager().getSource((String)TestSyncReplicationShipperQuit.PEER_ID)).workerThreads.get(walGroupId);
        Assert.assertFalse((boolean)shipper.isFinished());
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        this.writeAndVerifyReplication(UTIL1, UTIL2, 100, 200);
        ReplicationSource source = (ReplicationSource)((Replication)rs.getReplicationSourceService()).getReplicationManager().getSource(PEER_ID);
        UTIL1.waitFor(10000L, () -> !source.workerThreads.containsKey(walGroupId));
        Assert.assertTrue((boolean)shipper.isFinished());
    }
}

