/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestFSWALEntry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSWALEntry.class);

    @Test
    public void testCollectFamilies() {
        byte[] family0 = Bytes.toBytes((String)"family0");
        byte[] family1 = Bytes.toBytes((String)"family1");
        byte[] family2 = Bytes.toBytes((String)"family2");
        ArrayList<ExtendedCell> cells = new ArrayList<ExtendedCell>();
        Assert.assertEquals((long)0L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(family0).setFamily(family0).setQualifier(family0).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        Assert.assertEquals((long)1L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(family1).setFamily(family1).setQualifier(family1).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        Assert.assertEquals((long)2L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(family0).setFamily(family0).setQualifier(family0).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        cells.add(ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(family1).setFamily(family1).setQualifier(family1).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        Assert.assertEquals((long)2L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(family2).setFamily(family2).setQualifier(family2).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        Assert.assertEquals((long)3L, (long)FSWALEntry.collectFamilies(cells).size());
        cells.add(ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(WALEdit.METAFAMILY).setFamily(WALEdit.METAFAMILY).setQualifier(WALEdit.METAFAMILY).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        Assert.assertEquals((long)3L, (long)FSWALEntry.collectFamilies(cells).size());
    }
}

