/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogTestHelper;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufWALStreamReader;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class AbstractTestProtobufLog {
    protected static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    protected FileSystem fs;
    protected Path dir;
    protected WALFactory wals;
    @Rule
    public final TestName currentTest = new TestName();

    @Before
    public void setUp() throws Exception {
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.dir = new Path(TEST_UTIL.createRootDir(), this.currentTest.getMethodName());
        this.wals = new WALFactory(TEST_UTIL.getConfiguration(), this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        FileStatus[] entries;
        this.wals.close();
        for (FileStatus dir : entries = this.fs.listStatus(new Path("/"))) {
            this.fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALTrailer() throws IOException {
        Assert.assertEquals((long)0L, (long)WALProtos.WALTrailer.newBuilder().build().getSerializedSize());
        this.doRead(true);
        this.doRead(false);
    }

    private void doRead(boolean withTrailer) throws IOException {
        int columnCount = 5;
        int recordCount = 5;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        long timestamp = EnvironmentEdgeManager.currentTime();
        Path path = new Path(this.dir, "tempwal");
        this.fs.delete(path, true);
        this.fs.mkdirs(this.dir);
        try (WALProvider.Writer writer = this.createWriter(path);){
            ProtobufLogTestHelper.doWrite(writer, withTrailer, tableName, columnCount, recordCount, row, timestamp);
            try (ProtobufWALStreamReader reader = (ProtobufWALStreamReader)this.wals.createStreamReader(this.fs, path);){
                ProtobufLogTestHelper.doRead(reader, withTrailer, tableName, columnCount, recordCount, row, timestamp);
            }
        }
    }

    protected abstract WALProvider.Writer createWriter(Path var1) throws IOException;
}

