/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, SmallTests.class})
public class TestWALMonotonicallyIncreasingSeqId {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALMonotonicallyIncreasingSeqId.class);
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Path testDir = TEST_UTIL.getDataTestDir("TestWALMonotonicallyIncreasingSeqId");
    private WALFactory wals;
    private FileSystem fileSystem;
    private Configuration walConf;
    private HRegion region;
    @Parameterized.Parameter
    public String walProvider;
    @Rule
    public TestName name = new TestName();
    CountDownLatch latch = new CountDownLatch(1);

    @Parameterized.Parameters(name="{index}: wal={0}")
    public static List<Object[]> data() {
        return Arrays.asList({"asyncfs"}, {"filesystem"});
    }

    private TableDescriptor getTableDesc(TableName tableName, byte[] ... families) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        Arrays.stream(families).map(f -> ColumnFamilyDescriptorBuilder.newBuilder((byte[])f).setMaxVersions(Integer.MAX_VALUE).build()).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        return builder.build();
    }

    private HRegion initHRegion(TableDescriptor htd, byte[] startKey, byte[] stopKey, int replicaId) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.wal.provider", this.walProvider);
        conf.setBoolean("hbase.hregion.mvcc.preassign", false);
        Path tableDir = CommonFSUtils.getTableDir((Path)testDir, (TableName)htd.getTableName());
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).setStartKey(startKey).setEndKey(stopKey).setReplicaId(replicaId).setRegionId(0L).build();
        this.fileSystem = tableDir.getFileSystem(conf);
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)tableDir);
        this.walConf = walConf;
        this.wals = new WALFactory(walConf, "log_" + replicaId);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        HRegion region = HRegion.createHRegion((RegionInfo)info, (Path)TEST_UTIL.getDefaultRootDirPath(), (Configuration)conf, (TableDescriptor)htd, (WAL)this.wals.getWAL(info));
        return region;
    }

    @Before
    public void setUp() throws IOException {
        byte[][] families = new byte[][]{Bytes.toBytes((String)"cf")};
        TableDescriptor htd = this.getTableDesc(TableName.valueOf((String)this.name.getMethodName().replaceAll("[^0-9A-Za-z_]", "_")), families);
        this.region = this.initHRegion(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, 0);
    }

    @After
    public void tearDown() throws IOException {
        if (this.region != null) {
            this.region.close();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
    }

    private WALStreamReader createReader(Path logPath, Path oldWalsDir) throws IOException {
        try {
            return this.wals.createStreamReader(this.fileSystem, logPath);
        }
        catch (IOException e) {
            return this.wals.createStreamReader(this.fileSystem, new Path(oldWalsDir, logPath.getName()));
        }
    }

    @Test
    public void testWALMonotonicallyIncreasingSeqId() throws Exception {
        ArrayList<PutThread> putThreads = new ArrayList<PutThread>();
        for (int i = 0; i < 1; ++i) {
            putThreads.add(new PutThread(this.region));
        }
        IncThread incThread = new IncThread(this.region);
        for (int i = 0; i < 1; ++i) {
            ((Thread)putThreads.get(i)).start();
        }
        incThread.start();
        incThread.join();
        Path logPath = ((AbstractFSWAL)this.region.getWAL()).getCurrentFileName();
        this.region.getWAL().rollWriter();
        Thread.sleep(10L);
        Path hbaseDir = new Path(this.walConf.get("hbase.rootdir"));
        Path oldWalsDir = new Path(hbaseDir, "oldWALs");
        try (WALStreamReader reader = this.createReader(logPath, oldWalsDir);){
            WAL.Entry e;
            long currentMaxSeqid = 0L;
            while ((e = reader.next()) != null) {
                if (WALEdit.isMetaEditFamily((Cell)((Cell)e.getEdit().getCells().get(0)))) continue;
                long currentSeqid = e.getKey().getSequenceId();
                if (currentSeqid > currentMaxSeqid) {
                    currentMaxSeqid = currentSeqid;
                    continue;
                }
                Assert.fail((String)("Current max Seqid is " + currentMaxSeqid + ", but the next seqid in wal is smaller:" + currentSeqid));
            }
        }
    }

    public class IncThread
    extends Thread {
        HRegion region;

        public IncThread(HRegion region) {
            this.region = region;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    byte[] row = Bytes.toBytes((String)("incrementRow" + i));
                    Increment inc = new Increment(row);
                    inc.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((int)0), 1L);
                    this.region.increment(inc);
                    TestWALMonotonicallyIncreasingSeqId.this.latch.countDown();
                    Thread.sleep(10L);
                }
            }
            catch (Throwable t) {
                TestWALMonotonicallyIncreasingSeqId.this.LOG.warn("Error happend when Put: ", t);
            }
        }
    }

    public class PutThread
    extends Thread {
        HRegion region;

        public PutThread(HRegion region) {
            this.region = region;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    byte[] row = Bytes.toBytes((String)("putRow" + i));
                    Put put = new Put(row);
                    put.addColumn(Bytes.toBytes((String)"cf"), Bytes.toBytes((int)0), new byte[0]);
                    TestWALMonotonicallyIncreasingSeqId.this.latch.await();
                    this.region.batchMutate(new Mutation[]{put});
                    Thread.sleep(10L);
                }
            }
            catch (Throwable t) {
                TestWALMonotonicallyIncreasingSeqId.this.LOG.warn("Error happend when Increment: ", t);
            }
        }
    }
}

