/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSplitWithBlockingFiles {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitWithBlockingFiles.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitWithBlockingFiles.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static Admin ADMIN;
    private static byte[] CF;
    private static Table TABLE;

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 163840L);
        UTIL.getConfiguration().setInt("hbase.hstore.blockingStoreFiles", 1);
        UTIL.getConfiguration().set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        UTIL.getConfiguration().setBoolean("hbase.hregion.split.ignore.blocking.enabled", true);
        UTIL.startMiniCluster(1);
        ADMIN = UTIL.getAdmin();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setBlocksize(1000).build()).build();
        TABLE = UTIL.createTable(td, (byte[][])null);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        Closeables.close((Closeable)TABLE, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSplitIgnoreBlockingFiles() throws Exception {
        ADMIN.splitSwitch(false, true);
        byte[] value = new byte[1024];
        for (int m = 0; m < 10; ++m) {
            String rowPrefix = "row" + m;
            for (int i = 0; i < 10; ++i) {
                Put p = new Put(Bytes.toBytes((String)(rowPrefix + i)));
                p.addColumn(CF, Bytes.toBytes((String)"qualifier"), value);
                p.addColumn(CF, Bytes.toBytes((String)"qualifier2"), value);
                TABLE.put(p);
            }
            ADMIN.flush(TABLE_NAME);
        }
        Scan scan = new Scan();
        ResultScanner results = TABLE.getScanner(scan);
        int count = 0;
        while (results.next() != null) {
            ++count;
        }
        Assert.assertEquals((String)"There should be 100 rows!", (long)100L, (long)count);
        List regions = UTIL.getMiniHBaseCluster().getRegionServer(0).getRegions();
        regions.removeIf(r -> !r.getRegionInfo().getTable().equals((Object)TABLE_NAME));
        Assert.assertEquals((long)1L, (long)regions.size());
        Assert.assertNotNull((Object)((HRegion)regions.get(0)).getSplitPolicy().getSplitPoint());
        Assert.assertTrue((((HRegion)regions.get(0)).getCompactPriority() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)UTIL.getMiniHBaseCluster().getRegionServer(0).getCompactSplitThread().requestSplit((Region)regions.get(0)));
        ADMIN.splitSwitch(true, true);
        MasterProcedureEnv env = (MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        ProcedureExecutor executor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        SplitTableRegionProcedure splitProcedure = new SplitTableRegionProcedure(env, ((HRegion)regions.get(0)).getRegionInfo(), Bytes.toBytes((String)"row5"));
        executor.submitProcedure((Procedure)splitProcedure);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)executor, (long)splitProcedure.getProcId());
        regions = UTIL.getMiniHBaseCluster().getRegionServer(0).getRegions();
        regions.removeIf(r -> !r.getRegionInfo().getTable().equals((Object)TABLE_NAME));
        Assert.assertEquals((long)2L, (long)regions.size());
        scan = new Scan();
        results = TABLE.getScanner(scan);
        count = 0;
        while (results.next() != null) {
            ++count;
        }
        Assert.assertEquals((String)"There should be 100 rows!", (long)100L, (long)count);
        for (HRegion region : regions) {
            Assert.assertTrue((region.getCompactPriority() < 1 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)UTIL.getMiniHBaseCluster().getRegionServer(0).getCompactSplitThread().requestSplit((Region)region));
        }
    }

    static {
        CF = Bytes.toBytes((String)"cf");
    }
}

