/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSCVFWithMiniCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSCVFWithMiniCluster.class);
    private static final TableName HBASE_TABLE_NAME = TableName.valueOf((String)"TestSCVFWithMiniCluster");
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER_FOO = Bytes.toBytes((String)"foo");
    private static final byte[] QUALIFIER_BAR = Bytes.toBytes((String)"bar");
    private static Table htable;
    private static Filter scanFilter;
    private int expected = 1;

    @BeforeClass
    public static void setUp() throws Exception {
        HBaseTestingUtil util = new HBaseTestingUtil();
        util.startMiniCluster(1);
        Admin admin = util.getAdmin();
        TestSCVFWithMiniCluster.destroy(admin, HBASE_TABLE_NAME);
        TestSCVFWithMiniCluster.create(admin, HBASE_TABLE_NAME, FAMILY_A, FAMILY_B);
        admin.close();
        htable = util.getConnection().getTable(HBASE_TABLE_NAME);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(Bytes.toBytes((String)"1"));
        put.setDurability(Durability.SKIP_WAL);
        put.addColumn(FAMILY_A, QUALIFIER_FOO, Bytes.toBytes((String)"false"));
        put.addColumn(FAMILY_A, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        put.addColumn(FAMILY_B, QUALIFIER_FOO, Bytes.toBytes((String)"_flag_"));
        put.addColumn(FAMILY_B, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"2"));
        put.setDurability(Durability.SKIP_WAL);
        put.addColumn(FAMILY_A, QUALIFIER_FOO, Bytes.toBytes((String)"true"));
        put.addColumn(FAMILY_A, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        put.addColumn(FAMILY_B, QUALIFIER_FOO, Bytes.toBytes((String)"_flag_"));
        put.addColumn(FAMILY_B, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        puts.add(put);
        put = new Put(Bytes.toBytes((String)"3"));
        put.setDurability(Durability.SKIP_WAL);
        put.addColumn(FAMILY_A, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        put.addColumn(FAMILY_B, QUALIFIER_FOO, Bytes.toBytes((String)"_flag_"));
        put.addColumn(FAMILY_B, QUALIFIER_BAR, Bytes.toBytes((String)"_flag_"));
        puts.add(put);
        htable.put(puts);
        scanFilter = new SingleColumnValueFilter(FAMILY_A, QUALIFIER_FOO, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"false")));
        ((SingleColumnValueFilter)scanFilter).setFilterIfMissing(true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        htable.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(Scan scan) throws IOException {
        ResultScanner scanner = htable.getScanner(scan);
        Iterator it = scanner.iterator();
        int count = 0;
        try {
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        finally {
            scanner.close();
        }
        Assert.assertEquals((int)this.expected, (int)count);
    }

    @Test
    public void scanWithAllQualifiersOfFamiliyA() throws IOException {
        Scan scan = new Scan();
        scan.addFamily(FAMILY_A);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithAllQualifiersOfBothFamilies() throws IOException {
        Scan scan = new Scan();
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithSpecificQualifiers1() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_A, QUALIFIER_FOO);
        scan.addColumn(FAMILY_A, QUALIFIER_BAR);
        scan.addColumn(FAMILY_B, QUALIFIER_BAR);
        scan.addColumn(FAMILY_B, QUALIFIER_FOO);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithSpecificQualifiers2() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_A, QUALIFIER_FOO);
        scan.addColumn(FAMILY_B, QUALIFIER_BAR);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    @Test
    public void scanWithSpecificQualifiers3() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(FAMILY_A, QUALIFIER_FOO);
        scan.addColumn(FAMILY_A, QUALIFIER_BAR);
        scan.setFilter(scanFilter);
        this.verify(scan);
    }

    private static void create(Admin admin, TableName tableName, byte[] ... families) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            ColumnFamilyDescriptor familyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMaxVersions(1).setCompressionType(Compression.Algorithm.GZ).build();
            builder.setColumnFamily(familyDescriptor);
        }
        try {
            admin.createTable(builder.build());
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }

    private static void destroy(Admin admin, TableName tableName) throws IOException {
        try {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }
}

