/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestMaxResultsPerColumnFamily {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMaxResultsPerColumnFamily.class);
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2")};
    private static final byte[][] VALUES = new byte[][]{Bytes.toBytes((String)"testValueOne"), Bytes.toBytes((String)"testValueTwo")};
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSetMaxResultsPerColumnFamilySimple() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = UTIL.getAdmin();
        ColumnFamilyDescriptorBuilder cfBuilder0 = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILIES[0]);
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(cfBuilder0.build()).build();
        admin.createTable(tableDescriptor);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 30000; ++i) {
                byte[] ROW = Bytes.toBytes((String)("" + i));
                Put p = new Put(ROW);
                p.addColumn(FAMILIES[0], Bytes.toBytes((String)"1"), VALUES[1]);
                p.addColumn(FAMILIES[0], Bytes.toBytes((String)"2"), VALUES[0]);
                table.put(p);
            }
        }
        var6_6 = null;
        try (Table t = UTIL.getConnection().getTable(tableName);){
            int expected = 30000;
            Scan limits = new Scan().setReadType(Scan.ReadType.PREAD);
            limits.setMaxResultsPerColumnFamily(1);
            int count1 = TestMaxResultsPerColumnFamily.countScanRows(t, limits);
            Assert.assertEquals((long)expected, (long)count1);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    static int countScanRows(Table t, Scan scan) throws Exception {
        int count = 0;
        try (ResultScanner scanner = t.getScanner(scan);){
            for (Result r : scanner) {
                ++count;
            }
        }
        return count;
    }
}

