/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestCompactionFileNotFound {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionFileNotFound.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactionFileNotFound.class);
    private static final HBaseTestingUtil util = new HBaseTestingUtil();
    private static final TableName TEST_TABLE = TableName.valueOf((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] ROW_A = Bytes.toBytes((String)"aaa");
    private static final byte[] ROW_B = Bytes.toBytes((String)"bbb");
    private static final byte[] ROW_C = Bytes.toBytes((String)"ccc");
    private static final byte[] qualifierCol1 = Bytes.toBytes((String)"col1");
    private static final byte[] bytes1 = Bytes.toBytes((int)1);
    private static final byte[] bytes2 = Bytes.toBytes((int)2);
    private static final byte[] bytes3 = Bytes.toBytes((int)3);
    private Table table;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.setInt("hbase.hfile.compaction.discharger.interval", Integer.MAX_VALUE);
        util.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @After
    public void after() throws Exception {
        try {
            if (this.table != null) {
                this.table.close();
            }
        }
        finally {
            util.deleteTable(TEST_TABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitAfterRefresh() throws Exception {
        final Admin admin = util.getAdmin();
        this.table = util.createTable(TEST_TABLE, TEST_FAMILY);
        try {
            Put puta = new Put(ROW_A);
            puta.addColumn(TEST_FAMILY, qualifierCol1, bytes1);
            this.table.put(puta);
            admin.flush(TEST_TABLE);
            Put putb = new Put(ROW_B);
            putb.addColumn(TEST_FAMILY, qualifierCol1, bytes2);
            this.table.put(putb);
            admin.flush(TEST_TABLE);
            Put putc = new Put(ROW_C);
            putc.addColumn(TEST_FAMILY, qualifierCol1, bytes3);
            this.table.put(putc);
            admin.flush(TEST_TABLE);
            admin.compact(TEST_TABLE);
            while (admin.getCompactionState(TEST_TABLE) != CompactionState.NONE) {
                Thread.sleep(1000L);
            }
            this.table.put(putb);
            HRegion hr1 = util.getRSForFirstRegionInTable(TEST_TABLE).getRegionByEncodedName(((RegionInfo)admin.getRegions(TEST_TABLE).get(0)).getEncodedName());
            hr1.refreshStoreFiles(true);
            final int numRegionsBeforeSplit = admin.getRegions(TEST_TABLE).size();
            admin.splitRegionAsync(((RegionInfo)admin.getRegions(TEST_TABLE).get(0)).getEncodedNameAsBytes(), ROW_C).get();
            util.waitFor(20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    int numRegionsAfterSplit = 0;
                    List<JVMClusterUtil.RegionServerThread> rst = util.getMiniHBaseCluster().getLiveRegionServerThreads();
                    for (JVMClusterUtil.RegionServerThread t : rst) {
                        numRegionsAfterSplit += t.getRegionServer().getRegions(TEST_TABLE).size();
                    }
                    return numRegionsAfterSplit == numRegionsBeforeSplit + 1 && admin.isTableAvailable(TEST_TABLE);
                }
            });
            Assert.assertEquals((long)3L, (long)util.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactionAfterRefresh() throws Exception {
        block9: {
            Admin admin = util.getAdmin();
            this.table = util.createTable(TEST_TABLE, TEST_FAMILY);
            try {
                Put puta = new Put(ROW_A);
                puta.addColumn(TEST_FAMILY, qualifierCol1, bytes1);
                this.table.put(puta);
                admin.flush(TEST_TABLE);
                Put putb = new Put(ROW_B);
                putb.addColumn(TEST_FAMILY, qualifierCol1, bytes2);
                this.table.put(putb);
                admin.flush(TEST_TABLE);
                Put putc = new Put(ROW_C);
                putc.addColumn(TEST_FAMILY, qualifierCol1, bytes3);
                this.table.put(putc);
                admin.flush(TEST_TABLE);
                admin.compact(TEST_TABLE);
                while (admin.getCompactionState(TEST_TABLE) != CompactionState.NONE) {
                    Thread.sleep(1000L);
                }
                this.table.put(putb);
                HRegion hr1 = util.getRSForFirstRegionInTable(TEST_TABLE).getRegionByEncodedName(((RegionInfo)admin.getRegions(TEST_TABLE).get(0)).getEncodedName());
                hr1.refreshStoreFiles(true);
                for (HStore store : hr1.getStores()) {
                    store.closeAndArchiveCompactedFiles();
                }
                try {
                    hr1.compact(false);
                }
                catch (IOException e) {
                    LOG.error("Got an exception during compaction", (Throwable)e);
                    if (e instanceof FileNotFoundException) {
                        Assert.fail((String)"Got a FNFE during compaction");
                        break block9;
                    }
                    Assert.fail();
                }
            }
            finally {
                if (admin != null) {
                    admin.close();
                }
            }
        }
    }
}

