/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import java.lang.management.MemoryType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStorePerformanceEvaluation;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStore;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.util.Pair;

public class RegionProcedureStorePerformanceEvaluation
extends ProcedureStorePerformanceEvaluation<RegionProcedureStore> {
    private MasterRegion region;

    protected RegionProcedureStore createProcedureStore(Path storeDir) throws IOException {
        Pair pair = MemorySizeUtil.getGlobalMemStoreSize((Configuration)this.conf);
        long globalMemStoreSize = (Long)pair.getFirst();
        boolean offheap = pair.getSecond() == MemoryType.NON_HEAP;
        float poolSizePercentage = offheap ? 1.0f : this.conf.getFloat("hbase.hregion.memstore.chunkpool.maxsize", 1.0f);
        float initialCountPercentage = this.conf.getFloat("hbase.hregion.memstore.chunkpool.initialsize", 0.0f);
        int chunkSize = this.conf.getInt("hbase.hregion.memstore.mslab.chunksize", 0x200000);
        float indexChunkSizePercent = this.conf.getFloat("hbase.hregion.memstore.mslab.indexchunksize.percent", 0.1f);
        ChunkCreator.initialize((int)chunkSize, (boolean)offheap, (long)globalMemStoreSize, (float)poolSizePercentage, (float)initialCountPercentage, null, (float)indexChunkSizePercent);
        this.conf.setBoolean("hbase.master.store.region.wal.hsync", "hsync".equals(this.syncType));
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)storeDir);
        DummyServer server = new DummyServer(this.conf);
        this.region = MasterRegionFactory.create((Server)server);
        return new RegionProcedureStore((Server)server, this.region, (fs, apth) -> {});
    }

    protected void printRawFormatResult(long timeTakenNs) {
        System.out.println(String.format("RESULT [%s=%s, %s=%s, %s=%s, %s=%s, total_time_ms=%s]", NUM_PROCS_OPTION.getOpt(), this.numProcs, STATE_SIZE_OPTION.getOpt(), this.stateSize, SYNC_OPTION.getOpt(), this.syncType, NUM_THREADS_OPTION.getOpt(), this.numThreads, timeTakenNs));
    }

    protected void preWrite(long procId) throws IOException {
    }

    protected void postStop(RegionProcedureStore store) throws IOException {
        this.region.close(true);
    }

    public static void main(String[] args) throws IOException {
        RegionProcedureStorePerformanceEvaluation tool = new RegionProcedureStorePerformanceEvaluation();
        tool.setConf(HBaseConfiguration.create());
        tool.run(args);
    }

    private static final class DummyServer
    extends MockServer {
        private final Configuration conf;
        private final ServerName serverName = ServerName.valueOf((String)"localhost", (int)12345, (long)EnvironmentEdgeManager.currentTime());

        public DummyServer(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        @Override
        public ServerName getServerName() {
            return this.serverName;
        }
    }
}

