/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTableDescriptorModificationFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableDescriptorModificationFromClient.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = null;
    private static final byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
    private static final byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @Before
    public void setup() {
        TABLE_NAME = TableName.valueOf((String)this.name.getMethodName());
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyTable() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            TableDescriptor modifiedtableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).build();
            admin.modifyTable(modifiedtableDescriptor);
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testAddColumn() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            admin.addColumnFamily(TABLE_NAME, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSameColumnFamilyTwice() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            admin.addColumnFamily(TABLE_NAME, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            try {
                admin.addColumnFamily(TABLE_NAME, ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1));
                Assert.fail((String)"Delete a non-exist column family should fail");
            }
            catch (InvalidFamilyOperationException invalidFamilyOperationException) {
                // empty catch block
            }
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyColumnFamily() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        ColumnFamilyDescriptor cfDescriptor = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0);
        int blockSize = cfDescriptor.getBlocksize();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(cfDescriptor).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            int newBlockSize = 2 * blockSize;
            cfDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfDescriptor).setBlocksize(newBlockSize).build();
            admin.modifyColumnFamily(TABLE_NAME, cfDescriptor);
            TableDescriptor htd = admin.getDescriptor(TABLE_NAME);
            ColumnFamilyDescriptor hcfd = htd.getColumnFamily(FAMILY_0);
            Assert.assertTrue((hcfd.getBlocksize() == newBlockSize ? 1 : 0) != 0);
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyNonExistingColumnFamily() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        ColumnFamilyDescriptor cfDescriptor = ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1);
        int blockSize = cfDescriptor.getBlocksize();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            int newBlockSize = 2 * blockSize;
            cfDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfDescriptor).setBlocksize(newBlockSize).build();
            try {
                admin.modifyColumnFamily(TABLE_NAME, cfDescriptor);
                Assert.fail((String)"Modify a non-exist column family should fail");
            }
            catch (InvalidFamilyOperationException invalidFamilyOperationException) {
                // empty catch block
            }
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    @Test
    public void testDeleteColumn() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            admin.deleteColumnFamily(TABLE_NAME, FAMILY_1);
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteSameColumnFamilyTwice() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_1)).build();
        admin.createTable(tableDescriptor);
        admin.disableTable(TABLE_NAME);
        try {
            this.verifyTableDescriptor(TABLE_NAME, FAMILY_0, FAMILY_1);
            admin.deleteColumnFamily(TABLE_NAME, FAMILY_1);
            this.verifyTableDescriptor(TABLE_NAME, new byte[][]{FAMILY_0});
            try {
                admin.deleteColumnFamily(TABLE_NAME, FAMILY_1);
                Assert.fail((String)"Delete a non-exist column family should fail");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            admin.deleteTable(TABLE_NAME);
        }
    }

    private void verifyTableDescriptor(TableName tableName, byte[] ... families) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor htd = admin.getDescriptor(tableName);
        this.verifyTableDescriptor(htd, tableName, families);
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        TableDescriptor td = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)mfs.getFileSystem(), (Path)tableDir);
        this.verifyTableDescriptor(td, tableName, families);
    }

    private void verifyTableDescriptor(TableDescriptor htd, TableName tableName, byte[] ... families) {
        Set htdFamilies = htd.getColumnFamilyNames();
        Assert.assertEquals((Object)tableName, (Object)htd.getTableName());
        Assert.assertEquals((long)families.length, (long)htdFamilies.size());
        for (byte[] familyName : families) {
            Assert.assertTrue((String)("Expected family " + Bytes.toString((byte[])familyName)), (boolean)htdFamilies.contains(familyName));
        }
    }
}

