/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterNoCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterNoCluster.class);
    private static final HBaseTestingUtil TESTUTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TESTUTIL.getConfiguration();
        CommonFSUtils.setRootDir((Configuration)c, (Path)TESTUTIL.getDataTestDir());
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        TESTUTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TESTUTIL.shutdownMiniZKCluster();
    }

    @After
    public void tearDown() throws KeeperException, ZooKeeperConnectionException, IOException {
        ZKWatcher zkw = new ZKWatcher(TESTUTIL.getConfiguration(), "@Before", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        try {
            TESTUTIL.waitFor(10000L, () -> {
                try {
                    ZKUtil.deleteNodeRecursively((ZKWatcher)zkw, (String)zkw.getZNodePaths().baseZNode);
                    return true;
                }
                catch (KeeperException.NotEmptyException e) {
                    LOG.info("Failed delete, retrying", (Throwable)e);
                    return false;
                }
            });
        }
        catch (Exception e) {
            LOG.info("Failed zk clear", (Throwable)e);
        }
        zkw.close();
    }

    @Test
    public void testStopDuringStart() throws IOException, KeeperException, InterruptedException {
        HMaster master = new HMaster(TESTUTIL.getConfiguration());
        master.start();
        master.stopMaster();
        master.join();
    }

    @Test
    public void testMasterInitWithSameClientServerZKQuorum() throws Exception {
        Configuration conf = new Configuration(TESTUTIL.getConfiguration());
        conf.set("hbase.client.zookeeper.quorum", conf.get("hbase.zookeeper.quorum"));
        conf.setInt("hbase.client.zookeeper.property.clientPort", TESTUTIL.getZkCluster().getClientPort());
        HMaster master = new HMaster(conf);
        master.start();
        master.join();
    }

    @Test
    public void testMasterInitWithObserverModeClientZKQuorum() throws Exception {
        Configuration conf = new Configuration(TESTUTIL.getConfiguration());
        Assert.assertFalse((boolean)Boolean.getBoolean("hbase.client.zookeeper.observer.mode"));
        conf.set("hbase.client.zookeeper.quorum", "localhost");
        conf.setInt("hbase.client.zookeeper.property.clientPort", TESTUTIL.getZkCluster().getClientPort() + 1);
        conf.setBoolean("hbase.master.maintenance_mode", true);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        conf.setBoolean("hbase.client.zookeeper.observer.mode", true);
        HMaster master = new HMaster(conf);
        master.start();
        while (!master.isInitialized()) {
            Threads.sleep((long)200L);
        }
        Assert.assertNull((Object)master.getMetaLocationSyncer());
        Assert.assertNull((Object)master.masterAddressSyncer);
        master.stopMaster();
        master.join();
    }
}

