/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileInlineToRootChunkConversion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileInlineToRootChunkConversion.class);
    private final HBaseTestingUtil testUtil = new HBaseTestingUtil();
    private final Configuration conf = this.testUtil.getConfiguration();

    @Test
    public void testWriteHFile() throws Exception {
        Path hfPath = new Path(this.testUtil.getDataTestDir(), TestHFileInlineToRootChunkConversion.class.getSimpleName() + ".hfile");
        int maxChunkSize = 1024;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        CacheConfig cacheConf = new CacheConfig(this.conf);
        this.conf.setInt("hfile.index.block.max.size", maxChunkSize);
        HFileContext context = new HFileContextBuilder().withBlockSize(16).build();
        HFile.Writer hfw = new HFile.WriterFactory(this.conf, cacheConf).withFileContext(context).withPath(fs, hfPath).create();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append("key" + String.format("%05d", i));
            sb.append("_");
            for (int j = 0; j < 100; ++j) {
                sb.append(48 + j);
            }
            String keyStr = sb.toString();
            sb.setLength(0);
            byte[] k = Bytes.toBytes((String)keyStr);
            keys.add(k);
            byte[] v = Bytes.toBytes((String)("value" + i));
            hfw.append((Cell)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(k).setFamily(HConstants.EMPTY_BYTE_ARRAY).setQualifier(HConstants.EMPTY_BYTE_ARRAY).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(v).build());
        }
        hfw.close();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)hfPath, (CacheConfig)cacheConf, (boolean)true, (Configuration)this.conf);
        HFileScanner scanner = reader.getScanner(this.conf, true, true);
        for (int i = 0; i < keys.size(); ++i) {
            scanner.seekTo((Cell)ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow((byte[])keys.get(i)).setFamily(HConstants.EMPTY_BYTE_ARRAY).setQualifier(HConstants.EMPTY_BYTE_ARRAY).setTimestamp(Long.MAX_VALUE).setType(KeyValue.Type.Maximum.getCode()).setValue(HConstants.EMPTY_BYTE_ARRAY).build());
        }
        reader.close();
    }
}

