/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestInvocationRecordFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInvocationRecordFilter.class);
    private static final byte[] TABLE_NAME_BYTES = Bytes.toBytes((String)"invocationrecord");
    private static final byte[] FAMILY_NAME_BYTES = Bytes.toBytes((String)"mycf");
    private static final byte[] ROW_BYTES = Bytes.toBytes((String)"row");
    private static final String QUALIFIER_PREFIX = "qualifier";
    private static final String VALUE_PREFIX = "value";
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private HRegion region;

    @Before
    public void setUp() throws Exception {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])TABLE_NAME_BYTES)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_NAME_BYTES)).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        this.region = HBaseTestingUtil.createRegionAndWAL(info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), htd);
        Put put = new Put(ROW_BYTES);
        for (int i = 0; i < 10; i += 2) {
            put.addColumn(FAMILY_NAME_BYTES, Bytes.toBytes((String)(QUALIFIER_PREFIX + i)), (long)i, Bytes.toBytes((String)(VALUE_PREFIX + i)));
        }
        this.region.put(put);
        this.region.flush(true);
    }

    @Test
    public void testFilterInvocation() throws Exception {
        ArrayList<Integer> selectQualifiers = new ArrayList<Integer>();
        ArrayList<Integer> expectedQualifiers = new ArrayList<Integer>();
        selectQualifiers.add(-1);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[selectQualifiers.size()]), expectedQualifiers.toArray(new Integer[expectedQualifiers.size()]));
        selectQualifiers.clear();
        selectQualifiers.add(0);
        expectedQualifiers.add(0);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[selectQualifiers.size()]), expectedQualifiers.toArray(new Integer[expectedQualifiers.size()]));
        selectQualifiers.add(3);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[selectQualifiers.size()]), expectedQualifiers.toArray(new Integer[expectedQualifiers.size()]));
        selectQualifiers.add(4);
        expectedQualifiers.add(4);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[selectQualifiers.size()]), expectedQualifiers.toArray(new Integer[expectedQualifiers.size()]));
        selectQualifiers.add(5);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[selectQualifiers.size()]), expectedQualifiers.toArray(new Integer[expectedQualifiers.size()]));
        selectQualifiers.add(8);
        expectedQualifiers.add(8);
        this.verifyInvocationResults(selectQualifiers.toArray(new Integer[selectQualifiers.size()]), expectedQualifiers.toArray(new Integer[expectedQualifiers.size()]));
    }

    public void verifyInvocationResults(Integer[] selectQualifiers, Integer[] expectedQualifiers) throws Exception {
        Get get = new Get(ROW_BYTES);
        for (int i = 0; i < selectQualifiers.length; ++i) {
            get.addColumn(FAMILY_NAME_BYTES, Bytes.toBytes((String)(QUALIFIER_PREFIX + selectQualifiers[i])));
        }
        get.setFilter((Filter)new InvocationRecordFilter());
        ArrayList<KeyValue> expectedValues = new ArrayList<KeyValue>();
        for (int i = 0; i < expectedQualifiers.length; ++i) {
            expectedValues.add(new KeyValue(ROW_BYTES, FAMILY_NAME_BYTES, Bytes.toBytes((String)(QUALIFIER_PREFIX + expectedQualifiers[i])), (long)expectedQualifiers[i].intValue(), Bytes.toBytes((String)(VALUE_PREFIX + expectedQualifiers[i]))));
        }
        Scan scan = new Scan(get);
        ArrayList actualValues = new ArrayList();
        ArrayList temp = new ArrayList();
        RegionScannerImpl scanner = this.region.getScanner(scan);
        while (scanner.next(temp)) {
            actualValues.addAll(temp);
            temp.clear();
        }
        actualValues.addAll(temp);
        Assert.assertTrue((String)("Actual values " + actualValues + " differ from the expected values:" + expectedValues), (boolean)expectedValues.equals(actualValues));
    }

    @After
    public void tearDown() throws Exception {
        WAL wal = this.region.getWAL();
        this.region.close();
        wal.close();
    }

    private static class InvocationRecordFilter
    extends FilterBase {
        private List<Cell> visitedKeyValues = new ArrayList<Cell>();

        private InvocationRecordFilter() {
        }

        public void reset() {
            this.visitedKeyValues.clear();
        }

        public Filter.ReturnCode filterCell(Cell ignored) {
            this.visitedKeyValues.add(ignored);
            return Filter.ReturnCode.INCLUDE;
        }

        public void filterRowCells(List<Cell> kvs) {
            kvs.clear();
            kvs.addAll(this.visitedKeyValues);
        }

        public boolean hasFilterRow() {
            return true;
        }
    }
}

