/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableBatch {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableBatch.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static byte[] CQ1 = Bytes.toBytes((String)"cq1");
    private static int COUNT = 1000;
    private static AsyncConnection CONN;
    private static byte[][] SPLIT_KEYS;
    private static int MAX_KEY_VALUE_SIZE;
    @Parameterized.Parameter(value=0)
    public String tableType;
    @Parameterized.Parameter(value=1)
    public Function<TableName, AsyncTable<?>> tableGetter;

    private static AsyncTable<?> getRawTable(TableName tableName) {
        return CONN.getTable(tableName);
    }

    private static AsyncTable<?> getTable(TableName tableName) {
        return CONN.getTable(tableName, (ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters(name="{index}: type={0}")
    public static List<Object[]> params() {
        Function<TableName, AsyncTable> rawTableGetter = TestAsyncTableBatch::getRawTable;
        Function<TableName, AsyncTable> tableGetter = TestAsyncTableBatch::getTable;
        return Arrays.asList({"raw", rawTableGetter}, {"normal", tableGetter});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.keyvalue.maxsize", MAX_KEY_VALUE_SIZE);
        TEST_UTIL.startMiniCluster(3);
        SPLIT_KEYS = new byte[8][];
        for (int i = 111; i < 999; i += 111) {
            TestAsyncTableBatch.SPLIT_KEYS[i / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() throws IOException, InterruptedException {
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, SPLIT_KEYS);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    @After
    public void tearDownAfterTest() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.isTableEnabled(TABLE_NAME)) {
            admin.disableTable(TABLE_NAME);
        }
        admin.deleteTable(TABLE_NAME);
    }

    private byte[] getRow(int i) {
        return Bytes.toBytes((String)String.format("%03d", i));
    }

    @Test
    public void test() throws InterruptedException, ExecutionException, IOException, TimeoutException {
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(this.getRow(i)).addColumn(FAMILY, CQ, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
        List results = (List)table.getAll(IntStream.range(0, COUNT).mapToObj(i -> Arrays.asList(new Get(this.getRow(i)), new Get(Arrays.copyOf(this.getRow(i), 4)))).flatMap(l -> l.stream()).collect(Collectors.toList())).get();
        Assert.assertEquals((long)(2 * COUNT), (long)results.size());
        for (int i2 = 0; i2 < COUNT; ++i2) {
            Assert.assertEquals((long)i2, (long)Bytes.toInt((byte[])((Result)results.get(2 * i2)).getValue(FAMILY, CQ)));
            Assert.assertTrue((boolean)((Result)results.get(2 * i2 + 1)).isEmpty());
        }
        Admin admin = TEST_UTIL.getAdmin();
        admin.flush(TABLE_NAME);
        List splitFutures = TEST_UTIL.getHBaseCluster().getRegions(TABLE_NAME).stream().map(r -> {
            byte[] startKey = r.getRegionInfo().getStartKey();
            int number = startKey.length == 0 ? 55 : Integer.parseInt(Bytes.toString((byte[])startKey));
            byte[] splitPoint = Bytes.toBytes((String)String.format("%03d", number + 55));
            try {
                return admin.splitRegionAsync(r.getRegionInfo().getRegionName(), splitPoint);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
        for (Future future : splitFutures) {
            future.get(30L, TimeUnit.SECONDS);
        }
        table.deleteAll(IntStream.range(0, COUNT).mapToObj(i -> new Delete(this.getRow(i))).collect(Collectors.toList())).get();
        results = (List)table.getAll(IntStream.range(0, COUNT).mapToObj(i -> new Get(this.getRow(i))).collect(Collectors.toList())).get();
        Assert.assertEquals((long)COUNT, (long)results.size());
        results.forEach(r -> Assert.assertTrue((boolean)r.isEmpty()));
    }

    @Test
    public void testWithRegionServerFailover() throws Exception {
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(this.getRow(i)).addColumn(FAMILY, CQ, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
        TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).abort("Aborting for tests");
        Thread.sleep(100L);
        table.putAll(IntStream.range(COUNT, 2 * COUNT).mapToObj(i -> new Put(this.getRow(i)).addColumn(FAMILY, CQ, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
        List results = (List)table.getAll(IntStream.range(0, 2 * COUNT).mapToObj(i -> new Get(this.getRow(i))).collect(Collectors.toList())).get();
        Assert.assertEquals((long)(2 * COUNT), (long)results.size());
        results.forEach(r -> Assert.assertFalse((boolean)r.isEmpty()));
        table.deleteAll(IntStream.range(0, 2 * COUNT).mapToObj(i -> new Delete(this.getRow(i))).collect(Collectors.toList())).get();
        results = (List)table.getAll(IntStream.range(0, 2 * COUNT).mapToObj(i -> new Get(this.getRow(i))).collect(Collectors.toList())).get();
        Assert.assertEquals((long)(2 * COUNT), (long)results.size());
        results.forEach(r -> Assert.assertTrue((boolean)r.isEmpty()));
    }

    @Test
    public void testMixed() throws InterruptedException, ExecutionException, IOException {
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(IntStream.range(0, 7).mapToObj(i -> new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, CQ, Bytes.toBytes((long)i))).collect(Collectors.toList())).get();
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new Get(Bytes.toBytes((int)0)));
        actions.add(new Put(Bytes.toBytes((int)1)).addColumn(FAMILY, CQ, Bytes.toBytes((long)2L)));
        actions.add(new Delete(Bytes.toBytes((int)2)));
        actions.add(new Increment(Bytes.toBytes((int)3)).addColumn(FAMILY, CQ, 1L));
        actions.add(new Append(Bytes.toBytes((int)4)).addColumn(FAMILY, CQ, Bytes.toBytes((int)4)));
        RowMutations rm = new RowMutations(Bytes.toBytes((int)5));
        rm.add((Mutation)new Put(Bytes.toBytes((int)5)).addColumn(FAMILY, CQ, Bytes.toBytes((long)100L)));
        rm.add((Mutation)new Put(Bytes.toBytes((int)5)).addColumn(FAMILY, CQ1, Bytes.toBytes((long)200L)));
        actions.add(rm);
        actions.add(new Get(Bytes.toBytes((int)6)));
        List results = (List)table.batchAll(actions).get();
        Assert.assertEquals((long)7L, (long)results.size());
        Result getResult = (Result)results.get(0);
        Assert.assertEquals((long)0L, (long)Bytes.toLong((byte[])getResult.getValue(FAMILY, CQ)));
        Assert.assertEquals((long)2L, (long)Bytes.toLong((byte[])((Result)table.get(new Get(Bytes.toBytes((int)1))).get()).getValue(FAMILY, CQ)));
        Assert.assertTrue((boolean)((Result)table.get(new Get(Bytes.toBytes((int)2))).get()).isEmpty());
        Result incrementResult = (Result)results.get(3);
        Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])incrementResult.getValue(FAMILY, CQ)));
        Result appendResult = (Result)results.get(4);
        byte[] appendValue = appendResult.getValue(FAMILY, CQ);
        Assert.assertEquals((long)12L, (long)appendValue.length);
        Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])appendValue));
        Assert.assertEquals((long)4L, (long)Bytes.toInt((byte[])appendValue, (int)8));
        Assert.assertEquals((long)100L, (long)Bytes.toLong((byte[])((Result)table.get(new Get(Bytes.toBytes((int)5))).get()).getValue(FAMILY, CQ)));
        Assert.assertEquals((long)200L, (long)Bytes.toLong((byte[])((Result)table.get(new Get(Bytes.toBytes((int)5))).get()).getValue(FAMILY, CQ1)));
        getResult = (Result)results.get(6);
        Assert.assertEquals((long)6L, (long)Bytes.toLong((byte[])getResult.getValue(FAMILY, CQ)));
    }

    @Test
    public void testPartialSuccess() throws IOException, InterruptedException, ExecutionException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableDescriptor)admin.getDescriptor(TABLE_NAME)).setCoprocessor(ErrorInjectObserver.class.getName()).build();
        admin.modifyTable(htd);
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        table.putAll(Arrays.asList(SPLIT_KEYS).stream().map(k -> new Put(k).addColumn(FAMILY, CQ, k)).collect(Collectors.toList())).get();
        List futures = table.get(Arrays.asList(SPLIT_KEYS).stream().map(k -> new Get(k)).collect(Collectors.toList()));
        for (int i = 0; i < SPLIT_KEYS.length - 1; ++i) {
            Assert.assertArrayEquals((byte[])SPLIT_KEYS[i], (byte[])((Result)((CompletableFuture)futures.get(i)).get()).getValue(FAMILY, CQ));
        }
        try {
            ((CompletableFuture)futures.get(SPLIT_KEYS.length - 1)).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
        }
    }

    @Test
    public void testPartialSuccessOnSameRegion() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        List futures = table.batch(Arrays.asList(new Put(Bytes.toBytes((String)"put")).addColumn(Bytes.toBytes((String)"not-exists"), CQ, Bytes.toBytes((String)"bad")), new Increment(Bytes.toBytes((String)"inc")).addColumn(FAMILY, CQ, 1L), new Put(Bytes.toBytes((String)"put")).addColumn(FAMILY, CQ, Bytes.toBytes((String)"good"))));
        try {
            ((CompletableFuture)futures.get(0)).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
            MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(NoSuchColumnFamilyException.class));
        }
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])((Result)((CompletableFuture)futures.get(1)).get()).getValue(FAMILY, CQ)));
        Assert.assertTrue((boolean)((Result)((CompletableFuture)futures.get(2)).get()).isEmpty());
        Assert.assertEquals((Object)"good", (Object)Bytes.toString((byte[])((Result)table.get(new Get(Bytes.toBytes((String)"put"))).get()).getValue(FAMILY, CQ)));
    }

    @Test
    public void testInvalidPut() {
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        try {
            table.batch(Arrays.asList(new Delete(Bytes.toBytes((int)0)), new Put(Bytes.toBytes((int)0))));
            Assert.fail((String)"Should fail since the put does not contain any cells");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No columns to insert"));
        }
        try {
            table.batch(Arrays.asList(new Put(Bytes.toBytes((int)0)).addColumn(FAMILY, CQ, new byte[MAX_KEY_VALUE_SIZE]), new Delete(Bytes.toBytes((int)0))));
            Assert.fail((String)"Should fail since the put exceeds the max key value size");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"KeyValue size too large"));
        }
    }

    @Test
    public void testInvalidPutInRowMutations() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        try {
            table.batch(Arrays.asList(new Delete(row), new RowMutations(row).add((Mutation)new Put(row))));
            Assert.fail((String)"Should fail since the put does not contain any cells");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No columns to insert"));
        }
        try {
            table.batch(Arrays.asList(new RowMutations(row).add((Mutation)new Put(row).addColumn(FAMILY, CQ, new byte[MAX_KEY_VALUE_SIZE])), new Delete(row)));
            Assert.fail((String)"Should fail since the put exceeds the max key value size");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"KeyValue size too large"));
        }
    }

    @Test
    public void testInvalidPutInRowMutationsInCheckAndMutate() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        try {
            table.batch(Arrays.asList(new Delete(row), CheckAndMutate.newBuilder((byte[])row).ifNotExists(FAMILY, CQ).build(new RowMutations(row).add((Mutation)new Put(row)))));
            Assert.fail((String)"Should fail since the put does not contain any cells");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"No columns to insert"));
        }
        try {
            table.batch(Arrays.asList(CheckAndMutate.newBuilder((byte[])row).ifNotExists(FAMILY, CQ).build(new RowMutations(row).add((Mutation)new Put(row).addColumn(FAMILY, CQ, new byte[MAX_KEY_VALUE_SIZE]))), new Delete(row)));
            Assert.fail((String)"Should fail since the put exceeds the max key value size");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"KeyValue size too large"));
        }
    }

    @Test
    public void testWithCheckAndMutate() throws Exception {
        AsyncTable<?> table = this.tableGetter.apply(TABLE_NAME);
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] row3 = Bytes.toBytes((String)"row3");
        byte[] row4 = Bytes.toBytes((String)"row4");
        byte[] row5 = Bytes.toBytes((String)"row5");
        byte[] row6 = Bytes.toBytes((String)"row6");
        byte[] row7 = Bytes.toBytes((String)"row7");
        table.putAll(Arrays.asList(new Put(row1).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")), new Put(row5).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")), new Put(row6).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((long)10L)), new Put(row7).addColumn(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((String)"g")))).get();
        CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])row1).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new RowMutations(row1).add((Mutation)new Put(row1).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"g"))).add((Mutation)new Delete(row1).addColumns(FAMILY, Bytes.toBytes((String)"A"))).add((Mutation)new Increment(row1).addColumn(FAMILY, Bytes.toBytes((String)"C"), 3L)).add((Mutation)new Append(row1).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
        Get get = new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"));
        RowMutations mutations = new RowMutations(row3).add((Mutation)new Delete(row3).addColumns(FAMILY, Bytes.toBytes((String)"C"))).add((Mutation)new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))).add((Mutation)new Increment(row3).addColumn(FAMILY, Bytes.toBytes((String)"A"), 5L)).add((Mutation)new Append(row3).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
        CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row4).ifEquals(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"a")).build(new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"h")));
        Put put = new Put(row5).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"f"));
        CheckAndMutate checkAndMutate3 = CheckAndMutate.newBuilder((byte[])row6).ifEquals(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((long)10L)).build(new Increment(row6).addColumn(FAMILY, Bytes.toBytes((String)"F"), 1L));
        CheckAndMutate checkAndMutate4 = CheckAndMutate.newBuilder((byte[])row7).ifEquals(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((String)"g")).build(new Append(row7).addColumn(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((String)"g")));
        List<Row> actions = Arrays.asList(checkAndMutate1, get, mutations, checkAndMutate2, put, checkAndMutate3, checkAndMutate4);
        List results = (List)table.batchAll(actions).get();
        CheckAndMutateResult checkAndMutateResult = (CheckAndMutateResult)results.get(0);
        Assert.assertTrue((boolean)checkAndMutateResult.isSuccess());
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"C"))));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"D"))));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])((Result)results.get(1)).getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Result result = (Result)results.get(2);
        Assert.assertTrue((boolean)result.getExists());
        Assert.assertEquals((long)5L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        checkAndMutateResult = (CheckAndMutateResult)results.get(3);
        Assert.assertFalse((boolean)checkAndMutateResult.isSuccess());
        Assert.assertNull((Object)checkAndMutateResult.getResult());
        Assert.assertTrue((boolean)((Result)results.get(4)).isEmpty());
        checkAndMutateResult = (CheckAndMutateResult)results.get(5);
        Assert.assertTrue((boolean)checkAndMutateResult.isSuccess());
        Assert.assertEquals((long)11L, (long)Bytes.toLong((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"F"))));
        checkAndMutateResult = (CheckAndMutateResult)results.get(6);
        Assert.assertTrue((boolean)checkAndMutateResult.isSuccess());
        Assert.assertEquals((Object)"gg", (Object)Bytes.toString((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"G"))));
        result = (Result)table.get(new Get(row1)).get();
        Assert.assertEquals((Object)"g", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"A")));
        Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        result = (Result)table.get(new Get(row3)).get();
        Assert.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"C")));
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        Assert.assertNull((Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
        Assert.assertEquals((long)5L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
        Assert.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
        result = (Result)table.get(new Get(row4)).get();
        Assert.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
        result = (Result)table.get(new Get(row5)).get();
        Assert.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"E"))));
        result = (Result)table.get(new Get(row6)).get();
        Assert.assertEquals((long)11L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
        result = (Result)table.get(new Get(row7)).get();
        Assert.assertEquals((Object)"gg", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"G"))));
    }

    static {
        MAX_KEY_VALUE_SIZE = 65536;
    }

    public static final class ErrorInjectObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().getEndKey().length == 0) {
                throw new DoNotRetryRegionException("Inject Error");
            }
        }
    }
}

