/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.TestAdminBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAdmin
extends TestAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdmin.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAdmin.class);

    @Test
    public void testListTableDescriptors() throws IOException {
        TableDescriptor metaTableDescriptor = TEST_UTIL.getAdmin().getDescriptor(TableName.META_TABLE_NAME);
        List tableDescriptors = TEST_UTIL.getAdmin().listTableDescriptors(true);
        Assert.assertTrue((boolean)tableDescriptors.contains(metaTableDescriptor));
        tableDescriptors = TEST_UTIL.getAdmin().listTableDescriptors(false);
        Assert.assertFalse((boolean)tableDescriptors.contains(metaTableDescriptor));
    }

    @Test
    public void testCreateTable() throws IOException {
        List tables = ADMIN.listTableDescriptors();
        int numTables = tables.size();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = ADMIN.listTableDescriptors();
        Assert.assertEquals((long)(numTables + 1), (long)tables.size());
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(tableName, new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(tableName));
    }

    @Test
    public void testTruncateTable() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)this.name.getMethodName()), false);
    }

    @Test
    public void testTruncateTablePreservingSplits() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)this.name.getMethodName()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        try (Table table = TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY, (byte[][])splitKeys);){
            TEST_UTIL.loadNumericRows(table, HConstants.CATALOG_FAMILY, 0, 10);
            Assert.assertEquals((long)10L, (long)HBaseTestingUtil.countRows(table));
        }
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        ADMIN.disableTable(tableName);
        ADMIN.truncateTable(tableName, preserveSplits);
        table = TEST_UTIL.getConnection().getTable(tableName);
        try {
            Assert.assertEquals((long)0L, (long)HBaseTestingUtil.countRows(table));
        }
        finally {
            table.close();
        }
        if (preserveSplits) {
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        }
    }

    @Test
    public void testCreateTableNumberOfRegions() throws IOException, InterruptedException {
        List regions;
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY);
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table).setColumnFamily(cfd).build());
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regions.size());
        }
        TableName table2 = TableName.valueOf((String)(table.getNameAsString() + "_2"));
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table2).setColumnFamily(cfd).build(), (byte[][])new byte[][]{{42}});
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table2);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regions.size());
        }
        TableName table3 = TableName.valueOf((String)(table.getNameAsString() + "_3"));
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table3).setColumnFamily(cfd).build(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"z"), 3);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table3);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regions.size());
        }
        TableName table4 = TableName.valueOf((String)(table.getNameAsString() + "_4"));
        try {
            ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table4).setColumnFamily(cfd).build(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"z"), 2);
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TableName table5 = TableName.valueOf((String)(table.getNameAsString() + "_5"));
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table5).setColumnFamily(cfd).build(), new byte[]{1}, new byte[]{127}, 16);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table5);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regions.size());
        }
    }

    @Test
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        RegionInfo hri;
        Iterator hris;
        List regions;
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY);
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table).setColumnFamily(cfd).build(), (byte[][])splitKeys);
        boolean tableAvailable = ADMIN.isTableAvailable(table);
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            System.err.println("Found " + regions.size() + " regions");
            hris = regions.iterator();
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
            Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
            this.verifyRoundRobinDistribution(l, expectedRegions);
        }
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        TableName table2 = TableName.valueOf((String)(table.getNameAsString() + "_2"));
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table2).setColumnFamily(cfd).build(), startKey, endKey, expectedRegions);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table2);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            System.err.println("Found " + regions.size() + " regions");
            hris = regions.iterator();
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
            hri = ((HRegionLocation)hris.next()).getRegion();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
            Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
            this.verifyRoundRobinDistribution(l, expectedRegions);
        }
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        TableName table3 = TableName.valueOf((String)(table.getNameAsString() + "_3"));
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table3).setColumnFamily(cfd).build(), startKey, endKey, expectedRegions);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(table3);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            System.err.println("Found " + regions.size() + " regions");
            this.verifyRoundRobinDistribution(l, expectedRegions);
        }
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        TableName table4 = TableName.valueOf((String)(table.getNameAsString() + "_4"));
        try {
            ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table4).setColumnFamily(cfd).build(), (byte[][])splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTableWithOnlyEmptyStartRow() throws IOException {
        byte[] tableName = Bytes.toBytes((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"col")).build();
        try {
            ADMIN.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws IOException {
        byte[] tableName = Bytes.toBytes((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"region1"), HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"region2")};
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"col")).build();
        try {
            ADMIN.createTable(desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            LOG.info("Expected ", (Throwable)e);
        }
    }

    private void verifyRoundRobinDistribution(RegionLocator regionLocator, int expectedRegions) throws IOException {
        int numRS = TEST_UTIL.getMiniHBaseCluster().getNumLiveRegionServers();
        List regions = regionLocator.getAllRegionLocations();
        HashMap<ServerName, ArrayList<RegionInfo>> server2Regions = new HashMap<ServerName, ArrayList<RegionInfo>>();
        for (HRegionLocation loc : regions) {
            ServerName server = loc.getServerName();
            ArrayList<RegionInfo> regs = (ArrayList<RegionInfo>)server2Regions.get(server);
            if (regs == null) {
                regs = new ArrayList<RegionInfo>();
                server2Regions.put(server, regs);
            }
            regs.add(loc.getRegion());
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        for (List regionList : server2Regions.values()) {
            Assert.assertTrue((String)("numRS=" + numRS + ", min=" + min + ", max=" + max + ", size=" + regionList.size()), (regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCloneTableSchema() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        this.testCloneTableSchema(tableName, newTableName, false);
    }

    @Test
    public void testCloneTableSchemaPreservingSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        this.testCloneTableSchema(tableName, newTableName, true);
    }

    private void testCloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) throws Exception {
        byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
        byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        int NUM_FAMILYS = 2;
        int NUM_REGIONS = 3;
        int BLOCK_SIZE = 1024;
        int TTL = 86400;
        boolean BLOCK_CACHE = false;
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_1).setBlocksize(BLOCK_SIZE).setBlockCacheEnabled(BLOCK_CACHE).setTimeToLive(TTL).build()).build();
        ADMIN.createTable(tableDesc, (byte[][])splitKeys);
        Assert.assertEquals((long)NUM_REGIONS, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)ADMIN.isTableAvailable(tableName));
        ADMIN.cloneTableSchema(tableName, newTableName, preserveSplits);
        TableDescriptor newTableDesc = ADMIN.getDescriptor(newTableName);
        Assert.assertEquals((long)NUM_FAMILYS, (long)newTableDesc.getColumnFamilyCount());
        Assert.assertEquals((long)BLOCK_SIZE, (long)newTableDesc.getColumnFamily(FAMILY_1).getBlocksize());
        Assert.assertEquals((Object)BLOCK_CACHE, (Object)newTableDesc.getColumnFamily(FAMILY_1).isBlockCacheEnabled());
        Assert.assertEquals((long)TTL, (long)newTableDesc.getColumnFamily(FAMILY_1).getTimeToLive());
        tableDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDesc).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.getStoreFileTrackerName((Configuration)TEST_UTIL.getConfiguration())).build();
        TEST_UTIL.verifyTableDescriptorIgnoreTableName(tableDesc, newTableDesc);
        if (preserveSplits) {
            Assert.assertEquals((long)NUM_REGIONS, (long)TEST_UTIL.getHBaseCluster().getRegions(newTableName).size());
            Assert.assertTrue((String)"New table should be created with splitKyes + 1 rows in META", (boolean)ADMIN.isTableAvailable(newTableName));
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(newTableName).size());
        }
    }

    @Test
    public void testCloneTableSchemaWithNonExistentSourceTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        try {
            ADMIN.cloneTableSchema(tableName, newTableName, false);
            Assert.fail((String)"Should have failed to create a new table by cloning non-existent source table.");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCloneTableSchemaWithExistentDestinationTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
        TEST_UTIL.createTable(tableName, FAMILY_0);
        TEST_UTIL.createTable(newTableName, FAMILY_0);
        try {
            ADMIN.cloneTableSchema(tableName, newTableName, false);
            Assert.fail((String)"Should have failed to create a existent table.");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testModifyTableOnTableWithRegionReplicas() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf"))).setRegionReplication(5).build();
        ADMIN.createTable(desc);
        int maxFileSize = 10000000;
        TableDescriptor newDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).setMaxFileSize((long)maxFileSize).build();
        ADMIN.modifyTable(newDesc);
        TableDescriptor newTableDesc = ADMIN.getDescriptor(tableName);
        Assert.assertEquals((long)maxFileSize, (long)newTableDesc.getMaxFileSize());
    }

    @Test
    public void testOnlineChangeTableSchema() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List tables = ADMIN.listTableDescriptors();
        int numTables = tables.size();
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = ADMIN.listTableDescriptors();
        Assert.assertEquals((long)(numTables + 1), (long)tables.size());
        TableDescriptor htd = ADMIN.getDescriptor(tableName);
        TableDescriptor copy = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).build();
        Assert.assertEquals((Object)htd, (Object)copy);
        String key = "anyoldkey";
        Assert.assertNull((Object)htd.getValue(key));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy = TableDescriptorBuilder.newBuilder((TableDescriptor)copy).setMemStoreFlushSize(newFlushSize).setValue(key, key).build();
        ADMIN.modifyTable(copy);
        TableDescriptor modifiedHtd = ADMIN.getDescriptor(tableName);
        Assert.assertNotEquals((Object)htd, (Object)modifiedHtd);
        Assert.assertEquals((Object)copy, (Object)modifiedHtd);
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)key, (Object)modifiedHtd.getValue(key));
        int countOfFamilies = modifiedHtd.getColumnFamilyCount();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        ColumnFamilyDescriptor hcd = modifiedHtd.getColumnFamilies()[0];
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)hcd).setMaxVersions(newMaxVersions).build();
        byte[] hcdName = hcd.getName();
        ADMIN.modifyColumnFamily(tableName, hcd);
        modifiedHtd = ADMIN.getDescriptor(tableName);
        ColumnFamilyDescriptor modifiedHcd = modifiedHtd.getColumnFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        Assert.assertFalse((boolean)ADMIN.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        ColumnFamilyDescriptor xtracol = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)xtracolName)).setValue(xtracolName, xtracolName).build();
        ADMIN.addColumnFamily(tableName, xtracol);
        modifiedHtd = ADMIN.getDescriptor(tableName);
        hcd = modifiedHtd.getColumnFamily(xtracol.getName());
        Assert.assertNotNull((Object)hcd);
        Assert.assertEquals((Object)xtracolName, (Object)Bytes.toString((byte[])hcd.getValue(Bytes.toBytes((String)xtracolName))));
        ADMIN.deleteColumnFamily(tableName, xtracol.getName());
        modifiedHtd = ADMIN.getDescriptor(tableName);
        hcd = modifiedHtd.getColumnFamily(xtracol.getName());
        Assert.assertNull((Object)hcd);
        ADMIN.disableTable(tableName);
        ADMIN.deleteTable(tableName);
        ADMIN.listTableDescriptors();
        Assert.assertFalse((boolean)ADMIN.tableExists(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnknownServers() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY);
        ADMIN.createTable(TableDescriptorBuilder.newBuilder((TableName)table).setColumnFamily(cfd).build());
        List regions = ADMIN.getRegions(table);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        RegionStateNode rsNode = am.getRegionStates().getRegionStateNode((RegionInfo)regions.get(0));
        ServerName regionLocation = rsNode.getRegionLocation();
        rsNode.setRegionLocation(ServerName.valueOf((String)"dummyserver", (int)1234, (long)System.currentTimeMillis()));
        try {
            Assert.assertTrue((boolean)((ServerName)ADMIN.listUnknownServers().get(0)).getHostname().equals("dummyserver"));
        }
        finally {
            rsNode.setRegionLocation(regionLocation);
        }
        Assert.assertTrue((boolean)ADMIN.listUnknownServers().isEmpty());
    }
}

