/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestClientOperationTimeout {
    private static final Logger LOG = LoggerFactory.getLogger(TestClientOperationTimeout.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientOperationTimeout.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static int DELAY_GET;
    private static int DELAY_SCAN;
    private static int DELAY_MUTATE;
    private static int DELAY_BATCH_MUTATE;
    private static final TableName TABLE_NAME;
    private static final byte[] FAMILY;
    private static final byte[] ROW;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static Connection CONN;
    private static Table TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        StartTestingClusterOption option = StartTestingClusterOption.builder().rsClass(DelayedRegionServer.class).build();
        UTIL.startMiniCluster(option);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build());
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setLong("hbase.client.operation.timeout", 500L);
        conf.setLong("hbase.client.meta.operation.timeout", 500L);
        conf.setLong("hbase.client.scanner.timeout.period", 500L);
        conf.setLong("hbase.client.retries.number", 1L);
        CONN = ConnectionFactory.createConnection((Configuration)conf);
        TABLE = CONN.getTable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)TABLE, (boolean)true);
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() throws Exception {
        DELAY_GET = 0;
        DELAY_SCAN = 0;
        DELAY_MUTATE = 0;
        DELAY_BATCH_MUTATE = 0;
    }

    @Test
    public void testGetTimeout() {
        DELAY_GET = 600;
        try {
            TABLE.get(new Get(ROW));
            Assert.fail((String)"should not reach here");
        }
        catch (Exception e) {
            LOG.info("Got exception for get", (Throwable)e);
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CallTimeoutException.class));
        }
    }

    @Test
    public void testPutTimeout() {
        DELAY_MUTATE = 600;
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        try {
            TABLE.put(put);
            Assert.fail((String)"should not reach here");
        }
        catch (Exception e) {
            LOG.info("Got exception for put", (Throwable)e);
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CallTimeoutException.class));
        }
    }

    @Test
    public void testMultiPutsTimeout() {
        DELAY_BATCH_MUTATE = 600;
        Put put1 = new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE);
        Put put2 = new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE);
        List<Put> puts = Arrays.asList(put1, put2);
        try {
            TABLE.batch(puts, new Object[2]);
            Assert.fail((String)"should not reach here");
        }
        catch (Exception e) {
            LOG.info("Got exception for batch", (Throwable)e);
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
            MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(CallTimeoutException.class));
        }
    }

    @Test
    public void testScanTimeout() throws IOException, InterruptedException {
        try (RegionLocator locator = TABLE.getRegionLocator();){
            locator.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY);
        }
        Thread.sleep(100L);
        DELAY_SCAN = 600;
        try {
            var2_3 = null;
            try (ResultScanner scanner = TABLE.getScanner(new Scan());){
                scanner.next();
                Assert.fail((String)"should not reach here");
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.info("Got exception for scan", (Throwable)e);
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RetriesExhaustedException.class));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CallTimeoutException.class));
        }
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"Timeout");
        FAMILY = Bytes.toBytes((String)"family");
        ROW = Bytes.toBytes((String)"row");
        QUALIFIER = Bytes.toBytes((String)"qualifier");
        VALUE = Bytes.toBytes((String)"value");
    }

    private static final class DelayedRSRpcServices
    extends RSRpcServices {
        DelayedRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_GET);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during get operation", (Throwable)e);
            }
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_MUTATE);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during mutate operation", (Throwable)e);
            }
            return super.mutate(rpcc, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_SCAN);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during scan operation", (Throwable)e);
            }
            return super.scan(controller, request);
        }

        public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_BATCH_MUTATE);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during multi operation", (Throwable)e);
            }
            return super.multi(rpcc, request);
        }
    }

    public static final class DelayedRegionServer
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public DelayedRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new DelayedRSRpcServices(this);
        }
    }
}

