/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientClusterStatus {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientClusterStatus.class);
    private static HBaseTestingUtil UTIL;
    private static Admin ADMIN;
    private static final int SLAVES = 5;
    private static final int MASTERS = 3;
    private static SingleProcessHBaseCluster CLUSTER;
    private static HRegionServer DEAD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.master.classes", MyObserver.class.getName());
        UTIL = new HBaseTestingUtil(conf);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(3).numRegionServers(5).numDataNodes(5).build();
        UTIL.startMiniCluster(option);
        CLUSTER = UTIL.getHBaseCluster();
        CLUSTER.waitForActiveAndReadyMaster();
        ADMIN = UTIL.getAdmin();
        List<JVMClusterUtil.RegionServerThread> rsts = CLUSTER.getLiveRegionServerThreads();
        JVMClusterUtil.RegionServerThread rst = rsts.get(rsts.size() - 1);
        DEAD = rst.getRegionServer();
        DEAD.stop("Test dead servers status");
        while (rst.isAlive()) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void testNone() throws Exception {
        ClusterMetrics status0 = ADMIN.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
        ClusterMetrics status1 = ADMIN.getClusterMetrics(EnumSet.noneOf(ClusterMetrics.Option.class));
        Assert.assertEquals((long)status0.getLiveServerMetrics().size(), (long)status1.getLiveServerMetrics().size());
    }

    @Test
    public void testLiveAndDeadServersStatus() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionserverThreads = CLUSTER.getLiveRegionServerThreads();
        int numRs = 0;
        int len = regionserverThreads.size();
        for (int i = 0; i < len; ++i) {
            if (!regionserverThreads.get(i).isAlive()) continue;
            ++numRs;
        }
        Waiter.waitFor((Configuration)CLUSTER.getConfiguration(), (long)10000L, (long)100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ClusterMetrics status = ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
                Assert.assertNotNull((Object)status);
                return status.getRegionCount() > 0;
            }
        });
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, ClusterMetrics.Option.DEAD_SERVERS, ClusterMetrics.Option.SERVERS_NAME);
        ClusterMetrics status = ADMIN.getClusterMetrics(options);
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull(status.getLiveServerMetrics().keySet());
        Assert.assertEquals((long)4L, (long)numRs);
        Assert.assertEquals((long)status.getLiveServerMetrics().keySet().size(), (long)numRs);
        Assert.assertTrue((status.getRegionCount() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getDeadServerNames());
        Assert.assertEquals((long)1L, (long)status.getDeadServerNames().size());
        ServerName deadServerName = (ServerName)status.getDeadServerNames().iterator().next();
        Assert.assertEquals((Object)DEAD.getServerName(), (Object)deadServerName);
        Assert.assertNotNull((Object)status.getServersName());
        Assert.assertEquals((long)numRs, (long)status.getServersName().size());
    }

    @Test
    public void testMasterAndBackupMastersStatus() throws Exception {
        List<JVMClusterUtil.MasterThread> masterThreads = CLUSTER.getMasterThreads();
        int numActive = 0;
        int activeIndex = 0;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertNotNull(active);
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.MASTER, ClusterMetrics.Option.BACKUP_MASTERS);
        ClusterMetrics status = ADMIN.getClusterMetrics(options);
        Assert.assertTrue((boolean)status.getMasterName().equals((Object)activeName));
        Assert.assertEquals((long)2L, (long)status.getBackupMasterNames().size());
    }

    @Test
    public void testOtherStatusInfos() throws Exception {
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.MASTER_COPROCESSORS, ClusterMetrics.Option.HBASE_VERSION, ClusterMetrics.Option.CLUSTER_ID, ClusterMetrics.Option.BALANCER_ON);
        ClusterMetrics status = ADMIN.getClusterMetrics(options);
        Assert.assertTrue((status.getMasterCoprocessorNames().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getHBaseVersion());
        Assert.assertNotNull((Object)status.getClusterId());
        Assert.assertTrue((status.getAverageLoad() == 0.0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getBalancerOn());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testObserver() throws IOException {
        int preCount = MyObserver.PRE_COUNT.get();
        int postCount = MyObserver.POST_COUNT.get();
        Assert.assertTrue((boolean)ADMIN.getClusterMetrics().getMasterCoprocessorNames().stream().anyMatch(s -> s.equals(MyObserver.class.getSimpleName())));
        Assert.assertEquals((long)(preCount + 1), (long)MyObserver.PRE_COUNT.get());
        Assert.assertEquals((long)(postCount + 1), (long)MyObserver.POST_COUNT.get());
    }

    public static class MyObserver
    implements MasterCoprocessor,
    MasterObserver {
        private static final AtomicInteger PRE_COUNT = new AtomicInteger(0);
        private static final AtomicInteger POST_COUNT = new AtomicInteger(0);

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preGetClusterMetrics(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            PRE_COUNT.incrementAndGet();
        }

        public void postGetClusterMetrics(ObserverContext<MasterCoprocessorEnvironment> ctx, ClusterMetrics status) throws IOException {
            POST_COUNT.incrementAndGet();
        }
    }
}

