/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Phoenix"})
@InterfaceStability.Evolving
public final class StartTestingClusterOption {
    private final int numMasters;
    private final int numAlwaysStandByMasters;
    private final Class<? extends HMaster> masterClass;
    private final int numRegionServers;
    private final List<Integer> rsPorts;
    private Class<? extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer> rsClass;
    private final int numDataNodes;
    private final String[] dataNodeHosts;
    private final int numZkServers;
    private final boolean createRootDir;
    private final boolean createWALDir;

    private StartTestingClusterOption(int numMasters, int numAlwaysStandByMasters, Class<? extends HMaster> masterClass, int numRegionServers, List<Integer> rsPorts, Class<? extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer> rsClass, int numDataNodes, String[] dataNodeHosts, int numZkServers, boolean createRootDir, boolean createWALDir) {
        this.numMasters = numMasters;
        this.numAlwaysStandByMasters = numAlwaysStandByMasters;
        this.masterClass = masterClass;
        this.numRegionServers = numRegionServers;
        this.rsPorts = rsPorts;
        this.rsClass = rsClass;
        this.numDataNodes = numDataNodes;
        this.dataNodeHosts = dataNodeHosts;
        this.numZkServers = numZkServers;
        this.createRootDir = createRootDir;
        this.createWALDir = createWALDir;
    }

    public int getNumMasters() {
        return this.numMasters;
    }

    public int getNumAlwaysStandByMasters() {
        return this.numAlwaysStandByMasters;
    }

    public Class<? extends HMaster> getMasterClass() {
        return this.masterClass;
    }

    public int getNumRegionServers() {
        return this.numRegionServers;
    }

    public List<Integer> getRsPorts() {
        return this.rsPorts;
    }

    public Class<? extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer> getRsClass() {
        return this.rsClass;
    }

    public int getNumDataNodes() {
        return this.numDataNodes;
    }

    public String[] getDataNodeHosts() {
        return this.dataNodeHosts;
    }

    public int getNumZkServers() {
        return this.numZkServers;
    }

    public boolean isCreateRootDir() {
        return this.createRootDir;
    }

    public boolean isCreateWALDir() {
        return this.createWALDir;
    }

    public String toString() {
        return "StartMiniClusterOption{numMasters=" + this.numMasters + ", masterClass=" + this.masterClass + ", numRegionServers=" + this.numRegionServers + ", rsPorts=" + StringUtils.join((Object[])new List[]{this.rsPorts}) + ", rsClass=" + this.rsClass + ", numDataNodes=" + this.numDataNodes + ", dataNodeHosts=" + Arrays.toString(this.dataNodeHosts) + ", numZkServers=" + this.numZkServers + ", createRootDir=" + this.createRootDir + ", createWALDir=" + this.createWALDir + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int numMasters = 1;
        private int numAlwaysStandByMasters = 0;
        private Class<? extends HMaster> masterClass = null;
        private int numRegionServers = 1;
        private List<Integer> rsPorts = null;
        private Class<? extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer> rsClass = null;
        private int numDataNodes = 1;
        private String[] dataNodeHosts = null;
        private int numZkServers = 1;
        private boolean createRootDir = false;
        private boolean createWALDir = false;

        private Builder() {
        }

        public StartTestingClusterOption build() {
            if (this.dataNodeHosts != null && this.dataNodeHosts.length != 0) {
                this.numDataNodes = this.dataNodeHosts.length;
            }
            return new StartTestingClusterOption(this.numMasters, this.numAlwaysStandByMasters, this.masterClass, this.numRegionServers, this.rsPorts, this.rsClass, this.numDataNodes, this.dataNodeHosts, this.numZkServers, this.createRootDir, this.createWALDir);
        }

        public Builder numMasters(int numMasters) {
            this.numMasters = numMasters;
            return this;
        }

        public Builder numAlwaysStandByMasters(int numAlwaysStandByMasters) {
            this.numAlwaysStandByMasters = numAlwaysStandByMasters;
            return this;
        }

        public Builder masterClass(Class<? extends HMaster> masterClass) {
            this.masterClass = masterClass;
            return this;
        }

        public Builder numRegionServers(int numRegionServers) {
            this.numRegionServers = numRegionServers;
            return this;
        }

        public Builder rsPorts(List<Integer> rsPorts) {
            this.rsPorts = rsPorts;
            return this;
        }

        public Builder rsClass(Class<? extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer> rsClass) {
            this.rsClass = rsClass;
            return this;
        }

        public Builder numDataNodes(int numDataNodes) {
            this.numDataNodes = numDataNodes;
            return this;
        }

        public Builder dataNodeHosts(String[] dataNodeHosts) {
            this.dataNodeHosts = dataNodeHosts;
            return this;
        }

        public Builder numZkServers(int numZkServers) {
            this.numZkServers = numZkServers;
            return this;
        }

        public Builder numWorkers(int numWorkers) {
            return this.numDataNodes(numWorkers).numRegionServers(numWorkers);
        }

        public Builder createRootDir(boolean createRootDir) {
            this.createRootDir = createRootDir;
            return this;
        }

        public Builder createWALDir(boolean createWALDir) {
            this.createWALDir = createWALDir;
            return this;
        }
    }
}

