/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.junit.rules.ExternalResource;

public final class MiniClusterRule
extends ExternalResource {
    private final HBaseTestingUtil testingUtility;
    private final StartTestingClusterOption miniClusterOptions;
    private SingleProcessHBaseCluster miniCluster;

    private MiniClusterRule(Configuration conf, StartTestingClusterOption miniClusterOptions) {
        this.testingUtility = new HBaseTestingUtil(conf);
        this.miniClusterOptions = miniClusterOptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HBaseTestingUtil getTestingUtility() {
        return this.testingUtility;
    }

    public Connection createConnection() {
        try {
            return this.createAsyncConnection().get().toConnection();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<AsyncConnection> createAsyncConnection() {
        if (this.miniCluster == null) {
            throw new IllegalStateException("test cluster not initialized");
        }
        return ConnectionFactory.createAsyncConnection((Configuration)this.miniCluster.getConf());
    }

    protected void before() throws Throwable {
        this.miniCluster = this.testingUtility.startMiniCluster(this.miniClusterOptions);
    }

    protected void after() {
        try {
            this.testingUtility.shutdownMiniCluster();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private StartTestingClusterOption miniClusterOption;
        private Configuration conf;

        public Builder setMiniClusterOption(StartTestingClusterOption miniClusterOption) {
            this.miniClusterOption = miniClusterOption;
            return this;
        }

        public Builder setConfiguration(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setConfiguration(Supplier<Configuration> supplier) {
            return this.setConfiguration(supplier.get());
        }

        public MiniClusterRule build() {
            return new MiniClusterRule(this.conf, this.miniClusterOption != null ? this.miniClusterOption : StartTestingClusterOption.builder().build());
        }
    }
}

