/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.replication.master.ReplicationSinkTrackerTableCreator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReplicationMarkerChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationMarkerChore.class);
    private static final MultiVersionConcurrencyControl MVCC = new MultiVersionConcurrencyControl();
    public static final RegionInfo REGION_INFO = RegionInfoBuilder.newBuilder((TableName)ReplicationSinkTrackerTableCreator.REPLICATION_SINK_TRACKER_TABLE_NAME).build();
    private static final String DELIMITER = "_";
    private final Configuration conf;
    private final RegionServerServices rsServices;
    private WAL wal;
    public static final String REPLICATION_MARKER_ENABLED_KEY = "hbase.regionserver.replication.marker.enabled";
    public static final boolean REPLICATION_MARKER_ENABLED_DEFAULT = false;
    public static final String REPLICATION_MARKER_CHORE_DURATION_KEY = "hbase.regionserver.replication.marker.chore.duration";
    public static final int REPLICATION_MARKER_CHORE_DURATION_DEFAULT = 30000;

    public ReplicationMarkerChore(Stoppable stopper, RegionServerServices rsServices, int period, Configuration conf) {
        super("ReplicationTrackerChore", stopper, period);
        this.conf = conf;
        this.rsServices = rsServices;
    }

    protected void chore() {
        List<HRegion> regions;
        if (this.wal == null) {
            try {
                this.wal = this.rsServices.getWAL(null);
            }
            catch (IOException ioe) {
                LOG.warn("Unable to get WAL ", (Throwable)ioe);
                return;
            }
        }
        String serverName = this.rsServices.getServerName().getServerName();
        long timeStamp = EnvironmentEdgeManager.currentTime();
        byte[] rowKey = ReplicationMarkerChore.getRowKey(serverName, timeStamp);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating replication marker edit.");
        }
        if ((regions = this.rsServices.getRegions()).isEmpty()) {
            LOG.info("There are no online regions for this server, so skipping adding replication marker rows for this regionserver");
            return;
        }
        HRegion region = regions.get(ThreadLocalRandom.current().nextInt(regions.size()));
        try {
            WALUtil.writeReplicationMarkerAndSync(this.wal, MVCC, region.getRegionInfo(), rowKey, timeStamp);
        }
        catch (IOException ioe) {
            LOG.error("Exception while sync'ing replication tracker edit", (Throwable)ioe);
        }
    }

    public static byte[] getRowKey(String serverName, long timestamp) {
        String timestampStr = String.valueOf(timestamp);
        String rowKeyStr = serverName + DELIMITER + timestampStr;
        return Bytes.toBytes((String)rowKeyStr);
    }
}

