/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.waleventtracker.WALEventTrackerTableCreator;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerPayload;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class WALEventTrackerTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(WALEventTrackerTableAccessor.class);
    public static final String RS_COLUMN = "region_server_name";
    public static final String WAL_NAME_COLUMN = "wal_name";
    public static final String TIMESTAMP_COLUMN = "timestamp";
    public static final String WAL_STATE_COLUMN = "wal_state";
    public static final String WAL_LENGTH_COLUMN = "wal_length";
    public static final String MAX_ATTEMPTS_KEY = "wal.event.tracker.max.attempts";
    public static final String SLEEP_INTERVAL_KEY = "wal.event.tracker.sleep.interval.msec";
    public static final String MAX_SLEEP_TIME_KEY = "wal.event.tracker.max.sleep.time.msec";
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_SLEEP_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_SLEEP_TIME = 60000L;
    public static final String WAL_EVENT_TRACKER_TABLE_NAME_STR = "REPLICATION.WALEVENTTRACKER";
    public static final String DELIMITER = "_";
    public static final TableName WAL_EVENT_TRACKER_TABLE_NAME = TableName.valueOf((String)"REPLICATION.WALEVENTTRACKER");

    private WALEventTrackerTableAccessor() {
    }

    private static void doPut(Connection connection, List<Put> puts) throws Exception {
        RetryCounter retryCounter = WALEventTrackerTableAccessor.getRetryFactory(connection.getConfiguration()).create();
        while (true) {
            try (Table table = connection.getTable(WAL_EVENT_TRACKER_TABLE_NAME);){
                table.put(puts);
                return;
            }
            catch (IOException ioe) {
                WALEventTrackerTableAccessor.retryOrThrow(retryCounter, ioe);
                retryCounter.sleepUntilNextRetry();
                continue;
            }
            break;
        }
    }

    private static RetryCounterFactory getRetryFactory(Configuration conf) {
        int maxAttempts = conf.getInt(MAX_ATTEMPTS_KEY, 3);
        long sleepIntervalMs = conf.getLong(SLEEP_INTERVAL_KEY, 1000L);
        long maxSleepTimeMs = conf.getLong(MAX_SLEEP_TIME_KEY, 60000L);
        RetryCounter.RetryConfig retryConfig = new RetryCounter.RetryConfig(maxAttempts, sleepIntervalMs, maxSleepTimeMs, TimeUnit.MILLISECONDS, (RetryCounter.BackoffPolicy)new RetryCounter.ExponentialBackoffPolicyWithLimit());
        return new RetryCounterFactory(retryConfig);
    }

    private static void retryOrThrow(RetryCounter retryCounter, IOException ioe) throws IOException {
        if (retryCounter.shouldRetry()) {
            return;
        }
        throw ioe;
    }

    public static void addWalEventTrackerRows(Queue<WALEventTrackerPayload> walEventPayloads, Connection connection) throws Exception {
        ArrayList<Put> puts = new ArrayList<Put>(walEventPayloads.size());
        for (WALEventTrackerPayload payload : walEventPayloads) {
            byte[] rowKey = WALEventTrackerTableAccessor.getRowKey(payload);
            Put put = new Put(rowKey);
            put.setPriority(0);
            put.addColumn(WALEventTrackerTableCreator.WAL_EVENT_TRACKER_INFO_FAMILY, Bytes.toBytes((String)RS_COLUMN), Bytes.toBytes((String)payload.getRsName())).addColumn(WALEventTrackerTableCreator.WAL_EVENT_TRACKER_INFO_FAMILY, Bytes.toBytes((String)WAL_NAME_COLUMN), Bytes.toBytes((String)payload.getWalName())).addColumn(WALEventTrackerTableCreator.WAL_EVENT_TRACKER_INFO_FAMILY, Bytes.toBytes((String)TIMESTAMP_COLUMN), Bytes.toBytes((long)payload.getTimeStamp())).addColumn(WALEventTrackerTableCreator.WAL_EVENT_TRACKER_INFO_FAMILY, Bytes.toBytes((String)WAL_STATE_COLUMN), Bytes.toBytes((String)payload.getState())).addColumn(WALEventTrackerTableCreator.WAL_EVENT_TRACKER_INFO_FAMILY, Bytes.toBytes((String)WAL_LENGTH_COLUMN), Bytes.toBytes((long)payload.getWalLength()));
            puts.add(put);
        }
        WALEventTrackerTableAccessor.doPut(connection, puts);
    }

    public static byte[] getRowKey(WALEventTrackerPayload payload) {
        String walName = payload.getWalName();
        String timestampStr = String.valueOf(payload.getTimeStamp());
        String walState = payload.getState();
        String rowKeyStr = walName + DELIMITER + timestampStr + DELIMITER + walState;
        return Bytes.toBytes((String)rowKeyStr);
    }
}

