/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AddPeerProcedure
extends ModifyPeerProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(AddPeerProcedure.class);
    private ReplicationPeerConfig peerConfig;
    private boolean enabled;
    private boolean cleanerDisabled;

    public AddPeerProcedure() {
    }

    public AddPeerProcedure(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) {
        super(peerId);
        this.peerConfig = peerConfig;
        this.enabled = enabled;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.ADD;
    }

    @Override
    protected MasterProcedureProtos.PeerModificationState nextStateAfterRefresh() {
        return this.peerConfig.isSerial() ? MasterProcedureProtos.PeerModificationState.SERIAL_PEER_REOPEN_REGIONS : super.nextStateAfterRefresh();
    }

    @Override
    protected void updateLastPushedSequenceIdForSerialPeer(MasterProcedureEnv env) throws IOException, ReplicationException {
        this.setLastPushedSequenceId(env, this.peerConfig);
    }

    @Override
    protected boolean enablePeerBeforeFinish() {
        return this.enabled;
    }

    @Override
    protected ReplicationPeerConfig getNewPeerConfig() {
        return this.peerConfig;
    }

    @Override
    protected void releaseLatch(MasterProcedureEnv env) {
        if (this.cleanerDisabled) {
            env.getMasterServices().getReplicationLogCleanerBarrier().enable();
        }
        if (this.peerConfig.isSyncReplication()) {
            env.getMasterServices().getSyncReplicationPeerLock().release();
        }
        super.releaseLatch(env);
    }

    @Override
    protected void prePeerModification(MasterProcedureEnv env) throws IOException, ReplicationException, ProcedureSuspendedException {
        if (!env.getMasterServices().getReplicationLogCleanerBarrier().disable()) {
            throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("LogCleaner is run at the same time when adding peer {}, sleep {} secs", (Object)this.peerId, (Object)(backoff / 1000L)));
        }
        this.cleanerDisabled = true;
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preAddReplicationPeer(this.peerId, this.peerConfig);
        }
        if (this.peerConfig.isSyncReplication() && !env.getMasterServices().getSyncReplicationPeerLock().tryAcquire()) {
            throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Can not acquire sync replication peer lock for peer {}, sleep {} secs", (Object)this.peerId, (Object)(backoff / 1000L)));
        }
        env.getReplicationPeerManager().preAddPeer(this.peerId, this.peerConfig);
    }

    @Override
    protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().addPeer(this.peerId, this.peerConfig, this.peerConfig.isSerial() ? false : this.enabled);
    }

    @Override
    protected void postPeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
        LOG.info("Successfully added {} peer {}, config {}", new Object[]{this.enabled ? "ENABLED" : "DISABLED", this.peerId, this.peerConfig});
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            env.getMasterCoprocessorHost().postAddReplicationPeer(this.peerId, this.peerConfig);
        }
    }

    protected void afterReplay(MasterProcedureEnv env) {
        if (this.getCurrentState() == this.getInitialState()) {
            return;
        }
        if (!env.getMasterServices().getReplicationLogCleanerBarrier().disable()) {
            throw new IllegalStateException("can not disable log cleaner, this should not happen");
        }
        this.cleanerDisabled = true;
        if (this.peerConfig.isSyncReplication() && !env.getMasterServices().getSyncReplicationPeerLock().tryAcquire()) {
            throw new IllegalStateException("Can not acquire sync replication peer lock for peer " + this.peerId);
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.AddPeerStateData.newBuilder().setPeerConfig(ReplicationPeerConfigUtil.convert((ReplicationPeerConfig)this.peerConfig)).setEnabled(this.enabled).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.AddPeerStateData data = (MasterProcedureProtos.AddPeerStateData)serializer.deserialize(MasterProcedureProtos.AddPeerStateData.class);
        this.peerConfig = ReplicationPeerConfigUtil.convert((ReplicationProtos.ReplicationPeer)data.getPeerConfig());
        this.enabled = data.getEnabled();
    }
}

