/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.TableNamespaceManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class InitMetaProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.InitMetaState> {
    private static final Logger LOG = LoggerFactory.getLogger(InitMetaProcedure.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private RetryCounter retryCounter;

    @Override
    public TableName getTableName() {
        return TableName.META_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.CREATE;
    }

    private static TableDescriptor writeFsLayout(Path rootDir, Configuration conf) throws IOException {
        LOG.info("BOOTSTRAP: creating hbase:meta region");
        FileSystem fs = rootDir.getFileSystem(conf);
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)TableName.META_TABLE_NAME);
        if (fs.exists(tableDir) && !fs.delete(tableDir, true)) {
            LOG.warn("Can not delete partial created meta table, continue...");
        }
        TableDescriptor metaDescriptor = FSTableDescriptors.tryUpdateAndGetMetaTableDescriptor(conf, fs, rootDir);
        HRegion.createHRegion(RegionInfoBuilder.FIRST_META_REGIONINFO, rootDir, conf, metaDescriptor, null).close();
        return metaDescriptor;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.InitMetaState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        LOG.debug("Execute {}", (Object)this);
        try {
            switch (state) {
                case INIT_META_WRITE_FS_LAYOUT: {
                    Configuration conf = env.getMasterConfiguration();
                    Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
                    TableDescriptor td = InitMetaProcedure.writeFsLayout(rootDir, conf);
                    env.getMasterServices().getTableDescriptors().update(td, true);
                    this.setNextState(MasterProcedureProtos.InitMetaState.INIT_META_ASSIGN_META);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case INIT_META_ASSIGN_META: {
                    LOG.info("Going to assign meta");
                    this.addChildProcedure((Procedure[])env.getAssignmentManager().createAssignProcedures(Arrays.asList(RegionInfoBuilder.FIRST_META_REGIONINFO)));
                    this.setNextState(MasterProcedureProtos.InitMetaState.INIT_META_CREATE_NAMESPACES);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case INIT_META_CREATE_NAMESPACES: {
                    LOG.info("Going to create {} and {} namespaces", (Object)NamespaceDescriptor.DEFAULT_NAMESPACE, (Object)NamespaceDescriptor.SYSTEM_NAMESPACE);
                    AbstractStateMachineNamespaceProcedure.createDirectory(env, NamespaceDescriptor.DEFAULT_NAMESPACE);
                    AbstractStateMachineNamespaceProcedure.createDirectory(env, NamespaceDescriptor.SYSTEM_NAMESPACE);
                    TableNamespaceManager.insertNamespaceToMeta(env.getMasterServices().getConnection(), NamespaceDescriptor.DEFAULT_NAMESPACE);
                    TableNamespaceManager.insertNamespaceToMeta(env.getMasterServices().getConnection(), NamespaceDescriptor.SYSTEM_NAMESPACE);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (IOException e) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("Failed to init meta, suspend {}secs", (Object)backoff, (Object)e);
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return false;
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.InitMetaState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.InitMetaState getState(int stateId) {
        return MasterProcedureProtos.InitMetaState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.InitMetaState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.InitMetaState getInitialState() {
        return MasterProcedureProtos.InitMetaState.INIT_META_WRITE_FS_LAYOUT;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.InitMetaStateData.getDefaultInstance());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        serializer.deserialize(MasterProcedureProtos.InitMetaStateData.class);
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }
}

