/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CacheableDeserializerIdManager {
    private static final Map<Integer, CacheableDeserializer<Cacheable>> registeredDeserializers = new ConcurrentHashMap<Integer, CacheableDeserializer<Cacheable>>();
    private static final AtomicInteger identifier = new AtomicInteger(0);

    public static int registerDeserializer(CacheableDeserializer<Cacheable> cd) {
        int idx = identifier.incrementAndGet();
        registeredDeserializers.put(idx, cd);
        return idx;
    }

    public static CacheableDeserializer<Cacheable> getDeserializer(int id) {
        return registeredDeserializers.get(id);
    }

    public static Map<Integer, String> save() {
        return registeredDeserializers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((CacheableDeserializer)e.getValue()).getClass().getName()));
    }
}

