/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.errorprone.annotations.RestrictedApi;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.lang.management.MemoryType;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseRpcServicesBase;
import org.apache.hadoop.hbase.MetaRegionLocationCache;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.ClusterConnectionFactory;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionRegistryEndpoint;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.ZKAuthentication;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class HBaseServerBase<R extends HBaseRpcServicesBase<?>>
extends Thread
implements Server,
ConfigurationObserver,
ConnectionRegistryEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseServerBase.class);
    protected final Configuration conf;
    protected final AtomicBoolean abortRequested = new AtomicBoolean(false);
    protected volatile boolean stopped = false;
    private boolean isShutdownHookInstalled = false;
    protected final long startcode;
    protected final UserProvider userProvider;
    protected final ZKWatcher zooKeeper;
    protected ServerName serverName;
    protected final R rpcServices;
    protected final String useThisHostnameInstead;
    protected final NamedQueueRecorder namedQueueRecorder;
    protected final ConfigurationManager configurationManager;
    protected final ChoreService choreService;
    protected final ExecutorService executorService;
    protected final ClusterStatusTracker clusterStatusTracker;
    protected final CoordinatedStateManager csm;
    protected InfoServer infoServer;
    protected HFileSystem dataFs;
    protected HFileSystem walFs;
    protected Path dataRootDir;
    protected Path walRootDir;
    protected final int msgInterval;
    protected final Sleeper sleeper;
    protected TableDescriptors tableDescriptors;
    protected AsyncClusterConnection asyncClusterConnection;
    protected final MetaRegionLocationCache metaRegionLocationCache;
    protected final NettyEventLoopGroupConfig eventLoopGroupConfig;

    private static void setupWindows(Configuration conf, ConfigurationManager cm) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            HBasePlatformDependent.handle((String)"HUP", (number, name) -> {
                conf.reloadConfiguration();
                cm.notifyAllObservers(conf);
            });
        }
    }

    protected final synchronized void setupClusterConnection() throws IOException {
        if (this.asyncClusterConnection == null) {
            InetSocketAddress localAddress = new InetSocketAddress(((HBaseRpcServicesBase)this.rpcServices).getSocketAddress().getAddress(), 0);
            User user = this.userProvider.getCurrent();
            this.asyncClusterConnection = ClusterConnectionFactory.createAsyncClusterConnection(this, this.conf, (SocketAddress)localAddress, user);
        }
    }

    protected final void initializeFileSystem() throws IOException {
        boolean useHBaseChecksum = this.conf.getBoolean("hbase.regionserver.checksum.verify", true);
        String walDirUri = CommonFSUtils.getDirUri((Configuration)this.conf, (Path)new Path(this.conf.get("hbase.wal.dir", this.conf.get("hbase.rootdir"))));
        if (walDirUri != null) {
            CommonFSUtils.setFsDefault((Configuration)this.conf, (String)walDirUri);
        }
        this.walFs = new HFileSystem(this.conf, useHBaseChecksum);
        this.walRootDir = CommonFSUtils.getWALRootDir((Configuration)this.conf);
        String rootDirUri = CommonFSUtils.getDirUri((Configuration)this.conf, (Path)new Path(this.conf.get("hbase.rootdir")));
        if (rootDirUri != null) {
            CommonFSUtils.setFsDefault((Configuration)this.conf, (String)rootDirUri);
        }
        this.dataFs = new HFileSystem(this.conf, useHBaseChecksum);
        this.dataRootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        int tableDescriptorParallelLoadThreads = this.conf.getInt("hbase.tabledescriptor.parallel.load.threads", 0);
        this.tableDescriptors = new FSTableDescriptors((FileSystem)this.dataFs, this.dataRootDir, !this.canUpdateTableDescriptor(), this.cacheTableDescriptor(), tableDescriptorParallelLoadThreads);
    }

    public HBaseServerBase(Configuration conf, String name) throws IOException {
        super(name);
        Span span = TraceUtil.createSpan((String)"HBaseServerBase.cxtor");
        try (Scope ignored = span.makeCurrent();){
            this.conf = conf;
            this.eventLoopGroupConfig = NettyEventLoopGroupConfig.setup(conf, this.getClass().getSimpleName() + "-EventLoopGroup");
            this.startcode = EnvironmentEdgeManager.currentTime();
            this.userProvider = UserProvider.instantiate((Configuration)conf);
            this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
            this.sleeper = new Sleeper(this.msgInterval, (Stoppable)this);
            this.namedQueueRecorder = this.createNamedQueueRecord();
            this.rpcServices = this.createRpcServices();
            this.useThisHostnameInstead = this.getUseThisHostnameInstead(conf);
            InetSocketAddress addr = ((HBaseRpcServicesBase)this.rpcServices).getSocketAddress();
            boolean useIp = conf.getBoolean("hbase.server.useip.enabled", false);
            String isaHostName = useIp ? addr.getAddress().getHostAddress() : addr.getAddress().getHostName();
            String hostName = StringUtils.isBlank((CharSequence)this.useThisHostnameInstead) ? isaHostName : this.useThisHostnameInstead;
            this.serverName = ServerName.valueOf((String)hostName, (int)addr.getPort(), (long)this.startcode);
            ZKAuthentication.loginClient((Configuration)this.conf, (String)"hbase.zookeeper.client.keytab.file", (String)"hbase.zookeeper.client.kerberos.principal", (String)hostName);
            this.login(this.userProvider, hostName);
            Superusers.initialize((Configuration)conf);
            this.zooKeeper = new ZKWatcher(conf, this.getProcessName() + ":" + addr.getPort(), (Abortable)this, this.canCreateBaseZNode());
            this.configurationManager = new ConfigurationManager();
            HBaseServerBase.setupWindows(conf, this.configurationManager);
            this.initializeFileSystem();
            int choreServiceInitialSize = conf.getInt("hbase.choreservice.initial.pool.size", 1);
            this.choreService = new ChoreService(this.getName(), choreServiceInitialSize, true);
            this.executorService = new ExecutorService(this.getName());
            this.metaRegionLocationCache = new MetaRegionLocationCache(this.zooKeeper);
            if (this.clusterMode()) {
                this.csm = conf.getBoolean("hbase.split.wal.zk.coordinated", false) ? new ZkCoordinatedStateManager(this) : null;
                this.clusterStatusTracker = new ClusterStatusTracker(this.zooKeeper, (Abortable)this);
                this.clusterStatusTracker.start();
            } else {
                this.csm = null;
                this.clusterStatusTracker = null;
            }
            this.putUpWebUI();
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable t) {
            TraceUtil.setError((Span)span, (Throwable)t);
            throw t;
        }
        finally {
            span.end();
        }
    }

    private void putUpWebUI() throws IOException {
        int port = this.conf.getInt("hbase.regionserver.info.port", 16030);
        String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
        if (this instanceof HMaster) {
            port = this.conf.getInt("hbase.master.info.port", 16010);
            addr = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
        }
        if (port < 0) {
            return;
        }
        if (!Addressing.isLocalAddress((InetAddress)InetAddress.getByName(addr))) {
            String msg = "Failed to start http info server. Address " + addr + " does not belong to this host. Correct configuration parameter: hbase.regionserver.info.bindAddress";
            LOG.error(msg);
            throw new IOException(msg);
        }
        boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
        while (true) {
            try {
                this.infoServer = new InfoServer(this.getProcessName(), addr, port, false, this.conf);
                this.infoServer.addPrivilegedServlet("dump", "/dump", this.getDumpServlet());
                this.configureInfoServer(this.infoServer);
                this.infoServer.start();
            }
            catch (BindException e) {
                if (!auto) {
                    LOG.error("Failed binding http info server to port: " + port);
                    throw e;
                }
                LOG.info("Failed binding http info server to port: " + port);
                LOG.info("Retry starting http info server with port: " + ++port);
                continue;
            }
            break;
        }
        port = this.infoServer.getPort();
        this.conf.setInt("hbase.regionserver.info.port", port);
        int masterInfoPort = this.conf.getInt("hbase.master.info.port", 16010);
        this.conf.setInt("hbase.master.info.port.orig", masterInfoPort);
        this.conf.setInt("hbase.master.info.port", port);
    }

    protected final boolean setAbortRequested() {
        return this.abortRequested.compareAndSet(false, true);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isAborted() {
        return this.abortRequested.get();
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public AsyncClusterConnection getAsyncClusterConnection() {
        return this.asyncClusterConnection;
    }

    @Override
    public ZKWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    protected final void shutdownChore(ScheduledChore chore) {
        if (chore != null) {
            chore.shutdown();
        }
    }

    protected final void initializeMemStoreChunkCreator(HeapMemoryManager hMemManager) {
        if (MemStoreLAB.isEnabled(this.conf)) {
            Pair<Long, MemoryType> pair = MemorySizeUtil.getGlobalMemStoreSize(this.conf);
            long globalMemStoreSize = (Long)pair.getFirst();
            boolean offheap = pair.getSecond() == MemoryType.NON_HEAP;
            float poolSizePercentage = offheap ? 1.0f : this.conf.getFloat("hbase.hregion.memstore.chunkpool.maxsize", 1.0f);
            float initialCountPercentage = this.conf.getFloat("hbase.hregion.memstore.chunkpool.initialsize", 0.0f);
            int chunkSize = this.conf.getInt("hbase.hregion.memstore.mslab.chunksize", 0x200000);
            float indexChunkSizePercent = this.conf.getFloat("hbase.hregion.memstore.mslab.indexchunksize.percent", 0.1f);
            ChunkCreator.initialize(chunkSize, offheap, globalMemStoreSize, poolSizePercentage, initialCountPercentage, hMemManager, indexChunkSizePercent);
        }
    }

    protected abstract void stopChores();

    protected final void stopChoreService() {
        if (this.choreService != null) {
            LOG.info("Shutdown chores and chore service");
            this.stopChores();
            this.choreService.shutdown();
        }
    }

    protected final void stopExecutorService() {
        if (this.executorService != null) {
            LOG.info("Shutdown executor service");
            this.executorService.shutdown();
        }
    }

    protected final void closeClusterConnection() {
        if (this.asyncClusterConnection != null) {
            LOG.info("Close async cluster connection");
            try {
                this.asyncClusterConnection.close();
            }
            catch (IOException e) {
                LOG.warn("Attempt to close server's AsyncClusterConnection failed.", (Throwable)e);
            }
        }
    }

    protected final void stopInfoServer() {
        if (this.infoServer != null) {
            LOG.info("Stop info server");
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                LOG.error("Failed to stop infoServer", (Throwable)e);
            }
        }
    }

    protected final void closeZooKeeper() {
        if (this.zooKeeper != null) {
            LOG.info("Close zookeeper");
            this.zooKeeper.close();
        }
    }

    protected final void closeTableDescriptors() {
        if (this.tableDescriptors != null) {
            LOG.info("Close table descriptors");
            try {
                this.tableDescriptors.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close table descriptors gracefully", (Throwable)e);
            }
        }
    }

    protected final void installShutdownHook() {
        ShutdownHook.install(this.conf, (FileSystem)this.dataFs, this, Thread.currentThread());
        this.isShutdownHookInstalled = true;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public boolean isShutdownHookInstalled() {
        return this.isShutdownHookInstalled;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public ChoreService getChoreService() {
        return this.choreService;
    }

    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public AccessChecker getAccessChecker() {
        return ((HBaseRpcServicesBase)this.rpcServices).getAccessChecker();
    }

    public ZKPermissionWatcher getZKPermissionWatcher() {
        return ((HBaseRpcServicesBase)this.rpcServices).getZkPermissionWatcher();
    }

    @Override
    public CoordinatedStateManager getCoordinatedStateManager() {
        return this.csm;
    }

    @Override
    public Connection createConnection(Configuration conf) throws IOException {
        User user = UserProvider.instantiate((Configuration)conf).getCurrent();
        return ConnectionFactory.createConnection((Configuration)conf, null, (User)user);
    }

    public Path getDataRootDir() {
        return this.dataRootDir;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.dataFs;
    }

    public Path getWALRootDir() {
        return this.walRootDir;
    }

    public FileSystem getWALFileSystem() {
        return this.walFs;
    }

    public boolean isClusterUp() {
        return !this.clusterMode() || this.clusterStatusTracker.isClusterUp();
    }

    public long getStartcode() {
        return this.startcode;
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public int getMsgInterval() {
        return this.msgInterval;
    }

    public NamedQueueRecorder getNamedQueueRecorder() {
        return this.namedQueueRecorder;
    }

    public RpcServerInterface getRpcServer() {
        return ((HBaseRpcServicesBase)this.rpcServices).getRpcServer();
    }

    public NettyEventLoopGroupConfig getEventLoopGroupConfig() {
        return this.eventLoopGroupConfig;
    }

    public R getRpcServices() {
        return this.rpcServices;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public MetaRegionLocationCache getMetaRegionLocationCache() {
        return this.metaRegionLocationCache;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void updateConfiguration() {
        LOG.info("Reloading the configuration from disk.");
        this.conf.reloadConfiguration();
        this.configurationManager.notifyAllObservers(this.conf);
    }

    @Override
    public String toString() {
        return this.getServerName().toString();
    }

    protected abstract boolean canCreateBaseZNode();

    protected abstract String getProcessName();

    protected abstract R createRpcServices() throws IOException;

    protected abstract String getUseThisHostnameInstead(Configuration var1) throws IOException;

    protected abstract void login(UserProvider var1, String var2) throws IOException;

    protected abstract NamedQueueRecorder createNamedQueueRecord();

    protected abstract void configureInfoServer(InfoServer var1);

    protected abstract Class<? extends HttpServlet> getDumpServlet();

    protected abstract boolean canUpdateTableDescriptor();

    protected abstract boolean cacheTableDescriptor();

    protected abstract boolean clusterMode();
}

