/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MultiThreadedReader;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestTimeBoundedRequestsWithRegionReplicas
extends IntegrationTestIngest {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestTimeBoundedRequestsWithRegionReplicas.class);
    private static final String TEST_NAME = IntegrationTestTimeBoundedRequestsWithRegionReplicas.class.getSimpleName();
    protected static final long DEFAULT_GET_TIMEOUT = 5000L;
    protected static final String GET_TIMEOUT_KEY = "get_timeout_ms";
    protected static final long DEFAUL_CHAOS_MONKEY_DELAY = 20000L;
    protected static final String CHAOS_MONKEY_DELAY_KEY = "chaos_monkey_delay";
    protected static final int DEFAULT_REGION_REPLICATION = 3;

    @Override
    protected void startMonkey() throws Exception {
    }

    @Override
    protected MonkeyFactory getDefaultMonkeyFactory() {
        return MonkeyFactory.getFactory("calm");
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        conf.setIfUnset(String.format("%s.%s", clazz, "region_replication"), Integer.toString(3));
    }

    protected void writeData(int colsPerKey, int recordSize, int writeThreads, long startKey, long numKeys) throws IOException {
        int ret = this.loadTool.run(this.getArgsForLoadTestTool("-write", String.format("%d:%d:%d", colsPerKey, recordSize, writeThreads), startKey, numKeys));
        if (0 != ret) {
            String errorMsg = "Load failed with error code " + ret;
            LOG.error(errorMsg);
            Assert.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runIngestTest(long defaultRunTime, long keysPerServerPerIter, int colsPerKey, int recordSize, int writeThreads, int readThreads) throws Exception {
        LOG.info("Cluster size:" + this.util.getHBaseClusterInterface().getClusterMetrics().getLiveServerMetrics().size());
        long start = EnvironmentEdgeManager.currentTime();
        String runtimeKey = String.format("hbase.%s.runtime", ((Object)((Object)this)).getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, defaultRunTime);
        long startKey = 0L;
        long numKeys = this.getNumKeys(keysPerServerPerIter);
        LOG.info("Writing some data to the table");
        this.writeData(colsPerKey, recordSize, writeThreads, startKey, numKeys);
        LOG.info("Flushing the table");
        Admin admin = this.util.getAdmin();
        admin.flush(this.getTablename());
        long refreshTime = this.conf.getLong("hbase.regionserver.storefile.refresh.period", 0L);
        if (refreshTime > 0L && refreshTime <= 10000L) {
            LOG.info("Sleeping " + refreshTime + "ms to ensure that the data is replicated");
            Threads.sleep((long)(refreshTime * 3L));
        } else {
            LOG.info("Reopening the table");
            admin.disableTable(this.getTablename());
            admin.enableTable(this.getTablename());
        }
        long chaosMonkeyDelay = this.conf.getLong(String.format("%s.%s", TEST_NAME, CHAOS_MONKEY_DELAY_KEY), 20000L);
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        LOG.info(String.format("ChaosMonkey delay is : %d seconds. Will start %s ChaosMonkey after delay", chaosMonkeyDelay / 1000L, this.monkeyToUse));
        ScheduledFuture<?> result = executorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Starting ChaosMonkey");
                    IntegrationTestTimeBoundedRequestsWithRegionReplicas.this.monkey.start();
                    IntegrationTestTimeBoundedRequestsWithRegionReplicas.this.monkey.waitForStop();
                }
                catch (Exception e) {
                    LOG.warn(StringUtils.stringifyException((Throwable)e));
                }
            }
        }, chaosMonkeyDelay, TimeUnit.MILLISECONDS);
        long remainingTime = runtime - (EnvironmentEdgeManager.currentTime() - start);
        if (remainingTime <= 0L) {
            LOG.error("The amount of time left for the test to perform random reads is non-positive. Increase the test execution time via " + String.format("hbase.%s.runtime", IntegrationTestTimeBoundedRequestsWithRegionReplicas.class.getSimpleName()) + " or reduce the amount of data written per server via " + IntegrationTestTimeBoundedRequestsWithRegionReplicas.class.getSimpleName() + "." + "num_keys_per_server");
            throw new IllegalArgumentException("No time remains to execute random reads");
        }
        LOG.info("Reading random keys from the table for " + remainingTime / 60000L + " min");
        this.conf.setLong(String.format("hbase.%s.runtime", TimeBoundedMultiThreadedReader.class.getSimpleName()), remainingTime);
        try {
            int ret = this.loadTool.run(this.getArgsForLoadTestTool("-read", String.format("100:%d", readThreads), startKey, numKeys));
            if (0 != ret) {
                String errorMsg = "Verification failed with error code " + ret;
                LOG.error(errorMsg);
                Assert.fail((String)errorMsg);
            }
        }
        finally {
            if (result != null) {
                result.cancel(false);
            }
            this.monkey.stop("Stopping the test");
            this.monkey.waitForStop();
            executorService.shutdown();
        }
    }

    @Override
    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        ArrayList args = Lists.newArrayList((Object[])super.getArgsForLoadTestTool(mode, modeSpecificArg, startKey, numKeys));
        args.add("-reader");
        args.add(TimeBoundedMultiThreadedReader.class.getName());
        return args.toArray(new String[args.size()]);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestTimeBoundedRequestsWithRegionReplicas(), (String[])args);
        System.exit(ret);
    }

    public static class TimeBoundedMultiThreadedReader
    extends MultiThreadedReader {
        protected long timeoutNano;
        protected AtomicLong timedOutReads = new AtomicLong();
        protected long runTime;
        protected Thread timeoutThread;
        protected AtomicLong staleReads = new AtomicLong();

        public TimeBoundedMultiThreadedReader(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double verifyPercent) throws IOException {
            super(dataGen, conf, tableName, verifyPercent);
            long timeoutMs = conf.getLong(String.format("%s.%s", TEST_NAME, IntegrationTestTimeBoundedRequestsWithRegionReplicas.GET_TIMEOUT_KEY), 5000L);
            this.timeoutNano = timeoutMs * 1000000L;
            LOG.info("Timeout for gets: " + timeoutMs);
            String runTimeKey = String.format("hbase.%s.runtime", ((Object)((Object)this)).getClass().getSimpleName());
            this.runTime = conf.getLong(runTimeKey, -1L);
            if (this.runTime <= 0L) {
                throw new IllegalArgumentException("Please configure " + runTimeKey);
            }
        }

        public void waitForFinish() {
            try {
                this.timeoutThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.aborted = true;
            super.waitForFinish();
        }

        protected String progressInfo() {
            StringBuilder builder = new StringBuilder(super.progressInfo());
            TimeBoundedMultiThreadedReader.appendToStatus((StringBuilder)builder, (String)"stale_reads", (long)this.staleReads.get());
            TimeBoundedMultiThreadedReader.appendToStatus((StringBuilder)builder, (String)"get_timeouts", (long)this.timedOutReads.get());
            return builder.toString();
        }

        public void start(long startKey, long endKey, int numThreads) throws IOException {
            super.start(startKey, endKey, numThreads);
            this.timeoutThread = new TimeoutThread(this.runTime);
            this.timeoutThread.start();
        }

        protected MultiThreadedReader.HBaseReaderThread createReaderThread(int readerId) throws IOException {
            return new TimeBoundedMultiThreadedReaderThread(readerId);
        }

        public class TimeBoundedMultiThreadedReaderThread
        extends MultiThreadedReader.HBaseReaderThread {
            public TimeBoundedMultiThreadedReaderThread(int readerId) throws IOException {
                super((MultiThreadedReader)TimeBoundedMultiThreadedReader.this, readerId);
            }

            protected Get createGet(long keyToRead) throws IOException {
                Get get = super.createGet(keyToRead);
                get.setConsistency(Consistency.TIMELINE);
                return get;
            }

            protected long getNextKeyToRead() {
                long key = TimeBoundedMultiThreadedReader.this.startKey + ThreadLocalRandom.current().nextLong(Long.MAX_VALUE) % (TimeBoundedMultiThreadedReader.this.endKey - TimeBoundedMultiThreadedReader.this.startKey);
                return key;
            }

            protected void verifyResultsAndUpdateMetrics(boolean verify, Get[] gets, long elapsedNano, Result[] results, Table table, boolean isNullExpected) throws IOException {
                super.verifyResultsAndUpdateMetrics(verify, gets, elapsedNano, results, table, isNullExpected);
                for (Result r : results) {
                    if (!r.isStale()) continue;
                    TimeBoundedMultiThreadedReader.this.staleReads.incrementAndGet();
                }
                if (elapsedNano > TimeBoundedMultiThreadedReader.this.timeoutNano) {
                    TimeBoundedMultiThreadedReader.this.timedOutReads.incrementAndGet();
                    TimeBoundedMultiThreadedReader.this.numReadFailures.addAndGet(1L);
                    for (Result r : results) {
                        List locs;
                        LOG.error("FAILED FOR " + r);
                        try (RegionLocator locator = TimeBoundedMultiThreadedReader.this.connection.getRegionLocator(TimeBoundedMultiThreadedReader.this.tableName);){
                            locs = locator.getRegionLocations(r.getRow());
                        }
                        for (HRegionLocation h : locs) {
                            LOG.error("LOCATION " + h);
                        }
                    }
                }
            }
        }

        private static class TimeoutThread
        extends Thread {
            long timeout;
            long reportInterval = 60000L;

            public TimeoutThread(long timeout) {
                this.timeout = timeout;
            }

            @Override
            public void run() {
                long rem;
                while ((rem = Math.min(this.timeout, this.reportInterval)) > 0L) {
                    LOG.info("Remaining execution time:" + this.timeout / 60000L + " min");
                    Threads.sleep((long)rem);
                    this.timeout -= rem;
                }
            }
        }
    }
}

