/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.xml.ws.http.HTTPException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.gson.JsonElement;
import org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.apache.hbase.thirdparty.com.google.gson.JsonParser;
import org.apache.hbase.thirdparty.javax.ws.rs.client.Client;
import org.apache.hbase.thirdparty.javax.ws.rs.client.ClientBuilder;
import org.apache.hbase.thirdparty.javax.ws.rs.client.Entity;
import org.apache.hbase.thirdparty.javax.ws.rs.client.Invocation;
import org.apache.hbase.thirdparty.javax.ws.rs.client.WebTarget;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriBuilder;
import org.apache.hbase.thirdparty.org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTApiClusterManager
extends Configured
implements ClusterManager {
    private static final String REST_API_CLUSTER_MANAGER_HOSTNAME = "hbase.it.clustermanager.restapi.hostname";
    private static final String REST_API_CLUSTER_MANAGER_USERNAME = "hbase.it.clustermanager.restapi.username";
    private static final String REST_API_CLUSTER_MANAGER_PASSWORD = "hbase.it.clustermanager.restapi.password";
    private static final String REST_API_CLUSTER_MANAGER_CLUSTER_NAME = "hbase.it.clustermanager.restapi.clustername";
    private static final String REST_API_DELEGATE_CLUSTER_MANAGER = "hbase.it.clustermanager.restapi.delegate";
    private static final JsonParser parser = new JsonParser();
    private static final String DEFAULT_SERVER_HOSTNAME = "http://localhost:7180";
    private static final String DEFAULT_SERVER_USERNAME = "admin";
    private static final String DEFAULT_SERVER_PASSWORD = "admin";
    private static final String DEFAULT_CLUSTER_NAME = "Cluster 1";
    private String serverHostname;
    private String clusterName;
    private static final String API_VERSION = "v6";
    private final Client client = ClientBuilder.newClient();
    private ClusterManager hBaseClusterManager;
    private RetryCounterFactory retryCounterFactory;
    private static final Logger LOG = LoggerFactory.getLogger(RESTApiClusterManager.class);
    private static final Map<ClusterManager.ServiceType, Service> roleServiceType = RESTApiClusterManager.buildRoleServiceTypeMap();

    RESTApiClusterManager() {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        Class clazz = conf.getClass(REST_API_DELEGATE_CLUSTER_MANAGER, HBaseClusterManager.class, ClusterManager.class);
        this.hBaseClusterManager = (ClusterManager)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        this.serverHostname = conf.get(REST_API_CLUSTER_MANAGER_HOSTNAME, DEFAULT_SERVER_HOSTNAME);
        this.clusterName = conf.get(REST_API_CLUSTER_MANAGER_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        String serverUsername = conf.get(REST_API_CLUSTER_MANAGER_USERNAME, "admin");
        String serverPassword = conf.get(REST_API_CLUSTER_MANAGER_PASSWORD, "admin");
        this.client.register((Object)HttpAuthenticationFeature.basic((String)serverUsername, (String)serverPassword));
        this.retryCounterFactory = new RetryCounterFactory(new RetryCounter.RetryConfig().setMaxAttempts(conf.getInt("hbase.it.clustermanager.retry.attempts", 5)).setSleepInterval(conf.getLong("hbase.it.clustermanager.retry.sleep.interval", 1000L)));
    }

    @Override
    public void start(ClusterManager.ServiceType service, String hostname, int port) {
        LOG.debug("Performing start of {} on {}:{}", new Object[]{service, hostname, port});
        RoleState currentState = this.getRoleState(service, hostname);
        switch (currentState) {
            case NA: 
            case BUSY: 
            case UNKNOWN: 
            case HISTORY_NOT_AVAILABLE: {
                LOG.warn("Unexpected service state detected. Service START requested, but currently in {} state. Attempting to start. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                this.performClusterManagerCommand(service, hostname, RoleCommand.START);
                return;
            }
            case STOPPING: {
                LOG.warn("Unexpected service state detected. Service START requested, but currently in {} state. Waiting for stop before attempting start. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                this.waitFor(() -> Objects.equals((Object)RoleState.STOPPED, (Object)this.getRoleState(service, hostname)));
                this.performClusterManagerCommand(service, hostname, RoleCommand.START);
                return;
            }
            case STOPPED: {
                this.performClusterManagerCommand(service, hostname, RoleCommand.START);
                return;
            }
            case STARTING: {
                LOG.warn("Unexpected service state detected. Service START requested, but already in {} state. Ignoring current request and waiting for start to complete. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                this.waitFor(() -> Objects.equals((Object)RoleState.STARTED, (Object)this.getRoleState(service, hostname)));
                return;
            }
            case STARTED: {
                LOG.warn("Unexpected service state detected. Service START requested, but already in {} state. Restarting. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                this.performClusterManagerCommand(service, hostname, RoleCommand.RESTART);
                return;
            }
        }
        throw new RuntimeException("should not happen.");
    }

    @Override
    public void stop(ClusterManager.ServiceType service, String hostname, int port) {
        LOG.debug("Performing stop of {} on {}:{}", new Object[]{service, hostname, port});
        RoleState currentState = this.getRoleState(service, hostname);
        switch (currentState) {
            case NA: 
            case BUSY: 
            case UNKNOWN: 
            case HISTORY_NOT_AVAILABLE: {
                LOG.warn("Unexpected service state detected. Service STOP requested, but already in {} state. Attempting to stop. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                this.performClusterManagerCommand(service, hostname, RoleCommand.STOP);
                return;
            }
            case STOPPING: {
                this.waitFor(() -> Objects.equals((Object)RoleState.STOPPED, (Object)this.getRoleState(service, hostname)));
                return;
            }
            case STOPPED: {
                LOG.warn("Unexpected service state detected. Service STOP requested, but already in {} state. Ignoring current request. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                return;
            }
            case STARTING: {
                LOG.warn("Unexpected service state detected. Service STOP requested, but already in {} state. Waiting for start to complete. {}, {}:{}", new Object[]{currentState, service, hostname, port});
                this.waitFor(() -> Objects.equals((Object)RoleState.STARTED, (Object)this.getRoleState(service, hostname)));
                this.performClusterManagerCommand(service, hostname, RoleCommand.STOP);
                return;
            }
            case STARTED: {
                this.performClusterManagerCommand(service, hostname, RoleCommand.STOP);
                return;
            }
        }
        throw new RuntimeException("should not happen.");
    }

    @Override
    public void restart(ClusterManager.ServiceType service, String hostname, int port) {
        LOG.debug("Performing stop followed by start of {} on {}:{}", new Object[]{service, hostname, port});
        this.stop(service, hostname, port);
        this.start(service, hostname, port);
    }

    @Override
    public boolean isRunning(ClusterManager.ServiceType service, String hostname, int port) {
        LOG.debug("Issuing isRunning request against {} on {}:{}", new Object[]{service, hostname, port});
        return this.executeWithRetries(() -> {
            String serviceName = this.getServiceName(roleServiceType.get((Object)service));
            String hostId = this.getHostId(hostname);
            RoleState roleState = this.getRoleState(serviceName, service.toString(), hostId);
            HealthSummary healthSummary = this.getHealthSummary(serviceName, service.toString(), hostId);
            return Objects.equals((Object)RoleState.STARTED, (Object)roleState) && Objects.equals((Object)HealthSummary.GOOD, (Object)healthSummary);
        });
    }

    @Override
    public void kill(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.kill(service, hostname, port);
    }

    @Override
    public void suspend(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.suspend(service, hostname, port);
    }

    @Override
    public void resume(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.hBaseClusterManager.resume(service, hostname, port);
    }

    private void performClusterManagerCommand(ClusterManager.ServiceType role, String hostname, RoleCommand command) {
        long commandId = this.executeWithRetries(() -> {
            String serviceName = this.getServiceName(roleServiceType.get((Object)role));
            String hostId = this.getHostId(hostname);
            String roleName = this.getRoleName(serviceName, role.toString(), hostId);
            return this.doRoleCommand(serviceName, roleName, command);
        });
        LOG.debug("Command {} of {} on {} submitted as commandId {}", new Object[]{command, role, hostname, commandId});
        this.waitFor(() -> this.hasCommandCompleted(commandId));
        if (!this.executeWithRetries(() -> this.hasCommandCompletedSuccessfully(commandId)).booleanValue()) {
            String msg = String.format("Command %s of %s on %s submitted as commandId %s failed.", new Object[]{command, role, hostname, commandId});
            throw new RuntimeException(msg);
        }
        LOG.debug("Command {} of {} on {} submitted as commandId {} completed successfully.", new Object[]{command, role, hostname, commandId});
    }

    private long doRoleCommand(String serviceName, String roleName, RoleCommand roleCommand) {
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").path(serviceName).path("roleCommands").path(roleCommand.toString()).build(new Object[0]);
        String body = "{ \"items\": [ \"" + roleName + "\" ] }";
        LOG.trace("Executing POST against {} with body {} ...", (Object)uri, (Object)body);
        WebTarget webTarget = this.client.target(uri);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        Response response = invocationBuilder.post(Entity.json((Object)body));
        int statusCode = response.getStatus();
        String responseBody = (String)response.readEntity(String.class);
        if (statusCode != Response.Status.OK.getStatusCode()) {
            LOG.warn("RoleCommand failed with status code {} and response body {}", (Object)statusCode, (Object)responseBody);
            throw new HTTPException(statusCode);
        }
        LOG.trace("POST against {} completed with status code {} and response body {}", new Object[]{uri, statusCode, responseBody});
        return parser.parse(responseBody).getAsJsonObject().get("items").getAsJsonArray().get(0).getAsJsonObject().get("id").getAsLong();
    }

    private HealthSummary getHealthSummary(String serviceName, String roleType, String hostId) {
        return HealthSummary.fromString(this.getRolePropertyValue(serviceName, roleType, hostId, "healthSummary"));
    }

    private String getHostId(String hostname) {
        String hostId = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("hosts").build(new Object[0]);
        JsonElement hosts = parser.parse(this.getFromURIGet(uri)).getAsJsonObject().get("items");
        if (hosts != null) {
            for (JsonElement host : hosts.getAsJsonArray()) {
                if (!host.getAsJsonObject().get("hostname").getAsString().equals(hostname)) continue;
                hostId = host.getAsJsonObject().get("hostId").getAsString();
                break;
            }
        }
        return hostId;
    }

    private String getFromURIGet(URI uri) {
        LOG.trace("Executing GET against {} ...", (Object)uri);
        Response response = this.client.target(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        int statusCode = response.getStatus();
        String responseBody = (String)response.readEntity(String.class);
        if (statusCode != Response.Status.OK.getStatusCode()) {
            LOG.warn("request failed with status code {} and response body {}", (Object)statusCode, (Object)responseBody);
            throw new HTTPException(statusCode);
        }
        LOG.trace("GET against {} completed with status code {} and response body {}", new Object[]{uri, statusCode, responseBody});
        return responseBody;
    }

    private String getRoleName(String serviceName, String roleType, String hostId) {
        return this.getRolePropertyValue(serviceName, roleType, hostId, "name");
    }

    private String getRolePropertyValue(String serviceName, String roleType, String hostId, String property) {
        String roleValue = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").path(serviceName).path("roles").build(new Object[0]);
        JsonElement roles = parser.parse(this.getFromURIGet(uri)).getAsJsonObject().get("items");
        if (roles != null) {
            for (JsonElement role : roles.getAsJsonArray()) {
                JsonObject roleObj = role.getAsJsonObject();
                if (!roleObj.get("hostRef").getAsJsonObject().get("hostId").getAsString().equals(hostId) || !roleObj.get("type").getAsString().toLowerCase(Locale.ROOT).equals(roleType.toLowerCase(Locale.ROOT))) continue;
                roleValue = roleObj.get(property).getAsString();
                break;
            }
        }
        return roleValue;
    }

    private RoleState getRoleState(ClusterManager.ServiceType service, String hostname) {
        return this.executeWithRetries(() -> {
            String serviceName = this.getServiceName(roleServiceType.get((Object)service));
            String hostId = this.getHostId(hostname);
            RoleState state = this.getRoleState(serviceName, service.toString(), hostId);
            return Objects.requireNonNull(state);
        });
    }

    private RoleState getRoleState(String serviceName, String roleType, String hostId) {
        return RoleState.fromString(this.getRolePropertyValue(serviceName, roleType, hostId, "roleState"));
    }

    private String getServiceName(Service service) {
        String serviceName = null;
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("clusters").path(this.clusterName).path("services").build(new Object[0]);
        JsonElement services = parser.parse(this.getFromURIGet(uri)).getAsJsonObject().get("items");
        if (services != null) {
            for (JsonElement serviceEntry : services.getAsJsonArray()) {
                if (!serviceEntry.getAsJsonObject().get("type").getAsString().equals(service.toString())) continue;
                serviceName = serviceEntry.getAsJsonObject().get("name").getAsString();
                break;
            }
        }
        return serviceName;
    }

    private Optional<JsonObject> getCommand(long commandId) {
        URI uri = UriBuilder.fromUri((String)this.serverHostname).path("api").path(API_VERSION).path("commands").path(Long.toString(commandId)).build(new Object[0]);
        return Optional.ofNullable(this.getFromURIGet(uri)).map(arg_0 -> ((JsonParser)parser).parse(arg_0)).map(JsonElement::getAsJsonObject);
    }

    private boolean hasCommandCompleted(long commandId) {
        return this.getCommand(commandId).map(val -> {
            boolean isActive = val.get("active").getAsBoolean();
            if (isActive) {
                LOG.debug("command {} is still active.", (Object)commandId);
            }
            return !isActive;
        }).orElse(false);
    }

    private boolean hasCommandCompletedSuccessfully(long commandId) {
        return this.getCommand(commandId).filter(val -> {
            boolean isActive = val.get("active").getAsBoolean();
            if (isActive) {
                LOG.debug("command {} is still active.", (Object)commandId);
            }
            return !isActive;
        }).map(val -> {
            boolean isSuccess = val.get("success").getAsBoolean();
            LOG.debug("command {} completed as {}.", (Object)commandId, (Object)isSuccess);
            return isSuccess;
        }).orElse(false);
    }

    private <T> T executeWithRetries(Callable<T> callable) {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (!retryCounter.shouldRetry()) {
                    throw new RuntimeException("retries exhausted", e);
                }
                LOG.debug("execution failed with exception. Retrying.", (Throwable)e);
                try {
                    retryCounter.sleepUntilNextRetry();
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    private void waitFor(Callable<Boolean> predicate) {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                if (Objects.equals(true, predicate.call())) {
                    return;
                }
            }
            catch (Exception e) {
                if (retryCounter.shouldRetry()) {
                    LOG.debug("execution failed with exception. Retrying.", (Throwable)e);
                }
                throw new RuntimeException("retries exhausted", e);
            }
            try {
                retryCounter.sleepUntilNextRetry();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Map<ClusterManager.ServiceType, Service> buildRoleServiceTypeMap() {
        HashMap<ClusterManager.ServiceType, Service> ret = new HashMap<ClusterManager.ServiceType, Service>();
        ret.put(ClusterManager.ServiceType.HADOOP_NAMENODE, Service.HDFS);
        ret.put(ClusterManager.ServiceType.HADOOP_DATANODE, Service.HDFS);
        ret.put(ClusterManager.ServiceType.HADOOP_JOBTRACKER, Service.MAPREDUCE);
        ret.put(ClusterManager.ServiceType.HADOOP_TASKTRACKER, Service.MAPREDUCE);
        ret.put(ClusterManager.ServiceType.HBASE_MASTER, Service.HBASE);
        ret.put(ClusterManager.ServiceType.HBASE_REGIONSERVER, Service.HBASE);
        return Collections.unmodifiableMap(ret);
    }

    static enum Service {
        HBASE,
        HDFS,
        MAPREDUCE;

    }

    private static enum HealthSummary {
        DISABLED,
        HISTORY_NOT_AVAILABLE,
        NOT_AVAILABLE,
        GOOD,
        CONCERNING,
        BAD;


        public static HealthSummary fromString(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return HealthSummary.valueOf(value.toUpperCase());
        }
    }

    private static enum RoleState {
        HISTORY_NOT_AVAILABLE,
        UNKNOWN,
        STARTING,
        STARTED,
        BUSY,
        STOPPING,
        STOPPED,
        NA;


        public static RoleState fromString(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            return RoleState.valueOf(value.toUpperCase());
        }
    }

    private static enum RoleCommand {
        START,
        STOP,
        RESTART;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

