/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Strings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SmallTests.class})
public class TestStrings {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStrings.class);

    @Test
    public void testAppendKeyValue() {
        Assert.assertEquals((Object)"foo, bar=baz", (Object)Strings.appendKeyValue((StringBuilder)new StringBuilder("foo"), (String)"bar", (Object)"baz").toString());
        Assert.assertEquals((Object)"bar->baz", (Object)Strings.appendKeyValue((StringBuilder)new StringBuilder(), (String)"bar", (Object)"baz", (String)"->", (String)"| ").toString());
        Assert.assertEquals((Object)"foo, bar=baz", (Object)Strings.appendKeyValue((StringBuilder)new StringBuilder("foo"), (String)"bar", (Object)"baz", (String)"=", (String)", ").toString());
        Assert.assertEquals((Object)"foo| bar->baz", (Object)Strings.appendKeyValue((StringBuilder)new StringBuilder("foo"), (String)"bar", (Object)"baz", (String)"->", (String)"| ").toString());
    }

    @Test
    public void testDomainNamePointerToHostName() {
        Assert.assertNull((Object)Strings.domainNamePointerToHostName(null));
        Assert.assertEquals((Object)"foo", (Object)Strings.domainNamePointerToHostName((String)"foo"));
        Assert.assertEquals((Object)"foo.com", (Object)Strings.domainNamePointerToHostName((String)"foo.com"));
        Assert.assertEquals((Object)"foo.bar.com", (Object)Strings.domainNamePointerToHostName((String)"foo.bar.com"));
        Assert.assertEquals((Object)"foo.bar.com", (Object)Strings.domainNamePointerToHostName((String)"foo.bar.com."));
    }

    @Test
    public void testPadFront() {
        Assert.assertEquals((Object)"ddfoo", (Object)Strings.padFront((String)"foo", (char)'d', (int)5));
        this.thrown.expect(IllegalArgumentException.class);
        Strings.padFront((String)"foo", (char)'d', (int)1);
    }
}

