/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.HBaseTrustManager;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHBaseTrustManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseTrustManager.class);
    private static KeyPair keyPair;
    private X509ExtendedTrustManager mockX509ExtendedTrustManager;
    private static final String IP_ADDRESS = "127.0.0.1";
    private static final String HOSTNAME = "localhost";
    private InetAddress mockInetAddressWithoutHostname;
    private InetAddress mockInetAddressWithHostname;
    private Socket mockSocketWithoutHostname;
    private Socket mockSocketWithHostname;

    @BeforeClass
    public static void createKeyPair() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(4096);
        keyPair = keyPairGenerator.genKeyPair();
    }

    @AfterClass
    public static void removeBouncyCastleProvider() throws Exception {
        Security.removeProvider("BC");
    }

    @Before
    public void setup() throws Exception {
        this.mockX509ExtendedTrustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        this.mockInetAddressWithoutHostname = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.mockInetAddressWithoutHostname.getHostAddress()).thenAnswer(invocationOnMock -> IP_ADDRESS);
        Mockito.when((Object)this.mockInetAddressWithoutHostname.toString()).thenAnswer(invocationOnMock -> "/127.0.0.1");
        this.mockInetAddressWithHostname = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.mockInetAddressWithHostname.getHostAddress()).thenAnswer(invocationOnMock -> IP_ADDRESS);
        Mockito.when((Object)this.mockInetAddressWithHostname.getHostName()).thenAnswer(invocationOnMock -> HOSTNAME);
        Mockito.when((Object)this.mockInetAddressWithHostname.toString()).thenAnswer(invocationOnMock -> "localhost/127.0.0.1");
        this.mockSocketWithoutHostname = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)this.mockSocketWithoutHostname.getInetAddress()).thenAnswer(invocationOnMock -> this.mockInetAddressWithoutHostname);
        this.mockSocketWithHostname = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)this.mockSocketWithHostname.getInetAddress()).thenAnswer(invocationOnMock -> this.mockInetAddressWithHostname);
    }

    private X509Certificate[] createSelfSignedCertificateChain(String ipAddress, String hostname) throws Exception {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, "NOT_LOCALHOST");
        Date notBefore = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(notBefore);
        cal.add(1, 1);
        Date notAfter = cal.getTime();
        BigInteger serialNumber = new BigInteger(128, new Random());
        X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic()).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        if (ipAddress != null) {
            generalNames.add(new GeneralName(7, ipAddress));
        }
        if (hostname != null) {
            generalNames.add(new GeneralName(2, hostname));
        }
        if (!generalNames.isEmpty()) {
            certificateBuilder.addExtension(Extension.subjectAlternativeName, true, (ASN1Encodable)new GeneralNames(generalNames.toArray(new GeneralName[0])));
        }
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        return new X509Certificate[]{new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner))};
    }

    @Test
    public void testServerHostnameVerificationWithHostnameVerificationDisabled() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, false, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(IP_ADDRESS, HOSTNAME);
        trustManager.checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testServerTrustedWithHostnameVerificationDisabled() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, false, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(IP_ADDRESS, HOSTNAME);
        trustManager.checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testServerTrustedWithHostnameVerificationEnabled() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        trustManager.checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testServerTrustedWithHostnameVerificationEnabledUsingIpAddress() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(IP_ADDRESS, null);
        trustManager.checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testServerTrustedWithHostnameVerificationEnabledNoReverseLookup() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        Assert.assertThrows(CertificateException.class, () -> trustManager.checkServerTrusted(certificateChain, null, this.mockSocketWithoutHostname));
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithoutHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithoutHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocketWithoutHostname);
    }

    @Test
    public void testServerTrustedWithHostnameVerificationEnabledWithHostnameNoReverseLookup() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        trustManager.checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkServerTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testClientTrustedWithHostnameVerificationDisabled() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, false, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        trustManager.checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testClientTrustedWithHostnameVerificationEnabled() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        trustManager.checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testClientTrustedWithHostnameVerificationEnabledUsingIpAddress() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, true);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(IP_ADDRESS, null);
        trustManager.checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
    }

    @Test
    public void testClientTrustedWithHostnameVerificationEnabledWithoutReverseLookup() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        Assert.assertThrows(CertificateException.class, () -> trustManager.checkClientTrusted(certificateChain, null, this.mockSocketWithoutHostname));
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithoutHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithoutHostname, (VerificationMode)Mockito.times((int)0))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocketWithoutHostname);
    }

    @Test
    public void testClientTrustedWithHostnameVerificationEnabledWithHostnameNoReverseLookup() throws Exception {
        HBaseTrustManager trustManager = new HBaseTrustManager(this.mockX509ExtendedTrustManager, true, false);
        X509Certificate[] certificateChain = this.createSelfSignedCertificateChain(null, HOSTNAME);
        trustManager.checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostAddress();
        ((InetAddress)Mockito.verify((Object)this.mockInetAddressWithHostname, (VerificationMode)Mockito.times((int)1))).getHostName();
        ((X509ExtendedTrustManager)Mockito.verify((Object)this.mockX509ExtendedTrustManager, (VerificationMode)Mockito.times((int)1))).checkClientTrusted(certificateChain, null, this.mockSocketWithHostname);
    }
}

