/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestPrefixFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPrefixFilter.class);
    Filter mainFilter;
    static final char FIRST_CHAR = 'a';
    static final char LAST_CHAR = 'e';
    static final String HOST_PREFIX = "org.apache.site-";

    @Before
    public void setUp() throws Exception {
        this.mainFilter = new PrefixFilter(Bytes.toBytes((String)HOST_PREFIX));
    }

    @Test
    public void testPrefixOnRow() throws Exception {
        this.prefixRowTests(this.mainFilter);
    }

    @Test
    public void testPrefixOnRowInsideWhileMatchRow() throws Exception {
        this.prefixRowTests((Filter)new WhileMatchFilter(this.mainFilter), true);
    }

    @Test
    public void testSerialization() throws Exception {
        byte[] buffer = this.mainFilter.toByteArray();
        PrefixFilter newFilter = PrefixFilter.parseFrom((byte[])buffer);
        this.prefixRowTests((Filter)newFilter);
    }

    private void prefixRowTests(Filter filter) throws Exception {
        this.prefixRowTests(filter, false);
    }

    private void prefixRowTests(Filter filter, boolean lastFilterAllRemaining) throws Exception {
        for (char c = 'a'; c <= 'e'; c = (char)(c + '\u0001')) {
            byte[] t = this.createRow(c);
            Assert.assertFalse((String)("Failed with character " + c), (boolean)filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])t)));
            Assert.assertFalse((boolean)filter.filterAllRemaining());
        }
        String yahooSite = "com.yahoo.www";
        byte[] yahooSiteBytes = Bytes.toBytes((String)yahooSite);
        KeyValue yahooSiteCell = KeyValueUtil.createFirstOnRow((byte[])yahooSiteBytes);
        Assert.assertFalse((String)("Failed with character " + yahooSite), (boolean)filter.filterRowKey((Cell)yahooSiteCell));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)yahooSiteCell));
        Assert.assertEquals((Object)lastFilterAllRemaining, (Object)filter.filterAllRemaining());
    }

    private byte[] createRow(char c) {
        return Bytes.toBytes((String)(HOST_PREFIX + Character.toString(c)));
    }

    @Test
    public void shouldProvideHintWhenKeyBefore() {
        byte[] prefix = Bytes.toBytes((String)"gg");
        PrefixFilter filter = new PrefixFilter(prefix);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"aa"));
        Assert.assertFalse((boolean)filter.filterRowKey((Cell)cell));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)cell));
        Cell actualCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)actualCellHint);
        KeyValue expectedCellHint = KeyValueUtil.createFirstOnRow((byte[])prefix);
        Assert.assertEquals((Object)expectedCellHint, (Object)actualCellHint);
        Assert.assertFalse((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void shouldProvideHintWhenKeyBeforeAndShorter() {
        byte[] prefix = Bytes.toBytes((String)"gggg");
        PrefixFilter filter = new PrefixFilter(prefix);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"aa"));
        Assert.assertFalse((boolean)filter.filterRowKey((Cell)cell));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)cell));
        Cell actualCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)actualCellHint);
        KeyValue expectedCellHint = KeyValueUtil.createFirstOnRow((byte[])prefix);
        Assert.assertEquals((Object)expectedCellHint, (Object)actualCellHint);
        Assert.assertFalse((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void shouldIncludeWhenKeyMatches() {
        PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)"gg"));
        KeyValue matchingCell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"gg"));
        Assert.assertFalse((boolean)filter.filterRowKey((Cell)matchingCell));
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)matchingCell));
        Assert.assertFalse((boolean)filter.filterAllRemaining());
        Assert.assertFalse((boolean)filter.filterRow());
    }

    @Test
    public void shouldReturnNextRowWhenKeyAfter() {
        PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)"gg"));
        KeyValue afterCell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"pp"));
        Assert.assertTrue((boolean)filter.filterRowKey((Cell)afterCell));
        Assert.assertEquals((Object)Filter.ReturnCode.NEXT_ROW, (Object)filter.filterCell((Cell)afterCell));
        Assert.assertTrue((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void shouldProvideHintWhenKeyBeforeReversed() {
        PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)"aa"));
        filter.setReversed(true);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"x"));
        Assert.assertFalse((boolean)filter.filterRowKey((Cell)cell));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)cell));
        Cell actualCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)actualCellHint);
        KeyValue expectedCellHint = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"ab"));
        Assert.assertEquals((Object)expectedCellHint, (Object)actualCellHint);
        Assert.assertFalse((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void hintShouldIncreaseLastNonMaxByteWhenReversed() {
        PrefixFilter filter = new PrefixFilter(new byte[]{97, 97, 127});
        filter.setReversed(true);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"x"));
        Assert.assertFalse((boolean)filter.filterRowKey((Cell)cell));
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterCell((Cell)cell));
        Cell actualCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)actualCellHint);
        KeyValue expectedCellHint = KeyValueUtil.createFirstOnRow((byte[])new byte[]{97, 98, 127});
        Assert.assertEquals((Object)expectedCellHint, (Object)actualCellHint);
        Assert.assertFalse((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void shouldIncludeWhenKeyMatchesReversed() {
        PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)"aa"));
        filter.setReversed(true);
        KeyValue matchingCell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"aa"));
        Assert.assertFalse((boolean)filter.filterRowKey((Cell)matchingCell));
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterCell((Cell)matchingCell));
        Assert.assertFalse((boolean)filter.filterAllRemaining());
        Assert.assertFalse((boolean)filter.filterRow());
    }

    @Test
    public void shouldReturnNextRowWhenKeyAfterReversed() {
        PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)"dd"));
        filter.setReversed(true);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"aa"));
        Assert.assertTrue((boolean)filter.filterRowKey((Cell)cell));
        Assert.assertEquals((Object)Filter.ReturnCode.NEXT_ROW, (Object)filter.filterCell((Cell)cell));
        Assert.assertTrue((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void hintShouldNotIncreaseMaxBytesWhenReversed() {
        PrefixFilter filter = new PrefixFilter(new byte[]{127, 127, 127});
        filter.setReversed(true);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"x"));
        Assert.assertTrue((boolean)filter.filterRowKey((Cell)cell));
        Assert.assertEquals((Object)Filter.ReturnCode.NEXT_ROW, (Object)filter.filterCell((Cell)cell));
        Cell actualCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)actualCellHint);
        KeyValue expectedCellHint = KeyValueUtil.createFirstOnRow((byte[])new byte[]{127, 127, 127});
        Assert.assertEquals((Object)expectedCellHint, (Object)actualCellHint);
        Assert.assertTrue((boolean)filter.filterAllRemaining());
        Assert.assertTrue((boolean)filter.filterRow());
    }

    @Test
    public void shouldNotThrowWhenCreatedWithNullPrefix() {
        PrefixFilter filter = new PrefixFilter(null);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"doesNotMatter"));
        Assert.assertNull((Object)filter.getNextCellHint((Cell)cell));
        filter.setReversed(true);
        Assert.assertNull((Object)filter.getNextCellHint((Cell)cell));
    }

    @Test
    public void shouldNotThrowWhenCreatedWithEmptyByteArrayPrefix() {
        byte[] emptyPrefix = new byte[]{};
        KeyValue emptyPrefixCell = KeyValueUtil.createFirstOnRow((byte[])emptyPrefix);
        KeyValue cell = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"doesNotMatter"));
        PrefixFilter filter = new PrefixFilter(emptyPrefix);
        Cell forwardNextCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)forwardNextCellHint);
        Assert.assertEquals((Object)emptyPrefixCell, (Object)forwardNextCellHint);
        filter.setReversed(true);
        Cell reverseNextCellHint = filter.getNextCellHint((Cell)cell);
        Assert.assertNotNull((Object)reverseNextCellHint);
        Assert.assertEquals((Object)emptyPrefixCell, (Object)reverseNextCellHint);
    }
}

