/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.client.TestAsyncRegionAdminApi;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncRegionAdminApi2
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncRegionAdminApi2.class);

    @Test
    public void testGetRegionLocation() throws Exception {
        RawAsyncHBaseAdmin rawAdmin = (RawAsyncHBaseAdmin)ASYNC_CONN.getAdmin();
        TEST_UTIL.createMultiRegionTable(this.tableName, HConstants.CATALOG_FAMILY);
        AsyncTableRegionLocator locator = ASYNC_CONN.getRegionLocator(this.tableName);
        HRegionLocation regionLocation = (HRegionLocation)locator.getRegionLocation(Bytes.toBytes((String)"mmm")).get();
        RegionInfo region = regionLocation.getRegion();
        byte[] regionName = regionLocation.getRegion().getRegionName();
        HRegionLocation location = (HRegionLocation)rawAdmin.getRegionLocation(regionName).get();
        Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])location.getRegion().getRegionName()));
        location = (HRegionLocation)rawAdmin.getRegionLocation(region.getEncodedNameAsBytes()).get();
        Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])location.getRegion().getRegionName()));
    }

    @Test
    public void testSplitSwitch() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        byte[][] families = new byte[][]{FAMILY};
        int rows = 10000;
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 10000);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        int originalCount = regionLocations.size();
        this.initSplitMergeSwitch();
        Assert.assertTrue((boolean)((Boolean)this.admin.splitSwitch(false).get()));
        try {
            this.admin.split(this.tableName, Bytes.toBytes((int)5000)).join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int count = ((List)this.admin.getRegions(this.tableName).get()).size();
        Assert.assertTrue((originalCount == count ? 1 : 0) != 0);
        Assert.assertFalse((boolean)((Boolean)this.admin.splitSwitch(true).get()));
        this.admin.split(this.tableName).join();
        while ((count = ((List)this.admin.getRegions(this.tableName).get()).size()) == originalCount) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((originalCount < count ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testMergeSwitch() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        byte[][] families = new byte[][]{FAMILY};
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 1000);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        int originalCount = regionLocations.size();
        this.initSplitMergeSwitch();
        this.admin.split(this.tableName).join();
        int postSplitCount = originalCount;
        while ((postSplitCount = ((List)this.admin.getRegions(this.tableName).get()).size()) == originalCount) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((String)("originalCount=" + originalCount + ", postSplitCount=" + postSplitCount), (originalCount != postSplitCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Boolean)this.admin.mergeSwitch(false).get()));
        List regions = (List)this.admin.getRegions(this.tableName).get();
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        this.admin.mergeRegions(((RegionInfo)regions.get(0)).getRegionName(), ((RegionInfo)regions.get(1)).getRegionName(), true).join();
        int count = ((List)this.admin.getRegions(this.tableName).get()).size();
        Assert.assertTrue((String)("postSplitCount=" + postSplitCount + ", count=" + count), (postSplitCount == count ? 1 : 0) != 0);
        Assert.assertFalse((boolean)((Boolean)this.admin.mergeSwitch(true).get()));
        this.admin.mergeRegions(((RegionInfo)regions.get(0)).getRegionName(), ((RegionInfo)regions.get(1)).getRegionName(), true).join();
        count = ((List)this.admin.getRegions(this.tableName).get()).size();
        Assert.assertTrue((postSplitCount / 2 == count ? 1 : 0) != 0);
    }

    private void initSplitMergeSwitch() throws Exception {
        if (!((Boolean)this.admin.isSplitEnabled().get()).booleanValue()) {
            this.admin.splitSwitch(true).get();
        }
        if (!((Boolean)this.admin.isMergeEnabled().get()).booleanValue()) {
            this.admin.mergeSwitch(true).get();
        }
        Assert.assertTrue((boolean)((Boolean)this.admin.isSplitEnabled().get()));
        Assert.assertTrue((boolean)((Boolean)this.admin.isMergeEnabled().get()));
    }

    @Test
    public void testMergeRegions() throws Exception {
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"3"), Bytes.toBytes((String)"6")};
        this.createTableWithDefaultConf(this.tableName, splitRows);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        RegionInfo mergedChildRegion = null;
        Assert.assertEquals((long)3L, (long)regionLocations.size());
        RegionInfo regionA = ((HRegionLocation)regionLocations.get(0)).getRegion();
        RegionInfo regionB = ((HRegionLocation)regionLocations.get(1)).getRegion();
        RegionInfo regionC = ((HRegionLocation)regionLocations.get(2)).getRegion();
        this.admin.mergeRegions(regionA.getRegionName(), regionB.getRegionName(), false).get();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        Assert.assertEquals((long)2L, (long)regionLocations.size());
        for (HRegionLocation rl : regionLocations) {
            if (regionC.compareTo(rl.getRegion()) == 0) continue;
            mergedChildRegion = rl.getRegion();
            break;
        }
        Assert.assertNotNull(mergedChildRegion);
        HMaster services = TEST_UTIL.getHBaseCluster().getMaster();
        CatalogJanitor cj = services.getCatalogJanitor();
        Assert.assertTrue((cj.scan() > 0 ? 1 : 0) != 0);
        while (!services.getMasterProcedureExecutor().getActiveProcIds().isEmpty()) {
            Thread.sleep(200L);
        }
        this.admin.mergeRegions(regionC.getRegionName(), mergedChildRegion.getRegionName(), false).get();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        Assert.assertEquals((long)1L, (long)regionLocations.size());
    }

    @Test
    public void testMergeRegionsInvalidRegionCount() throws Exception {
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"3"), Bytes.toBytes((String)"6")};
        this.createTableWithDefaultConf(this.tableName, splitRows);
        List regions = (List)this.admin.getRegions(this.tableName).join();
        try {
            this.admin.mergeRegions(Collections.emptyList(), false).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        }
        try {
            this.admin.mergeRegions(regions.stream().limit(1L).map(RegionInfo::getEncodedNameAsBytes).collect(Collectors.toList()), false).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
        }
    }

    @Test
    public void testSplitTable() throws Exception {
        this.initSplitMergeSwitch();
        this.splitTest(TableName.valueOf((String)"testSplitTable"), 3000, false, null);
        this.splitTest(TableName.valueOf((String)"testSplitTableWithSplitPoint"), 3000, false, Bytes.toBytes((String)"3"));
        this.splitTest(TableName.valueOf((String)"testSplitTableRegion"), 3000, true, null);
        this.splitTest(TableName.valueOf((String)"testSplitTableRegionWithSplitPoint2"), 3000, true, Bytes.toBytes((String)"3"));
    }

    private void splitTest(TableName tableName, int rowCount, boolean isSplitRegion, byte[] splitPoint) throws Exception {
        this.createTableWithDefaultConf(tableName);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName).get();
        Assert.assertEquals((long)1L, (long)regionLocations.size());
        AsyncTable table = ASYNC_CONN.getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < rowCount; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(FAMILY, null, Bytes.toBytes((String)("value" + i)));
            puts.add(put);
        }
        table.putAll(puts).join();
        if (isSplitRegion) {
            if (splitPoint == null) {
                this.admin.splitRegion(((HRegionLocation)regionLocations.get(0)).getRegion().getRegionName()).get();
            } else {
                this.admin.splitRegion(((HRegionLocation)regionLocations.get(0)).getRegion().getRegionName(), splitPoint).get();
            }
        } else if (splitPoint == null) {
            this.admin.split(tableName).get();
        } else {
            this.admin.split(tableName, splitPoint).get();
        }
        int count = 0;
        for (int i = 0; i < 45; ++i) {
            try {
                regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)tableName).get();
                count = regionLocations.size();
                if (count >= 2) break;
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testTruncateRegion() throws Exception {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"30"), Bytes.toBytes((String)"60"), Bytes.toBytes((String)"90")};
        String family1 = "f1";
        String family2 = "f2";
        String[] sFamilies = new String[]{family1, family2};
        byte[][] bFamilies = new byte[][]{Bytes.toBytes((String)family1), Bytes.toBytes((String)family2)};
        this.createTableWithDefaultConf(this.tableName, splitKeys, (byte[][])bFamilies);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        RegionInfo regionToBeTruncated = ((HRegionLocation)regionLocations.get(0)).getRegion();
        Assert.assertEquals((long)4L, (long)regionLocations.size());
        AssignmentTestingUtil.insertData(TEST_UTIL, this.tableName, 2, 21, sFamilies);
        AssignmentTestingUtil.insertData(TEST_UTIL, this.tableName, 2, 31, sFamilies);
        AssignmentTestingUtil.insertData(TEST_UTIL, this.tableName, 2, 61, sFamilies);
        AssignmentTestingUtil.insertData(TEST_UTIL, this.tableName, 2, 91, sFamilies);
        int rowCountBeforeTruncate = TEST_UTIL.countRows(this.tableName);
        this.admin.truncateRegion(regionToBeTruncated.getRegionName()).get();
        int rowCountAfterTruncate = TEST_UTIL.countRows(this.tableName);
        Assert.assertNotEquals((long)rowCountBeforeTruncate, (long)rowCountAfterTruncate);
        int expectedRowCount = rowCountBeforeTruncate - 2;
        Assert.assertEquals((long)expectedRowCount, (long)rowCountAfterTruncate);
    }

    @Test
    public void testTruncateReplicaRegionNotAllowed() throws Exception {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"30"), Bytes.toBytes((String)"60"), Bytes.toBytes((String)"90")};
        String family1 = "f1";
        String family2 = "f2";
        byte[][] bFamilies = new byte[][]{Bytes.toBytes((String)family1), Bytes.toBytes((String)family2)};
        this.createTableWithDefaultConf(this.tableName, 2, (byte[][])splitKeys, (byte[][])bFamilies);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        RegionInfo primaryRegion = ((HRegionLocation)regionLocations.get(0)).getRegion();
        RegionInfo firstReplica = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)primaryRegion, (int)1);
        try {
            this.admin.truncateRegion(firstReplica.getRegionName()).get();
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Expected message is different", (Object)"Can't truncate replicas directly.Replicas are auto-truncated when their primary is truncated.", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testTruncateRegionsMetaTableRegionsNotAllowed() throws Exception {
        AsyncTableRegionLocator locator = ASYNC_CONN.getRegionLocator(TableName.META_TABLE_NAME);
        List regionLocations = (List)locator.getAllRegionLocations().get();
        HRegionLocation regionToBeTruncated = (HRegionLocation)regionLocations.get(0);
        try {
            this.admin.truncateRegion(regionToBeTruncated.getRegion().getRegionName()).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
            Assert.assertEquals((Object)"Can't truncate region in catalog tables", (Object)e.getCause().getMessage());
        }
    }
}

