/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.DelimitedKeyPrefixRegionSplitRestriction;
import org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitRestriction;
import org.apache.hadoop.hbase.regionserver.NoRegionSplitRestriction;
import org.apache.hadoop.hbase.regionserver.RegionSplitRestriction;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestRegionSplitRestriction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSplitRestriction.class);
    Configuration conf;
    @Mock
    TableDescriptor tableDescriptor;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.conf = new Configuration();
    }

    @Test
    public void testWhenTableDescriptorReturnsNoneType() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"None");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof NoRegionSplitRestriction));
    }

    @Test
    public void testWhenTableDescriptorReturnsKeyPrefixType() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"KeyPrefix");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof KeyPrefixRegionSplitRestriction));
    }

    @Test
    public void testWhenTableDescriptorReturnsDelimitedKeyPrefixType() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"DelimitedKeyPrefix");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof DelimitedKeyPrefixRegionSplitRestriction));
    }

    @Test
    public void testWhenConfigurationReturnsNoneType() throws IOException {
        this.conf.set("hbase.regionserver.region.split_restriction.type", "None");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof NoRegionSplitRestriction));
    }

    @Test
    public void testWhenConfigurationReturnsKeyPrefixType() throws IOException {
        this.conf.set("hbase.regionserver.region.split_restriction.type", "KeyPrefix");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof KeyPrefixRegionSplitRestriction));
    }

    @Test
    public void testWhenConfigurationReturnsDelimitedKeyPrefixType() throws IOException {
        this.conf.set("hbase.regionserver.region.split_restriction.type", "DelimitedKeyPrefix");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof DelimitedKeyPrefixRegionSplitRestriction));
    }

    @Test
    public void testWhenTableDescriptorAndConfigurationReturnNull() throws IOException {
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof NoRegionSplitRestriction));
    }

    @Test
    public void testWhenTableDescriptorReturnsInvalidType() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"Invalid");
        RegionSplitRestriction splitRestriction = RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        Assert.assertTrue((boolean)(splitRestriction instanceof NoRegionSplitRestriction));
    }

    @Test
    public void testNoneRegionSplitRestriction() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"None");
        NoRegionSplitRestriction noRegionSplitRestriction = (NoRegionSplitRestriction)RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        byte[] restrictedSplit = noRegionSplitRestriction.getRestrictedSplitPoint(Bytes.toBytes((String)"abcd"));
        Assert.assertEquals((Object)"abcd", (Object)Bytes.toString((byte[])restrictedSplit));
    }

    @Test
    public void testKeyPrefixRegionSplitRestriction() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"KeyPrefix");
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.prefix_length")).thenReturn((Object)"2");
        KeyPrefixRegionSplitRestriction keyPrefixRegionSplitRestriction = (KeyPrefixRegionSplitRestriction)RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        byte[] restrictedSplit = keyPrefixRegionSplitRestriction.getRestrictedSplitPoint(Bytes.toBytes((String)"abcd"));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])restrictedSplit));
        restrictedSplit = keyPrefixRegionSplitRestriction.getRestrictedSplitPoint(Bytes.toBytes((String)"a"));
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])restrictedSplit));
    }

    @Test
    public void testDelimitedKeyPrefixRegionSplitRestriction() throws IOException {
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.type")).thenReturn((Object)"DelimitedKeyPrefix");
        Mockito.when((Object)this.tableDescriptor.getValue("hbase.regionserver.region.split_restriction.delimiter")).thenReturn((Object)",");
        DelimitedKeyPrefixRegionSplitRestriction delimitedKeyPrefixRegionSplitRestriction = (DelimitedKeyPrefixRegionSplitRestriction)RegionSplitRestriction.create((TableDescriptor)this.tableDescriptor, (Configuration)this.conf);
        byte[] restrictedSplit = delimitedKeyPrefixRegionSplitRestriction.getRestrictedSplitPoint(Bytes.toBytes((String)"ab,cd"));
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString((byte[])restrictedSplit));
        restrictedSplit = delimitedKeyPrefixRegionSplitRestriction.getRestrictedSplitPoint(Bytes.toBytes((String)"ijk"));
        Assert.assertEquals((Object)"ijk", (Object)Bytes.toString((byte[])restrictedSplit));
    }
}

